/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.excel.importexport.visitors;

import com.savvytest.eclipse.common.util.editing.EditingUtility;
import com.savvytest.eclipse.core.model.xml.data.Array;
import com.savvytest.eclipse.core.model.xml.data.impl.DataVisitorImpl;
import com.savvytest.eclipse.core.model.xml.properties.Properties;
import com.savvytest.eclipse.core.model.xml.properties.util.PropertiesUtils;
import com.savvytest.eclipse.core.model.xml.testcase.Testcase;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.eclipse.emf.edit.domain.EditingDomain;

public abstract class AbstractImportExportVisitor
extends DataVisitorImpl {
    protected static final int HEADER_ROW = 0;
    protected static final int VALUE_ROW = 1;
    protected static final String CHECKCONDITION_SHEET_PREFIX = "CC|";
    protected static final int CC_ATTRIBUTE_ID_COLUMN = 0;
    protected static final int CC_OPERATOR_COLUMN = 1;
    protected static final int CC_VALUE_COLUMN = 2;
    protected static final int CC_NAME_COLUMN = 3;
    protected static final int CC_ERROR_MESSAGE_COLUMN = 4;
    protected static final String OPERATOR_SHEET_NAME = "savvytest|operator";
    protected static final int OPERATOR_ENUM_COLUMN = 0;
    protected static final int OPERATOR_VALUE_COLUMN = 1;
    private EditingDomain editingDomain;
    private XSSFSheet sheet;
    private Testcase testcase;
    private final DataFormatter formatter = new DataFormatter(Locale.ENGLISH);

    protected static final int getMaxArraySize(Array array) {
        Properties properties = array.getBaseType().getProperties();
        BigDecimal numberProperty = PropertiesUtils.getNumberProperty((Properties)properties, (PropertiesUtils.PropertyEnum)PropertiesUtils.PropertyEnum.OCCURS);
        return numberProperty.intValue();
    }

    public EditingDomain getEditingDomain() {
        if (this.editingDomain == null) {
            this.editingDomain = EditingUtility.createDefaultEditingDomain();
        }
        return this.editingDomain;
    }

    public void setEditingDomain(EditingDomain editingDomain) {
        this.editingDomain = editingDomain;
    }

    protected String readStringValueOfCell(int columnIndex, int rowIndex) {
        XSSFCell cell;
        XSSFRow row = this.getSheet().getRow(rowIndex);
        if (row != null && (cell = row.getCell(columnIndex)) != null) {
            return this.formatter.formatCellValue((Cell)cell);
        }
        return null;
    }

    protected Double readNumberValueOfCell(int columnIndex, int rowIndex) {
        XSSFCell cell;
        XSSFRow row = this.getSheet().getRow(rowIndex);
        if (row != null && (cell = row.getCell(columnIndex)) != null) {
            return cell.getNumericCellValue();
        }
        return null;
    }

    protected Boolean readBooleanValueOfCell(int columnIndex, int rowIndex) {
        XSSFCell cell;
        XSSFRow row = this.getSheet().getRow(rowIndex);
        if (row != null && (cell = row.getCell(columnIndex)) != null) {
            return cell.getBooleanCellValue();
        }
        return null;
    }

    protected void writeStringValueToCell(String value, int columnIndex, int rowIndex) {
        XSSFCell cell;
        XSSFRow valueRow = this.getSheet().getRow(rowIndex);
        if (valueRow == null) {
            valueRow = this.getSheet().createRow(rowIndex);
        }
        if ((cell = valueRow.getCell(columnIndex)) == null) {
            cell = valueRow.createCell(columnIndex);
        }
        cell.setCellValue(value);
    }

    protected void writeNumberValueToCell(double value, int columnIndex, int rowIndex) {
        XSSFCell cell;
        XSSFRow valueRow = this.getSheet().getRow(rowIndex);
        if (valueRow == null) {
            valueRow = this.getSheet().createRow(rowIndex);
        }
        if ((cell = valueRow.getCell(columnIndex)) == null) {
            cell = valueRow.createCell(columnIndex);
        }
        cell.setCellValue(value);
    }

    protected void writeBooleanValueToCell(boolean value, int columnIndex, int rowIndex) {
        XSSFCell cell;
        XSSFRow valueRow = this.getSheet().getRow(rowIndex);
        if (valueRow == null) {
            valueRow = this.getSheet().createRow(rowIndex);
        }
        if ((cell = valueRow.getCell(columnIndex)) == null) {
            cell = valueRow.createCell(columnIndex);
        }
        cell.setCellValue(value);
    }

    public void setSheet(XSSFSheet sheet) {
        this.sheet = sheet;
    }

    public XSSFSheet getSheet() {
        return this.sheet;
    }

    public void setTestcase(Testcase testcase) {
        this.testcase = testcase;
    }

    public Testcase getTestcase() {
        return this.testcase;
    }

    protected final class ArrayInformation {
        private final List<List<ArrayInformation>> subArrays;
        private final int column;
        private ArrayInformation parentInformation;
        private int index = -1;

        protected ArrayInformation(Array array, int column) {
            this.column = column;
            this.subArrays = new ArrayList<List<ArrayInformation>>(AbstractImportExportVisitor.getMaxArraySize(array));
        }

        protected boolean checkValidLevel(int row) {
            boolean valid = true;
            if (this.parentInformation != null) {
                String value = AbstractImportExportVisitor.this.readStringValueOfCell(this.parentInformation.column, row);
                if (value == null || value.isEmpty()) {
                    valid = true;
                } else {
                    try {
                        int index = Integer.parseInt(value);
                        valid = index - 1 == this.parentInformation.getCurrentLevel();
                    }
                    catch (NumberFormatException numberFormatException) {
                        valid = false;
                    }
                }
                valid = valid && this.parentInformation.checkValidLevel(row);
            }
            return valid;
        }

        protected void addInfo(ArrayInformation info) {
            info.parentInformation = this;
            info.index = this.getCurrentLevel();
            List<ArrayInformation> currentSubArray = this.subArrays.get(info.index);
            currentSubArray.add(info);
        }

        protected void createNewLevel() {
            this.subArrays.add(new ArrayList());
        }

        protected int getCurrentLevel() {
            return this.subArrays.size() - 1;
        }

        protected int getUsedSize(int index) {
            List<ArrayInformation> infos = this.subArrays.get(index);
            if (infos == null || infos.size() == 0) {
                return 1;
            }
            int max = 0;
            for (ArrayInformation info : infos) {
                max = Math.max(max, info.getTotalSize());
            }
            return max;
        }

        protected int getTotalSize() {
            int size = 0;
            int i = 0;
            while (i < this.subArrays.size()) {
                size += this.getUsedSize(i);
                ++i;
            }
            return size;
        }

        protected ArrayInformation getLastOfLevel(int level) {
            if (level < 0) {
                return null;
            }
            if (level == 0) {
                return this;
            }
            if (this.subArrays.isEmpty()) {
                return null;
            }
            List<ArrayInformation> infos = this.subArrays.get(this.subArrays.size() - 1);
            ArrayInformation info = infos.get(infos.size() - 1);
            return info.getLastOfLevel(level - 1);
        }
    }
}

