/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.excel.importexport.visitors;

import com.savvytest.eclipse.core.model.xml.data.PersistentData;
import com.savvytest.eclipse.core.model.xml.testcase.AssertEnum;
import com.savvytest.eclipse.core.model.xml.testcase.SimpleCheckcondition;
import com.savvytest.eclipse.core.model.xml.testcase.Testcase;
import com.savvytest.eclipse.core.model.xml.testscenario.Testscenario;
import com.savvytest.eclipse.excel.Activator;
import com.savvytest.eclipse.excel.importexport.visitors.AbstractImportExportVisitor;
import java.text.MessageFormat;
import java.util.EnumMap;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFDataValidationHelper;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExportCheckconditionsVisitor
extends AbstractImportExportVisitor {
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.excel.importexport.visitors.ExportCheckconditionsVisitor.";
    private final Testscenario testscenario;
    private final XSSFWorkbook wb;
    private int writingRow;
    private final EnumMap<AssertEnum, String> assertMap;

    private static String getClassString(String key, Object ... substitutes) {
        String translation = Activator.INSTANCE.getString(TRANSLATION_PREFIX + key);
        if (substitutes.length > 0) {
            translation = MessageFormat.format(translation, substitutes);
        }
        return translation;
    }

    public ExportCheckconditionsVisitor(Testscenario testscenario, XSSFWorkbook wb) {
        this.testscenario = testscenario;
        this.wb = wb;
        if (testscenario == null) {
            throw new IllegalArgumentException("Testscenario must not be null.");
        }
        if (wb == null) {
            throw new IllegalArgumentException("Workbook must not be null.");
        }
        this.assertMap = new EnumMap(AssertEnum.class);
        AssertEnum[] assertEnumArray = AssertEnum.values();
        int n = assertEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            AssertEnum ae = assertEnumArray[n2];
            String resourceString = "_UI_" + ae.getClass().getSimpleName() + '_' + ae.getName() + "_literal";
            String value = Activator.INSTANCE.getString(resourceString);
            this.assertMap.put(ae, value);
            ++n2;
        }
    }

    public void visit() throws Exception {
        for (Testcase testcase : this.testscenario.getTestcases().getTestcases()) {
            String name = "CC|" + testcase.getName();
            if (name.length() > 31) {
                name = name.substring(0, 31);
            }
            XSSFSheet sheet = this.wb.createSheet(name);
            this.setSheet(sheet);
            this.createCheckconditionHeader();
            this.writingRow = 1;
            for (SimpleCheckcondition scc : testcase.getCheckconditions().getSimpleCheckconditions()) {
                if (!this.writeCheckcondition(scc)) continue;
                ++this.writingRow;
            }
            this.adjustColumnSize(5);
            CellRangeAddressList cellRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL2007.getMaxRows() - 1, 1, 1);
            XSSFDataValidationHelper validationHelper = new XSSFDataValidationHelper(sheet);
            DataValidationConstraint constraint = validationHelper.createExplicitListConstraint(this.assertMap.values().toArray(new String[this.assertMap.size()]));
            DataValidation validation = validationHelper.createValidation(constraint, cellRange);
            validation.setShowErrorBox(true);
            sheet.addValidationData(validation);
            sheet.createFreezePane(0, 1);
        }
        XSSFSheet operatorSheet = this.wb.createSheet("savvytest|operator");
        this.setSheet(operatorSheet);
        this.createOperatorInformation();
        this.wb.setSheetHidden(this.wb.getSheetIndex((Sheet)operatorSheet), 2);
    }

    private void adjustColumnSize(int nrColumns) {
        XSSFSheet sheet = this.getSheet();
        int i = 0;
        while (i < nrColumns) {
            sheet.autoSizeColumn(i);
            ++i;
        }
    }

    private void createOperatorInformation() {
        this.writeStringValueToCell("Enum name", 0, 0);
        this.writeStringValueToCell("Human readable name", 1, 0);
        int row = 1;
        AssertEnum[] assertEnumArray = AssertEnum.values();
        int n = assertEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            AssertEnum ae = assertEnumArray[n2];
            this.writeStringValueToCell(ae.getName(), 0, row);
            this.writeStringValueToCell(this.assertMap.get(ae), 1, row);
            ++row;
            ++n2;
        }
        this.adjustColumnSize(2);
    }

    private void createCheckconditionHeader() {
        this.writeStringValueToCell(ExportCheckconditionsVisitor.getClassString("columnNames.attributeId", new Object[0]), 0, 0);
        this.writeStringValueToCell(ExportCheckconditionsVisitor.getClassString("columnNames.operator", new Object[0]), 1, 0);
        this.writeStringValueToCell(ExportCheckconditionsVisitor.getClassString("columnNames.value", new Object[0]), 2, 0);
        this.writeStringValueToCell(ExportCheckconditionsVisitor.getClassString("columnNames.name", new Object[0]), 3, 0);
        this.writeStringValueToCell(ExportCheckconditionsVisitor.getClassString("columnNames.errorMessage", new Object[0]), 4, 0);
    }

    private boolean writeCheckcondition(SimpleCheckcondition scc) {
        PersistentData persistentData = scc.getPersistentDataReference();
        if (persistentData == null) {
            return false;
        }
        String id = persistentData.getId();
        if (id.startsWith("input.")) {
            id = id.substring("input.".length());
        }
        this.writeStringValueToCell(id, 0, this.writingRow);
        this.writeStringValueToCell(this.assertMap.get(scc.getExpectation().getAssert()), 1, this.writingRow);
        this.writeStringValueToCell(scc.getExpectation().getValue(), 2, this.writingRow);
        this.writeStringValueToCell(scc.getName(), 3, this.writingRow);
        this.writeStringValueToCell(scc.getMessage(), 4, this.writingRow);
        return true;
    }
}

