/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.excel.importexport.visitors;

import com.savvytest.eclipse.core.model.xml.data.Boolean;
import com.savvytest.eclipse.core.model.xml.data.Data;
import com.savvytest.eclipse.core.model.xml.data.Number;
import com.savvytest.eclipse.core.model.xml.data.String;
import com.savvytest.eclipse.core.model.xml.listructure.UsageType;
import com.savvytest.eclipse.core.model.xml.properties.Properties;
import com.savvytest.eclipse.core.model.xml.properties.util.PropertiesUtils;
import com.savvytest.eclipse.core.model.xml.testcase.AssertEnum;
import com.savvytest.eclipse.core.model.xml.testcase.Expectation;
import com.savvytest.eclipse.core.model.xml.testcase.ExpectationTypeEnum;
import com.savvytest.eclipse.core.model.xml.testcase.SimpleCheckcondition;
import com.savvytest.eclipse.core.model.xml.testcase.Testcase;
import com.savvytest.eclipse.core.model.xml.testcase.TestcaseFactory;
import com.savvytest.eclipse.core.model.xml.testcase.util.TestcaseUtil;
import com.savvytest.eclipse.core.model.xml.testscenario.Testscenario;
import com.savvytest.eclipse.excel.Activator;
import com.savvytest.eclipse.excel.importexport.ExcelImportExportException;
import com.savvytest.eclipse.excel.importexport.visitors.AbstractImportExportVisitor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.eclipse.emf.ecore.util.FeatureMap;

public class ImportCheckconditionsVisitor
extends AbstractImportExportVisitor {
    private static final java.lang.String TRANSLATION_PREFIX = "com.savvytest.eclipse.excel.importexport.visitors.ImportCheckconditionsVisitor.";
    private final Testscenario testscenario;
    private final XSSFWorkbook workbook;
    private final int startingSheetIndex;
    private final Map<java.lang.String, AssertEnum> operatorMap = new HashMap<java.lang.String, AssertEnum>();
    private Map<java.lang.String, List<SimpleCheckcondition>> checkconditionsMap;
    private List<SimpleCheckcondition> persistentCheckconditionsStorage;

    private static java.lang.String getClassString(java.lang.String key, Object ... substitutes) {
        java.lang.String translation = Activator.INSTANCE.getString(TRANSLATION_PREFIX + key);
        if (substitutes.length > 0) {
            translation = MessageFormat.format(translation, substitutes);
        }
        return translation;
    }

    public ImportCheckconditionsVisitor(Testscenario testscenario, XSSFWorkbook workbook, int startingSheetIndex) {
        this.testscenario = testscenario;
        this.workbook = workbook;
        this.startingSheetIndex = startingSheetIndex;
        if (testscenario == null) {
            throw new IllegalArgumentException("Testscenario must not be null.");
        }
        if (workbook == null) {
            throw new IllegalArgumentException("Workbook must not be null.");
        }
    }

    public void visit() throws Exception {
        int testcasesSize = this.testscenario.getTestcases().getTestcases().size();
        int index = this.startingSheetIndex + testcasesSize;
        this.setSheet(this.workbook.getSheetAt(index));
        if (!this.getSheet().getSheetName().equals("savvytest|operator")) {
            java.lang.String sheetName = this.getSheet().getSheetName();
            java.lang.String technicalMessage = "The hidden operator sheet wasn't found. Expected 'savvytest|operator' but found '" + sheetName + "'.";
            java.lang.String userMessage = ImportCheckconditionsVisitor.getClassString("error.operatorSheetNotFound", new Object[0]);
            throw new ExcelImportExportException(technicalMessage, userMessage);
        }
        int i = 0;
        while (i < AssertEnum.values().length) {
            java.lang.String enumName = this.readStringValueOfCell(0, i + 1);
            java.lang.String value = this.readStringValueOfCell(1, i + 1);
            this.operatorMap.put(value, AssertEnum.getByName((java.lang.String)enumName));
            ++i;
        }
        index = this.startingSheetIndex;
        for (Testcase testcase : this.testscenario.getTestcases().getTestcases()) {
            this.setTestcase(testcase);
            this.setSheet(this.workbook.getSheetAt(index++));
            this.ensureMatchWorksheet(this.getSheet(), testcase);
            this.persistentCheckconditionsStorage = testcase.getCheckconditions().getSimpleCheckconditions();
            this.checkconditionsMap = this.getCheckconditionsMap();
            this.visit(testcase);
        }
    }

    public Object visit(FeatureMap.Entry entry) throws Exception {
        Data data = (Data)entry.getValue();
        UsageType usage = PropertiesUtils.getUsage((Properties)data.getBaseTypeExtension().getProperties());
        java.lang.Boolean filler = PropertiesUtils.getBooleanProperty((Properties)data.getBaseType().getProperties(), (PropertiesUtils.PropertyEnum)PropertiesUtils.PropertyEnum.FILLER);
        if (!(usage != UsageType.OUT && usage != UsageType.INOUT || filler != null && filler.booleanValue())) {
            return super.visit(entry);
        }
        return null;
    }

    public Object visit(String string) throws Exception {
        this.storeCheckconditions((Data)string, ExpectationTypeEnum.STRING);
        return null;
    }

    public Object visit(Number number) throws Exception {
        this.storeCheckconditions((Data)number, ExpectationTypeEnum.NUMBER);
        return null;
    }

    public Object visit(Boolean bool) throws Exception {
        this.storeCheckconditions((Data)bool, ExpectationTypeEnum.BOOLEAN);
        return null;
    }

    private void storeCheckconditions(Data data, ExpectationTypeEnum expectationType) {
        java.lang.String id = data.calculateId();
        List<SimpleCheckcondition> checkconditions = this.checkconditionsMap.get(id);
        if (checkconditions == null) {
            return;
        }
        for (SimpleCheckcondition scc : checkconditions) {
            scc.getExpectation().setType(expectationType);
            scc.setVolatileDataReference(data);
            scc.setPersistentDataReference(data.getPersistentData());
            scc.setExpression(TestcaseUtil.computeExpression((SimpleCheckcondition)scc));
            this.persistentCheckconditionsStorage.add(scc);
        }
    }

    private Map<java.lang.String, List<SimpleCheckcondition>> getCheckconditionsMap() {
        HashMap<java.lang.String, List<SimpleCheckcondition>> map = new HashMap<java.lang.String, List<SimpleCheckcondition>>();
        int i = 1;
        while (i <= this.getSheet().getLastRowNum()) {
            SimpleCheckcondition scc = TestcaseFactory.eINSTANCE.createSimpleCheckcondition();
            Expectation expectation = TestcaseFactory.eINSTANCE.createExpectation();
            scc.setExpectation(expectation);
            expectation.setAssert(this.operatorMap.get(this.readStringValueOfCell(1, i)));
            expectation.setValue(this.readStringValueOfCell(2, i));
            scc.setName(this.readStringValueOfCell(3, i));
            scc.setMessage(this.readStringValueOfCell(4, i));
            java.lang.String id = this.readStringValueOfCell(0, i);
            ArrayList<SimpleCheckcondition> checkconditions = (ArrayList<SimpleCheckcondition>)map.get(id);
            if (checkconditions == null) {
                checkconditions = new ArrayList<SimpleCheckcondition>(1);
                map.put(id, checkconditions);
            }
            checkconditions.add(scc);
            ++i;
        }
        return map;
    }

    private void ensureMatchWorksheet(XSSFSheet sheet, Testcase testcase) throws ExcelImportExportException {
        java.lang.String sheetName = sheet.getSheetName();
        java.lang.String testcaseName = "CC|" + testcase.getName();
        if (testcaseName.length() > 31) {
            testcaseName = testcaseName.substring(0, 31);
        }
        if (!sheetName.equals(testcaseName)) {
            testcaseName = testcase.getName();
            java.lang.String testscenarioName = this.testscenario.getName();
            java.lang.String technicalMessage = "The name of testcase \"" + testcaseName + "\" in testscenario \"" + testscenarioName + "\" does not correspond to the checkconditon sheet \"" + sheetName + "\" in the workbook.";
            java.lang.String userMessage = ImportCheckconditionsVisitor.getClassString("error.nameMismatchCheckconditionSheet", testcaseName, sheetName);
            throw new ExcelImportExportException(technicalMessage, userMessage);
        }
    }
}

