/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.editor.result.gui;

import com.savvytest.eclipse.common.Savvytest;
import com.savvytest.eclipse.common.SavvytestException;
import com.savvytest.eclipse.common.actions.CollapseAction;
import com.savvytest.eclipse.common.actions.ExpandAction;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.common.savvytestnature.SavvytestTypeEnum;
import com.savvytest.eclipse.core.model.xml.archive.Archive;
import com.savvytest.eclipse.core.model.xml.archive.DocumentRoot;
import com.savvytest.eclipse.core.model.xml.data.Argument;
import com.savvytest.eclipse.core.model.xml.data.Data;
import com.savvytest.eclipse.core.model.xml.data.Parameters;
import com.savvytest.eclipse.core.model.xml.properties.Properties;
import com.savvytest.eclipse.core.model.xml.properties.util.PropertiesUtils;
import com.savvytest.eclipse.core.model.xml.testcase.Testcase;
import com.savvytest.eclipse.core.model.xml.testscenario.Testscenario;
import com.savvytest.eclipse.core.model.xml.testsuite.Testsuite;
import com.savvytest.eclipse.editor.result.gui.DetailPage;
import com.savvytest.eclipse.editor.result.gui.ResultEditor;
import com.savvytest.eclipse.editor.result.gui.ResultEditorPlugin;
import com.savvytest.eclipse.editor.result.gui.ResultPage;
import java.util.HashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class SavvytestResultEditor
extends ResultEditor {
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.editor.result.gui.SavvytestResultEditor.";
    private IFile file;
    private Archive archive;
    private ResultPage resultPage;
    private DetailPage detailPage;
    private final CopyOnWriteArraySet<ISelectionChangedListener> selectionListeners = new CopyOnWriteArraySet();
    private final IResourceChangeListener resourceChangeListenerB = new IResourceChangeListener(){
        private IResource editorResource;

        private boolean isChanged(IResourceDelta delta) {
            if ((delta.getKind() & 4) == 0) {
                return false;
            }
            if ((delta.getFlags() & 0x40100) != 0 && delta.getResource().equals((Object)this.editorResource)) {
                return true;
            }
            IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta affectedChild = iResourceDeltaArray[n2];
                if (this.isChanged(affectedChild)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public void resourceChanged(IResourceChangeEvent event) {
            this.editorResource = (IResource)SavvytestResultEditor.this.getEditorInput().getAdapter(IResource.class);
            if (this.editorResource != null && this.isChanged(event.getDelta())) {
                SavvytestResultEditor.this.handleChangedResources();
            }
        }
    };

    private static String getClassString(String key) {
        return ResultEditorPlugin.getPlugin().getString(TRANSLATION_PREFIX + key);
    }

    @Override
    protected void handleChangedResources() {
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                Resource resource = (Resource)SavvytestResultEditor.this.editingDomain.getResourceSet().getResources().get(0);
                if (resource.isLoaded()) {
                    resource.unload();
                    SavvytestResultEditor.this.createModel();
                    SavvytestResultEditor.this.resultPage.handleChangedResources();
                    SavvytestResultEditor.this.detailPage.handleChangedResources();
                    if (SavvytestResultEditor.this.contentOutlineViewer != null && !SavvytestResultEditor.this.contentOutlineViewer.getControl().isDisposed()) {
                        SavvytestResultEditor.this.contentOutlineViewer.setInput((Object)SavvytestResultEditor.this.archive);
                    }
                }
            }
        });
    }

    public SavvytestResultEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListenerB, 1);
    }

    @Override
    public void createModel() {
        URI resourceURI = EditUIUtil.getURI((IEditorInput)this.getEditorInput());
        Exception exception = null;
        Resource resource = null;
        try {
            resource = this.editingDomain.getResourceSet().getResource(resourceURI, true);
            DocumentRoot doc = (DocumentRoot)resource.getContents().get(0);
            this.archive = doc.getArchive();
            this.setPartName(String.valueOf(this.archive.getTestsuite().getName()) + SavvytestResultEditor.getClassString("title"));
        }
        catch (Exception e) {
            exception = e;
            resource = this.editingDomain.getResourceSet().getResource(resourceURI, false);
        }
        Diagnostic diagnostic = this.analyzeResourceProblems(resource, exception);
        if (diagnostic.getSeverity() != 0) {
            this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, exception));
        }
        this.editingDomain.getResourceSet().eAdapters().add((Object)this.problemIndicationAdapter);
    }

    @Override
    public Diagnostic analyzeResourceProblems(Resource resource, Exception exception) {
        if (!resource.getErrors().isEmpty() || !resource.getWarnings().isEmpty()) {
            BasicDiagnostic basicDiagnostic = new BasicDiagnostic(4, "com.savvytest.eclipse.core.editor", 0, SavvytestResultEditor.getString("_UI_CreateModelError_message", resource.getURI()), new Object[]{exception == null ? resource : exception});
            basicDiagnostic.merge(EcoreUtil.computeDiagnostic((Resource)resource, (boolean)true));
            return basicDiagnostic;
        }
        if (exception != null) {
            return new BasicDiagnostic(4, "com.savvytest.eclipse.core.editor", 0, SavvytestResultEditor.getString("_UI_CreateModelError_message", resource.getURI()), new Object[]{exception});
        }
        return Diagnostic.OK_INSTANCE;
    }

    @Override
    public void init(IEditorSite site, IEditorInput editorInput) {
        super.init(site, editorInput);
        if (editorInput instanceof IFileEditorInput) {
            this.file = ((IFileEditorInput)editorInput).getFile();
        }
    }

    @Override
    public void createPages() {
        this.createModel();
        if (!this.getEditingDomain().getResourceSet().getResources().isEmpty()) {
            this.createResultPage();
            this.createDetailsPage();
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SavvytestResultEditor.this.setActivePage(0);
                }
            });
        }
        this.getContainer().addControlListener((ControlListener)new ControlAdapter(){
            boolean guard = false;

            public void controlResized(ControlEvent event) {
                if (!this.guard) {
                    this.guard = true;
                    SavvytestResultEditor.this.hideTabs();
                    this.guard = false;
                }
            }
        });
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                SavvytestResultEditor.this.updateProblemIndication();
            }
        });
        Savvytest.setDynamicHelp((String)"com.savvytest.eclipse.help.DefaultContextHelp", (Control[])new Control[]{this.getContainer()});
    }

    private void createResultPage() {
        ViewForm viewForm = this.createHeader(this.getContainer());
        this.resultPage = new ResultPage(this);
        Control page = this.resultPage.createPage((Composite)viewForm);
        viewForm.setContent(page);
        int pageIndex = this.addPage((Control)viewForm);
        this.setPageText(pageIndex, SavvytestResultEditor.getClassString("overviewPage"));
    }

    private void createDetailsPage() {
        ViewForm viewForm = this.createHeader(this.getContainer());
        this.detailPage = new DetailPage(this);
        Control page = this.detailPage.createPage((Composite)viewForm);
        viewForm.setContent(page);
        int pageIndex = this.addPage((Control)viewForm);
        this.setPageText(pageIndex, SavvytestResultEditor.getClassString("detailPage"));
    }

    private ViewForm createHeader(Composite parent) {
        HashMap<String, String> commandParameters;
        ViewForm viewForm = new ViewForm(parent, 0x800000);
        CLabel clabel = new CLabel((Composite)viewForm, 0);
        viewForm.setTopLeft((Control)clabel);
        ToolBar toolBar = new ToolBar((Composite)viewForm, 0);
        viewForm.setTopRight((Control)toolBar);
        ToolBarManager manager = new ToolBarManager(toolBar);
        CommandContributionItemParameter parameter = new CommandContributionItemParameter((IServiceLocator)this.getEditorSite(), "id", "org.eclipse.ui.newWizard", 8);
        parameter.parameters = commandParameters = new HashMap<String, String>(1);
        commandParameters.put("newWizardId", "com.savvytest.eclipse.editor.result.SavvytestCheckconditionWizardID");
        parameter.label = ResultEditorPlugin.INSTANCE.getString("com.savvytest.eclipse.editor.result.pluginxml.ExtractCheckconditionWizard.label");
        parameter.icon = ExtendedImageRegistry.INSTANCE.getImageDescriptor(ResultEditorPlugin.INSTANCE.getImage("full/obj16/ArchiveModelFile"));
        manager.add((IContributionItem)new CommandContributionItem(parameter));
        manager.update(false);
        return viewForm;
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        this.file = input instanceof IFileEditorInput ? ((IFileEditorInput)input).getFile() : null;
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        for (ISelectionChangedListener listener : this.selectionListeners) {
            listener.selectionChanged(event);
        }
        this.handleChangedResources();
    }

    @Override
    public void doSave(IProgressMonitor monitor) {
    }

    @Override
    public void doSaveAs() {
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public boolean isSaveAsAllowed() {
        return false;
    }

    public Archive getArchive() {
        return this.archive;
    }

    protected IFile findFile(String id) throws CoreException {
        IFile currentFile = null;
        if (this.file != null) {
            currentFile = this.file;
        } else {
            URI uri = this.archive.eResource().getURI();
            if (uri.isPlatform()) {
                Path path = new Path(uri.toPlatformString(true));
                currentFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
            }
        }
        if (currentFile != null && currentFile.isAccessible()) {
            IProject project = currentFile.getProject();
            return project.getFile(URI.decode((String)id));
        }
        return null;
    }

    public IEditorPart openFile(SavvytestTypeEnum type, String id) throws CoreException {
        IFile file = this.findFile(id);
        if (file == null) {
            throw new SavvytestException("File not found for: " + id);
        }
        if (!file.exists()) {
            throw new SavvytestException("File does not exist: " + file.getFullPath());
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            return window.getActivePage().openEditor((IEditorInput)new FileEditorInput(file), type.defaultEditorId);
        }
        Status status = new Status(4, ResultEditorPlugin.getPlugin().getSymbolicName(), "No active workbench window found. Eclipse seems to be not open.");
        throw new CoreException((IStatus)status);
    }

    @Override
    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListenerB);
        super.dispose();
    }

    public void printResult() {
        if (this.resultPage == null) {
            return;
        }
        this.resultPage.printResult();
    }

    @Override
    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add(listener);
    }

    @Override
    public ISelection getSelection() {
        return this.file == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)this.file);
    }

    @Override
    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }

    @Override
    public void setSelection(ISelection selection) {
    }

    @Override
    public IContentOutlinePage getContentOutlinePage() {
        if (this.contentOutlinePage == null) {
            class MyContentOutlinePage
            extends ContentOutlinePage {
                MyContentOutlinePage() {
                }

                public void createControl(Composite parent) {
                    super.createControl(parent);
                    SavvytestResultEditor.this.contentOutlineViewer = this.getTreeViewer();
                    SavvytestResultEditor.this.contentOutlineViewer.setAutoExpandLevel(3);
                    SavvytestResultEditor.this.contentOutlineViewer.getTree().setFont(SavvytestSettings.INSTANCE.getFont("com.savvytest.eclipse.common.fontNormal"));
                    SavvytestResultEditor.this.contentOutlineViewer.getTree().setForeground(SavvytestSettings.INSTANCE.getColor("com.savvytest.eclipse.common.colorForeground"));
                    SavvytestResultEditor.this.contentOutlineViewer.addSelectionChangedListener((ISelectionChangedListener)this);
                    ExpandAction expandAction = new ExpandAction(SavvytestResultEditor.this.contentOutlineViewer, false);
                    CollapseAction collapseAction = new CollapseAction(SavvytestResultEditor.this.contentOutlineViewer, false);
                    SavvytestResultEditor.this.createContextMenu((Viewer)SavvytestResultEditor.this.contentOutlineViewer, new IAction[]{expandAction, collapseAction});
                    AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider(SavvytestResultEditor.this.getAdapterFactory()){

                        public String getText(Object object) {
                            Object unwrapped = AdapterFactoryEditingDomain.unwrap((Object)object);
                            if (unwrapped instanceof Data) {
                                String alias;
                                Data data = (Data)unwrapped;
                                if (data.getBaseTypeExtension() != null && (alias = PropertiesUtils.getStringProperty((Properties)data.getBaseTypeExtension().getProperties(), (PropertiesUtils.PropertyEnum)PropertiesUtils.PropertyEnum.ALIAS)) != null && alias.length() > 0) {
                                    return alias;
                                }
                            } else if (unwrapped instanceof Argument) {
                                Argument arg = (Argument)unwrapped;
                                String name = arg.getListructure().getName();
                                if (name != null && name.length() > 0) {
                                    return String.valueOf(super.getText(object)) + ' ' + name;
                                }
                            } else if (unwrapped instanceof Parameters) {
                                Parameters param = (Parameters)unwrapped;
                                Argument arg = (Argument)param.eContainer();
                                Testcase testcase = (Testcase)arg.eContainer();
                                int index = testcase.getInputUi().indexOf((Object)arg);
                                com.savvytest.eclipse.core.model.xml.iface.Argument argI = (com.savvytest.eclipse.core.model.xml.iface.Argument)testcase.getInterface().getArguments().get(index);
                                String alias = PropertiesUtils.getStringProperty((Properties)argI.getProperties(), (PropertiesUtils.PropertyEnum)PropertiesUtils.PropertyEnum.ALIAS);
                                if (alias != null && alias.length() > 0) {
                                    return String.valueOf(super.getText(object)) + ' ' + alias;
                                }
                            }
                            return super.getText(unwrapped);
                        }
                    };
                    AdapterFactoryContentProvider contentProvider = new AdapterFactoryContentProvider((AdapterFactory)SavvytestResultEditor.this.adapterFactory){

                        public Object[] getChildren(Object object) {
                            if (object instanceof Testsuite) {
                                return ((Testsuite)object).getTestscenarios().toArray();
                            }
                            if (object instanceof Testscenario) {
                                return ((Testscenario)object).getTestcases().getTestcases().toArray();
                            }
                            if (object instanceof Testcase) {
                                return ((Testcase)object).getInputUi().toArray();
                            }
                            return super.getChildren(object);
                        }

                        public Object[] getElements(Object object) {
                            return new Object[]{((Archive)object).getTestsuite()};
                        }

                        public Object getParent(Object object) {
                            if (object instanceof Testcase) {
                                return ((Testcase)object).eContainer().eContainer();
                            }
                            return super.getParent(object);
                        }
                    };
                    SavvytestResultEditor.this.contentOutlineViewer.setContentProvider((IContentProvider)contentProvider);
                    SavvytestResultEditor.this.contentOutlineViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
                    SavvytestResultEditor.this.contentOutlineViewer.setInput((Object)SavvytestResultEditor.this.archive);
                    if (!SavvytestResultEditor.this.editingDomain.getResourceSet().getResources().isEmpty()) {
                        SavvytestResultEditor.this.contentOutlineViewer.setSelection((ISelection)new StructuredSelection(SavvytestResultEditor.this.editingDomain.getResourceSet().getResources().get(0)), true);
                    }
                }

                public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
                    super.makeContributions(menuManager, toolBarManager, statusLineManager);
                    SavvytestResultEditor.this.contentOutlineStatusLineManager = statusLineManager;
                    ExpandAction expandAllAction = new ExpandAction(SavvytestResultEditor.this.contentOutlineViewer, true);
                    expandAllAction.setId("expandAll");
                    toolBarManager.add((IAction)expandAllAction);
                    CollapseAction collapseAllAction = new CollapseAction(SavvytestResultEditor.this.contentOutlineViewer, true);
                    collapseAllAction.setId("collapseAll");
                    toolBarManager.add((IAction)collapseAllAction);
                    toolBarManager.update(true);
                }

                public void setActionBars(IActionBars actionBars) {
                    super.setActionBars(actionBars);
                    SavvytestResultEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
                }
            }
            this.contentOutlinePage = new MyContentOutlinePage();
            this.contentOutlinePage.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    SavvytestResultEditor.this.handleContentOutlineSelection(event.getSelection());
                }
            });
        }
        return this.contentOutlinePage;
    }

    @Override
    public void handleContentOutlineSelection(ISelection selection) {
        if (this.detailPage != null) {
            this.detailPage.setSelection(selection);
        }
    }

    private void createContextMenu(Viewer viewer, IAction ... actions) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        IAction[] iActionArray = actions;
        int n = actions.length;
        int n2 = 0;
        while (n2 < n) {
            IAction action = iActionArray[n2];
            contextMenu.add(action);
            ++n2;
        }
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
    }
}

