/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.editor.result.gui.wizard;

import com.savvytest.eclipse.common.actions.CollapseAction;
import com.savvytest.eclipse.common.actions.ExpandAction;
import com.savvytest.eclipse.common.util.GridDataCreator;
import com.savvytest.eclipse.common.util.InOutViewerFilter;
import com.savvytest.eclipse.common.util.editing.EditingUtility;
import com.savvytest.eclipse.core.model.xml.data.Argument;
import com.savvytest.eclipse.core.model.xml.data.Atomic;
import com.savvytest.eclipse.core.model.xml.data.ContainerData;
import com.savvytest.eclipse.core.model.xml.data.Data;
import com.savvytest.eclipse.core.model.xml.data.DataVisitor;
import com.savvytest.eclipse.core.model.xml.data.InputOutputDualism;
import com.savvytest.eclipse.core.model.xml.data.impl.UsageDataVisitor;
import com.savvytest.eclipse.core.model.xml.listructure.UsageType;
import com.savvytest.eclipse.core.model.xml.testcase.Testcase;
import com.savvytest.eclipse.core.model.xml.testscenario.Testscenario;
import com.savvytest.eclipse.editor.result.gui.DetailPage;
import com.savvytest.eclipse.editor.result.gui.ResultEditorPlugin;
import com.savvytest.eclipse.editor.result.gui.wizard.TestscenarioSelectionPage;
import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;

public class CheckconditionSelectionPage
extends WizardPage {
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.editor.result.gui.wizard.CheckconditionSelectionPage.";
    private final Map<Testscenario, Map<Testcase, Set<Atomic>>> dataMap = new LinkedHashMap<Testscenario, Map<Testcase, Set<Atomic>>>();
    private final DetailPage.DataContentProvider provider = new DetailPage.DataContentProvider(InputOutputDualism.OUTPUT);
    private TabFolder mainTab;

    private static String getClassString(String key, Object ... substitutes) {
        String translation = ResultEditorPlugin.INSTANCE.getString(TRANSLATION_PREFIX + key);
        if (substitutes.length > 0) {
            translation = MessageFormat.format(translation, substitutes);
        }
        return translation;
    }

    protected CheckconditionSelectionPage(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        Composite body = new Composite(parent, 0);
        body.setLayout((Layout)new GridLayout());
        this.setControl((Control)body);
        this.mainTab = new TabFolder(body, 0);
        this.mainTab.setLayoutData((Object)GridDataCreator.fill());
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.updateData();
            this.updateControls();
        }
        super.setVisible(visible);
    }

    void updateData() {
        this.getData().clear();
        TestscenarioSelectionPage page = (TestscenarioSelectionPage)this.getWizard().getPage("TestscenarioSelectionPage");
        for (Testscenario testscenario : page.getFiles().keySet()) {
            HashMap<Testcase, HashSet<Atomic>> dataTestcaseMap = new HashMap<Testcase, HashSet<Atomic>>();
            this.getData().put(testscenario, dataTestcaseMap);
            for (Testcase testcase : testscenario.getTestcases().getTestcases()) {
                HashSet<Atomic> atomics = new HashSet<Atomic>();
                dataTestcaseMap.put(testcase, atomics);
                CheckconditionDataVisitor visitor = new CheckconditionDataVisitor(atomics, true);
                for (Argument argument : testcase.getOutputUi()) {
                    try {
                        visitor.visit(argument);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    private void updateControls() {
        TabItem[] tabItemArray = this.mainTab.getItems();
        int n = tabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TabItem item = tabItemArray[n2];
            item.dispose();
            ++n2;
        }
        tabItemArray = this.mainTab.getChildren();
        n = tabItemArray.length;
        n2 = 0;
        while (n2 < n) {
            TabItem child = tabItemArray[n2];
            child.dispose();
            ++n2;
        }
        AdapterFactory adapterFactory = EditingUtility.createDefaultAdapterFactory();
        for (final Testscenario testscenario : this.getData().keySet()) {
            TabFolder testcaseFolder = new TabFolder((Composite)this.mainTab, 0);
            for (final Testcase testcase : testscenario.getTestcases().getTestcases()) {
                Composite comp = new Composite((Composite)testcaseFolder, 0);
                comp.setLayout((Layout)new GridLayout());
                ContainerCheckedTreeViewer viewer = new ContainerCheckedTreeViewer(comp, 512);
                viewer.setContentProvider((IContentProvider)this.provider);
                viewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(adapterFactory));
                viewer.setInput((Object)testcase.getOutputUi());
                viewer.addFilter((ViewerFilter)new InOutViewerFilter(EnumSet.complementOf(EnumSet.of(UsageType.INOUT, UsageType.OUT))));
                ICheckStateListener checkStateListener = new ICheckStateListener(){

                    public void checkStateChanged(CheckStateChangedEvent event) {
                        Set data = (Set)((Map)CheckconditionSelectionPage.this.dataMap.get(testscenario)).get(testcase);
                        CheckconditionDataVisitor visitor = new CheckconditionDataVisitor(data, event.getChecked());
                        if (event.getElement() instanceof Data) {
                            try {
                                ((Data)event.getElement()).accept((DataVisitor)visitor);
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        } else if (event.getElement() instanceof Argument) {
                            Argument argument = (Argument)event.getElement();
                            try {
                                visitor.visit(argument);
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        } else {
                            throw new IllegalArgumentException("Can't handle the given element: " + event.getElement());
                        }
                    }
                };
                viewer.addCheckStateListener(checkStateListener);
                InitialSelectionVisitor visitor = new InitialSelectionVisitor();
                for (Argument argument : testcase.getOutputUi()) {
                    try {
                        if (!((Boolean)visitor.visit(argument)).booleanValue()) continue;
                        viewer.setChecked((Object)argument, true);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                Tree tree = viewer.getTree();
                tree.setLayoutData((Object)GridDataCreator.fill());
                tree.setHeaderVisible(true);
                tree.setLinesVisible(true);
                TreeColumn structureColumn = new TreeColumn(tree, 16384);
                structureColumn.setText(CheckconditionSelectionPage.getClassString("structure", new Object[0]));
                structureColumn.setWidth(300);
                structureColumn.setResizable(true);
                TreeColumn valueColumn = new TreeColumn(tree, 16384);
                valueColumn.setText(CheckconditionSelectionPage.getClassString("value", new Object[0]));
                valueColumn.setWidth(200);
                valueColumn.setResizable(true);
                ToolBarManager manager = new ToolBarManager();
                manager.add((IAction)new ExpandAction((TreeViewer)viewer, true));
                manager.add((IAction)new CollapseAction((TreeViewer)viewer, true));
                ToolBar toolBar = manager.createControl(comp);
                toolBar.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
                toolBar.moveAbove(null);
                ExpandAction expandAction = new ExpandAction((TreeViewer)viewer, false);
                CollapseAction collapseAction = new CollapseAction((TreeViewer)viewer, false);
                this.createContextMenu((Viewer)viewer, new IAction[]{expandAction, collapseAction});
                TabItem testcaseItem = new TabItem(testcaseFolder, 0);
                testcaseItem.setText(testcase.getName());
                testcaseItem.setControl((Control)comp);
            }
            TabItem testscenarioItem = new TabItem(this.mainTab, 0);
            testscenarioItem.setText(testscenario.getName());
            testscenarioItem.setControl((Control)testcaseFolder);
        }
    }

    private void createContextMenu(Viewer viewer, IAction ... actions) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        IAction[] iActionArray = actions;
        int n = actions.length;
        int n2 = 0;
        while (n2 < n) {
            IAction action = iActionArray[n2];
            contextMenu.add(action);
            ++n2;
        }
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
    }

    public Map<Testscenario, Map<Testcase, Set<Atomic>>> getData() {
        return this.dataMap;
    }

    private static final class CheckconditionDataVisitor
    extends UsageDataVisitor {
        private final Set<Atomic> data;
        private final boolean add;

        public CheckconditionDataVisitor(Set<Atomic> data, boolean add) {
            super(EnumSet.of(UsageType.INOUT, UsageType.OUT));
            this.data = data;
            this.add = add;
        }

        protected Object visitAtomic(Atomic atomic) {
            if (this.add) {
                this.data.add(atomic);
            } else {
                this.data.remove(atomic);
            }
            return null;
        }
    }

    private static final class InitialSelectionVisitor
    extends UsageDataVisitor {
        public InitialSelectionVisitor() {
            super(EnumSet.of(UsageType.INOUT, UsageType.OUT));
        }

        public Object visit(FeatureMap map) throws Exception {
            Iterator iterator = map.iterator();
            while (iterator.hasNext()) {
                if (!((Boolean)this.visit((FeatureMap.Entry)iterator.next())).booleanValue()) continue;
                return true;
            }
            return false;
        }

        public Object visit(FeatureMap.Entry entry) throws Exception {
            Object obj = super.visit(entry);
            return obj != null ? obj : Boolean.valueOf(false);
        }

        protected Object visitContainer(ContainerData container) throws Exception {
            for (FeatureMap.Entry entry : container.getElements()) {
                if (!((Boolean)this.visit(entry)).booleanValue()) continue;
                return true;
            }
            return false;
        }

        protected Object visitAtomic(Atomic atomic) throws Exception {
            return true;
        }
    }
}

