/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.editor.result.gui.wizard;

import com.savvytest.eclipse.common.Savvytest;
import com.savvytest.eclipse.common.components.selection.SavvytestFileSelection;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.common.savvytestnature.SavvytestTypeEnum;
import com.savvytest.eclipse.common.util.editing.EditingUtility;
import com.savvytest.eclipse.common.wizards.SavvytestFileSelectionPage;
import com.savvytest.eclipse.core.model.xml.data.Array;
import com.savvytest.eclipse.core.model.xml.data.Atomic;
import com.savvytest.eclipse.core.model.xml.data.Boolean;
import com.savvytest.eclipse.core.model.xml.data.Data;
import com.savvytest.eclipse.core.model.xml.data.Number;
import com.savvytest.eclipse.core.model.xml.data.String;
import com.savvytest.eclipse.core.model.xml.data.impl.DataVisitorImpl;
import com.savvytest.eclipse.core.model.xml.data.provider.AddArrayCommand;
import com.savvytest.eclipse.core.model.xml.testcase.AssertEnum;
import com.savvytest.eclipse.core.model.xml.testcase.ExpectationTypeEnum;
import com.savvytest.eclipse.core.model.xml.testcase.SimpleCheckcondition;
import com.savvytest.eclipse.core.model.xml.testcase.Testcase;
import com.savvytest.eclipse.core.model.xml.testcase.TestcaseFactory;
import com.savvytest.eclipse.core.model.xml.testcase.util.TestcaseUtil;
import com.savvytest.eclipse.core.model.xml.testscenario.Testscenario;
import com.savvytest.eclipse.editor.result.gui.ResultEditorPlugin;
import com.savvytest.eclipse.editor.result.gui.wizard.CheckconditionSelectionPage;
import com.savvytest.eclipse.editor.result.gui.wizard.TestscenarioSelectionPage;
import com.savvytest.eclipse.editor.testscenario.gui.SavvytestTestscenarioEditor;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class ExtractCheckconditionWizard
extends Wizard
implements INewWizard {
    static final java.lang.String OUTPUT_PAGE_NAME = "OutputPage";
    static final java.lang.String TESTSCENARIO_PAGE_NAME = "TestscenarioSelectionPage";
    static final java.lang.String CHECKCONDITION_PAGE_NAME = "CheckconditionSelectionPage";
    private static final Pattern ARRAY_DEPTH_PATTERN = Pattern.compile("\\[(\\d+)\\]");
    private static final java.lang.String TRANSLATION_PREFIX = "com.savvytest.eclipse.editor.result.gui.wizard.ExtractCheckconditionWizard.";
    private IFile outputFile;
    private SavvytestFileSelectionPage outputPage;
    private TestscenarioSelectionPage testscenarioSelectionPage;
    private CheckconditionSelectionPage checkconditionSelectionPage;
    private IWorkbench workbench;

    protected static java.lang.String getClassString(java.lang.String key, Object ... substitutes) {
        java.lang.String translation = ResultEditorPlugin.INSTANCE.getString(TRANSLATION_PREFIX + key);
        if (substitutes.length > 0) {
            translation = MessageFormat.format(translation, substitutes);
        }
        return translation;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        IResource resource = this.getResource(selection);
        if (resource != null && resource.getType() == 1 && SavvytestTypeEnum.OUTPUT.isType(resource)) {
            this.outputFile = (IFile)resource;
        }
        this.createPages(resource);
    }

    public void addPages() {
        if (this.outputPage != null) {
            this.addPage((IWizardPage)this.outputPage);
        }
        this.addPage((IWizardPage)this.testscenarioSelectionPage);
        this.addPage((IWizardPage)this.checkconditionSelectionPage);
        Rectangle clientArea = Display.getCurrent().getPrimaryMonitor().getClientArea();
        this.getContainer().getShell().setSize(clientArea.width / 2, clientArea.height / 2);
    }

    public boolean performFinish() {
        Map<Testscenario, IFile> fileMap = this.testscenarioSelectionPage.getFiles();
        Map<Testscenario, Map<Testcase, Set<Atomic>>> bigAtomicsMap = this.checkconditionSelectionPage.getData();
        if (bigAtomicsMap.isEmpty()) {
            this.checkconditionSelectionPage.updateData();
        }
        AdapterFactoryEditingDomain editingDomain = EditingUtility.createDefaultEditingDomain();
        for (Testscenario testscenario : fileMap.keySet()) {
            boolean write = false;
            for (Set<Atomic> atomics : bigAtomicsMap.get(testscenario).values()) {
                if (atomics.isEmpty()) continue;
                write = true;
                break;
            }
            if (!write) continue;
            IFile file = fileMap.get(testscenario);
            Map<Testcase, Set<Atomic>> atomicsMap = bigAtomicsMap.get(testscenario);
            Testscenario loadedTestscenario = EditingUtility.loadTestscenario((IFile)file, (EditingDomain)editingDomain);
            for (Testcase testcase : loadedTestscenario.getTestcases().getTestcases()) {
                Testcase correspondingTestcase = this.findTestcase(testcase, (Collection<Testcase>)testscenario.getTestcases().getTestcases());
                if (correspondingTestcase == null) {
                    java.lang.String message = ExtractCheckconditionWizard.getClassString("error.testcaseNotFound", testcase.getName(), testscenario.getName());
                    MessageDialog.openError((Shell)this.getShell(), (java.lang.String)Savvytest.getGlobalString((java.lang.String)"error", (Object[])new Object[0]), (java.lang.String)message);
                    return false;
                }
                Set<Atomic> atomics = atomicsMap.get(correspondingTestcase);
                ArrayList<java.lang.String> ids = new ArrayList<java.lang.String>();
                for (Atomic atomic : atomics) {
                    ids.add(atomic.calculateId());
                }
                Collections.sort(ids);
                this.createCheckconditions(testcase, atomics, (EditingDomain)editingDomain);
            }
            try {
                EditingUtility.createTestscenario((IFile)file, (Testscenario)loadedTestscenario, (EditingDomain)editingDomain);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            try {
                IEditorPart editor = IDE.openEditor((IWorkbenchPage)this.workbench.getActiveWorkbenchWindow().getActivePage(), (IFile)file);
                if (!(editor instanceof SavvytestTestscenarioEditor)) continue;
                ((SavvytestTestscenarioEditor)editor).setActiveTab(SavvytestTestscenarioEditor.TestscenarioEditorTabs.SIMPLE_CHECKCONDITION);
            }
            catch (PartInitException e) {
                SavvytestSettings.INSTANCE.getLogger().log((Exception)((Object)e), (Object)this);
            }
        }
        return true;
    }

    private Testcase findTestcase(Testcase testcase, Collection<Testcase> testcases) {
        for (Testcase otherTestcase : testcases) {
            if (!testcase.getName().equals(otherTestcase.getName())) continue;
            return otherTestcase;
        }
        return null;
    }

    private void createCheckconditions(final Testcase testcase, Set<Atomic> atomics, final EditingDomain domain) {
        final HashMap<java.lang.String, Object> valueMap = new HashMap<java.lang.String, Object>(atomics.size());
        for (Atomic atomic : atomics) {
            valueMap.put(atomic.calculateId(), atomic.getEffectiveValue());
        }
        final HashMap<java.lang.String, Integer> arrayDepthMap = new HashMap<java.lang.String, Integer>();
        for (java.lang.String id : valueMap.keySet()) {
            Matcher matcher = ARRAY_DEPTH_PATTERN.matcher(id);
            while (matcher.find()) {
                java.lang.String arrayId = id.substring(0, matcher.start());
                int arraySize = Integer.parseInt(matcher.group(1)) + 1;
                Integer oldArraySize = (Integer)arrayDepthMap.get(arrayId);
                if (oldArraySize != null && arraySize <= oldArraySize) continue;
                arrayDepthMap.put(arrayId, arraySize);
            }
        }
        final HashMap<java.lang.String, SimpleCheckcondition> checkconditionsMap = new HashMap<java.lang.String, SimpleCheckcondition>();
        Iterator iter = testcase.getCheckconditions().getSimpleCheckconditions().iterator();
        while (iter.hasNext()) {
            SimpleCheckcondition checkcondition = (SimpleCheckcondition)iter.next();
            if (checkcondition.getPersistentDataReference() == null) {
                iter.remove();
                continue;
            }
            java.lang.String id = checkcondition.getPersistentDataReference().getId();
            if (id.startsWith("input.")) {
                id = id.substring("input.".length());
            }
            checkconditionsMap.put(id, checkcondition);
        }
        DataVisitorImpl visitor = new DataVisitorImpl(){

            public Object visit(Array array) throws Exception {
                java.lang.String id = array.calculateId();
                if (arrayDepthMap.containsKey(id)) {
                    int size = (Integer)arrayDepthMap.get(id);
                    while (array.getElements().size() < size) {
                        Command command = AddArrayCommand.createAddArrayCommand((EditingDomain)domain, (Array)array, (int)array.getElements().size());
                        if (!command.canExecute()) continue;
                        command.execute();
                    }
                }
                return super.visit(array);
            }

            public Object visit(Number number) throws Exception {
                return this.visit((Atomic)number, ExpectationTypeEnum.NUMBER);
            }

            public Object visit(String string) throws Exception {
                return this.visit((Atomic)string, ExpectationTypeEnum.STRING);
            }

            public Object visit(Boolean bool) throws Exception {
                return this.visit((Atomic)bool, ExpectationTypeEnum.BOOLEAN);
            }

            private Object visit(Atomic atomic, ExpectationTypeEnum type) throws Exception {
                Object value;
                java.lang.String id = atomic.calculateId();
                if (valueMap.containsKey(id) && (value = valueMap.get(id)) != null) {
                    if (checkconditionsMap.containsKey(id)) {
                        this.setCheckcondition((SimpleCheckcondition)checkconditionsMap.get(id), atomic, value, type);
                    } else {
                        this.createCheckcondition(testcase, atomic, value, type);
                    }
                }
                return null;
            }

            private void createCheckcondition(Testcase testcase2, Atomic atomic, Object value, ExpectationTypeEnum type) {
                SimpleCheckcondition checkcondition = TestcaseFactory.eINSTANCE.createSimpleCheckcondition();
                checkcondition.setName(ExtractCheckconditionWizard.getClassString("checkconditionname", atomic.getName()));
                checkcondition.setMessage(ExtractCheckconditionWizard.getClassString("checkconditionmessage", atomic.getName()));
                this.setCheckcondition(checkcondition, atomic, value, type);
                testcase2.getCheckconditions().getSimpleCheckconditions().add((Object)checkcondition);
            }

            private void setCheckcondition(SimpleCheckcondition checkcondition, Atomic atomic, Object value, ExpectationTypeEnum type) {
                checkcondition.setExpectation(TestcaseFactory.eINSTANCE.createExpectation());
                checkcondition.setVolatileDataReference((Data)atomic);
                checkcondition.setPersistentDataReference(atomic.getPersistentData());
                checkcondition.getExpectation().setAssert(AssertEnum.EQ);
                checkcondition.getExpectation().setType(type);
                checkcondition.getExpectation().setValue(value.toString());
                java.lang.String expression = TestcaseUtil.computeExpression((SimpleCheckcondition)checkcondition);
                checkcondition.setExpression(expression);
            }
        };
        try {
            visitor.visit(testcase);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void createPages(IResource initialResource) {
        if (this.outputFile == null) {
            this.outputPage = new SavvytestFileSelectionPage(OUTPUT_PAGE_NAME, 4096);
            this.outputPage.setTitle(ExtractCheckconditionWizard.getClassString("outputPage.title", new Object[0]));
            this.outputPage.setDescription(ExtractCheckconditionWizard.getClassString("outputPage.description", new Object[0]));
            final SavvytestFileSelection fileSelectionComponent = this.outputPage.getFileSelectionComponent();
            fileSelectionComponent.setTypes(new SavvytestTypeEnum[]{SavvytestTypeEnum.OUTPUT, SavvytestTypeEnum.ARCHIVE});
            fileSelectionComponent.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ExtractCheckconditionWizard.this.outputFile = fileSelectionComponent.getSelectedFile();
                    if (ExtractCheckconditionWizard.this.outputFile != null && ExtractCheckconditionWizard.this.outputFile.exists()) {
                        ExtractCheckconditionWizard.this.outputPage.setMessage(null);
                    } else {
                        ExtractCheckconditionWizard.this.outputPage.setMessage(ExtractCheckconditionWizard.getClassString("outputPage.error.chooseFile", new Object[0]), 3);
                    }
                    ExtractCheckconditionWizard.this.outputPage.setPageComplete(ExtractCheckconditionWizard.this.outputPage.getMessage() == null);
                    ExtractCheckconditionWizard.this.testscenarioSelectionPage.setArchiveFile(ExtractCheckconditionWizard.this.outputFile);
                }
            });
            fileSelectionComponent.setInitialSelection(initialResource);
            this.outputPage.setPageComplete(false);
        }
        this.testscenarioSelectionPage = new TestscenarioSelectionPage(TESTSCENARIO_PAGE_NAME);
        this.testscenarioSelectionPage.setTitle(ExtractCheckconditionWizard.getClassString("testscenarioSelectionPage.title", new Object[0]));
        this.testscenarioSelectionPage.setDescription(ExtractCheckconditionWizard.getClassString("testscenarioSelectionPage.description", new Object[0]));
        this.testscenarioSelectionPage.setArchiveFile(this.outputFile);
        this.checkconditionSelectionPage = new CheckconditionSelectionPage(CHECKCONDITION_PAGE_NAME);
        this.checkconditionSelectionPage.setTitle(ExtractCheckconditionWizard.getClassString("checkconditionSelectionPage.title", new Object[0]));
        this.checkconditionSelectionPage.setDescription(ExtractCheckconditionWizard.getClassString("checkconditionSelectionPage.description", new Object[0]));
    }

    private IResource getResource(IStructuredSelection selection) {
        Object selectedElement;
        if (selection != null && !selection.isEmpty() && (selectedElement = selection.getFirstElement()) instanceof IResource) {
            return (IResource)selectedElement;
        }
        return null;
    }
}

