/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.editor.stub.gui;

import com.savvytest.eclipse.common.Savvytest;
import com.savvytest.eclipse.common.logging.LogLevel;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.common.util.GridDataCreator;
import com.savvytest.eclipse.common.views.DefaultEditorInformationPage;
import com.savvytest.eclipse.core.model.xml.iface.Interface;
import com.savvytest.eclipse.core.model.xml.stub.DocumentRoot;
import com.savvytest.eclipse.core.model.xml.stub.StubPackage;
import com.savvytest.eclipse.editor.stub.gui.SavvytestStubEditor;
import com.savvytest.eclipse.editor.stub.gui.StubEditorPlugin;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.HyperlinkGroup;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.ide.IDE;

public class AdditionalStubInformation
extends DefaultEditorInformationPage {
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.editor.stub.gui.AdditionalStubInformation.";
    private final SavvytestStubEditor editor;
    private EditingDomain editingDomain;
    private DocumentRoot doc;
    private Hyperlink interfaceNameHyperlink;

    private static String getClassString(String key, Object ... substitutes) {
        String translation = StubEditorPlugin.INSTANCE.getString(TRANSLATION_PREFIX + key);
        if (substitutes.length > 0) {
            translation = MessageFormat.format(translation, substitutes);
        }
        return translation;
    }

    public AdditionalStubInformation(SavvytestStubEditor editor, Composite parent, int style) {
        super(parent, style);
        this.editor = editor;
        this.editingDomain = editor.editingDomain;
        Resource resource = (Resource)this.editingDomain.getResourceSet().getResources().get(0);
        this.doc = (DocumentRoot)resource.getContents().get(0);
        this.enableCutCopyPasteHandler(editor.getActionBars());
    }

    protected void createControl(Composite parent) {
        super.createControl(parent);
        Composite comp = (Composite)this.scrollComp.getContent();
        Font font = SavvytestSettings.INSTANCE.getFont("com.savvytest.eclipse.common.fontNormal");
        Color color = SavvytestSettings.INSTANCE.getColor("com.savvytest.eclipse.common.colorForeground");
        Group groupTarget = new Group(comp, 16);
        groupTarget.setText(AdditionalStubInformation.getClassString("groupinterface", new Object[0]));
        groupTarget.setLayoutData((Object)GridDataCreator.horizontalFill());
        groupTarget.setLayout((Layout)new FillLayout());
        groupTarget.setFont(font);
        groupTarget.setForeground(color);
        Interface iface = this.doc.getStub().getInterface();
        String link = iface.getAlias();
        if (link == null) {
            SavvytestSettings.INSTANCE.getLogger().log("No alias set, using name instead", LogLevel.DEBUG, (Object)this);
            link = iface.getName();
        }
        link = String.valueOf(link) + " (" + URI.decode((String)iface.getId()) + ")";
        this.interfaceNameHyperlink = new Hyperlink((Composite)groupTarget, 0);
        this.interfaceNameHyperlink.setText(link);
        this.interfaceNameHyperlink.setHref((Object)iface.eResource().getURI());
        this.interfaceNameHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent event) {
                URI uri = (URI)AdditionalStubInformation.this.interfaceNameHyperlink.getHref();
                if (uri == null) {
                    return;
                }
                if (uri.isPlatformResource()) {
                    String platformString = uri.toPlatformString(true);
                    IFile file = (IFile)ResourcesPlugin.getWorkspace().getRoot().findMember(platformString);
                    try {
                        IDE.openEditor((IWorkbenchPage)AdditionalStubInformation.this.editor.getSite().getPage(), (IFile)file);
                    }
                    catch (PartInitException e) {
                        MessageDialog.openError((Shell)AdditionalStubInformation.this.editor.getSite().getShell(), (String)Savvytest.getGlobalString((String)"error", (Object[])new Object[0]), (String)AdditionalStubInformation.getClassString("openeditorfailed", new Object[]{platformString, e.getLocalizedMessage()}));
                        SavvytestSettings.INSTANCE.getLogger().log((Exception)((Object)e), (Object)this);
                    }
                }
            }
        });
        HyperlinkGroup hyperlinkGroup = new HyperlinkGroup(groupTarget.getDisplay());
        hyperlinkGroup.add(this.interfaceNameHyperlink);
        this.scrollComp.setMinSize(comp.computeSize(-1, -1, true));
    }

    protected EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    protected EObject getSavvyNameOwner() {
        return this.doc.getStub();
    }

    protected EObject getSavvyAliasOwner() {
        return this.doc.getStub();
    }

    protected EObject getSavvyDescriptionOwner() {
        return this.doc.getStub();
    }

    protected EStructuralFeature getSavvyNameFeature() {
        return StubPackage.Literals.STUB__NAME;
    }

    protected EStructuralFeature getSavvyAliasFeature() {
        return StubPackage.Literals.STUB__ALIAS;
    }

    protected EStructuralFeature getSavvyDescriptionFeature() {
        return StubPackage.Literals.STUB__DESCRIPTION;
    }

    protected boolean isReadOnly() {
        return this.editor.isReadOnly();
    }

    public void refresh() {
        this.editingDomain = this.editor.getEditingDomain();
        Resource resource = (Resource)this.editingDomain.getResourceSet().getResources().get(0);
        this.doc = (DocumentRoot)resource.getContents().get(0);
        if (this.init) {
            Interface iface = this.doc.getStub().getInterface();
            String link = iface.getAlias();
            if (link == null) {
                SavvytestSettings.INSTANCE.getLogger().log("No alias set, using name instead", LogLevel.DEBUG, (Object)this);
                link = iface.getName();
            }
            link = String.valueOf(link) + " (" + URI.decode((String)iface.getId()) + ")";
            this.interfaceNameHyperlink.setText(link);
            this.interfaceNameHyperlink.setHref((Object)iface.eResource().getURI());
        }
        super.refresh();
    }
}

