/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.editor.stub.gui;

import com.savvytest.eclipse.common.Savvytest;
import com.savvytest.eclipse.common.components.selection.SavvytestFileSelection;
import com.savvytest.eclipse.common.savvytestnature.ISavvytestWizardPage;
import com.savvytest.eclipse.common.savvytestnature.SavvytestTypeEnum;
import com.savvytest.eclipse.common.util.WizardPageValidator;
import com.savvytest.eclipse.common.wizards.SavvytestFileSelectionPage;
import com.savvytest.eclipse.editor.stub.gui.StubModelWizard;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SavvytestStubWizardPage
extends SavvytestFileSelectionPage
implements ISavvytestWizardPage {
    private IFile interfaceFile;
    private IProject containingProject = null;
    private StubModelWizard.StubModelWizardNewFileCreationPage filepage = null;
    private WizardPageValidator validator = null;

    public SavvytestStubWizardPage(String pageName) {
        super(pageName, 4096);
    }

    public void setInterfaceFile(IFile interfaceFile) {
        this.interfaceFile = interfaceFile;
    }

    public IFile getInterfaceFile() {
        return this.interfaceFile;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.validator = new SavvytestFileSelectionPage.FileSelectionValidator((SavvytestFileSelectionPage)this);
        final SavvytestFileSelection fileSelectionComponent = this.getFileSelectionComponent();
        fileSelectionComponent.setTypes(new SavvytestTypeEnum[]{SavvytestTypeEnum.INTERFACE});
        if (this.interfaceFile != null) {
            fileSelectionComponent.setSelection((ISelection)new StructuredSelection((Object)this.interfaceFile));
        }
        fileSelectionComponent.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SavvytestStubWizardPage.this.interfaceFile = fileSelectionComponent.getSelectedFile();
                SavvytestStubWizardPage.this.validator.validate();
            }
        });
        IWizardPage nextPage = this.getNextPage();
        if (nextPage instanceof StubModelWizard.StubModelWizardNewFileCreationPage) {
            this.filepage = (StubModelWizard.StubModelWizardNewFileCreationPage)nextPage;
        }
        this.validator.validate();
        this.validator.setDisplayError(true);
        Savvytest.setDynamicHelp((String)"com.savvytest.eclipse.help.DefaultContextHelp", (Control[])new Control[]{this.getControl()});
    }

    public void updateName(String name) {
        if (this.filepage != null) {
            this.filepage.setFileName(String.valueOf(name) + '.' + StubModelWizard.FILE_EXTENSIONS.get(0));
            this.filepage.setPageComplete(this.filepage.validatePage());
            this.filepage.getWizard().getContainer().updateButtons();
        }
    }

    public void updateProject(IProject project) {
        this.getFileSelectionComponent().setProjectRestriction(project);
        this.containingProject = project;
        if (this.validator != null) {
            this.validator.validate();
            if (this.filepage != null) {
                this.filepage.setContainerFullPath(SavvytestTypeEnum.STUB.getDefaultFolder((IResource)this.containingProject).getFullPath());
                this.filepage.setPageComplete(this.filepage.validatePage());
                this.filepage.getWizard().getContainer().updateButtons();
            }
        }
    }
}

