/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.editor.stub.gui;

import com.savvytest.eclipse.common.Savvytest;
import com.savvytest.eclipse.common.savvytestnature.DefaultSavvytestWizardPage;
import com.savvytest.eclipse.common.savvytestnature.SavvytestTypeEnum;
import com.savvytest.eclipse.core.model.xml.iface.DocumentRoot;
import com.savvytest.eclipse.core.model.xml.iface.Interface;
import com.savvytest.eclipse.core.model.xml.iface.InterfacePackage;
import com.savvytest.eclipse.core.model.xml.iface.util.InterfaceResourceFactoryImpl;
import com.savvytest.eclipse.core.model.xml.stub.Argument;
import com.savvytest.eclipse.core.model.xml.stub.Stub;
import com.savvytest.eclipse.core.model.xml.stub.StubFactory;
import com.savvytest.eclipse.core.model.xml.stub.StubPackage;
import com.savvytest.eclipse.core.model.xml.stub.provider.StubEditPlugin;
import com.savvytest.eclipse.core.model.xml.stub.util.BuildStubDataVisitor;
import com.savvytest.eclipse.editor.stub.gui.SavvytestStubWizardPage;
import com.savvytest.eclipse.editor.stub.gui.StubEditor;
import com.savvytest.eclipse.editor.stub.gui.StubEditorPlugin;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;

public class StubModelWizard
extends Wizard
implements INewWizard {
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.editor.stub.gui.StubModelWizard.";
    public static final List<String> FILE_EXTENSIONS = Collections.unmodifiableList(Arrays.asList(StubEditorPlugin.INSTANCE.getString("_UI_StubEditorFilenameExtensions").split("\\s*,\\s*")));
    public static final String FORMATTED_FILE_EXTENSIONS = StubEditorPlugin.INSTANCE.getString("_UI_StubEditorFilenameExtensions").replaceAll("\\s*,\\s*", ", ");
    protected StubPackage stubPackage = StubPackage.eINSTANCE;
    protected StubFactory stubFactory = this.stubPackage.getStubFactory();
    protected StubModelWizardNewFileCreationPage newFileCreationPage;
    protected StubModelWizardInitialObjectCreationPage initialObjectCreationPage;
    protected DefaultSavvytestWizardPage defaultPage;
    protected SavvytestStubWizardPage savvytestPage;
    protected IStructuredSelection selection;
    protected IWorkbench workbench;
    protected List<String> initialObjectNames;

    protected static String getString(String key) {
        return StubEditor.getString(key);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle(StubEditorPlugin.INSTANCE.getString("_UI_Wizard_label"));
        this.setDefaultPageImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(StubEditorPlugin.INSTANCE.getImage("full/wizban/NewStub")));
    }

    protected Collection<String> getInitialObjectNames() {
        if (this.initialObjectNames == null) {
            this.initialObjectNames = new ArrayList<String>();
            for (EStructuralFeature eStructuralFeature : ExtendedMetaData.INSTANCE.getAllElements(ExtendedMetaData.INSTANCE.getDocumentRoot((EPackage)this.stubPackage))) {
                EClass eClass;
                EClassifier eClassifier;
                if (!eStructuralFeature.isChangeable() || !((eClassifier = eStructuralFeature.getEType()) instanceof EClass) || (eClass = (EClass)eClassifier).isAbstract()) continue;
                this.initialObjectNames.add(eStructuralFeature.getName());
            }
            Collections.sort(this.initialObjectNames, CommonPlugin.INSTANCE.getComparator());
        }
        return this.initialObjectNames;
    }

    protected EObject createInitialModel() throws Exception {
        StubFactory stubFactory = StubFactory.eINSTANCE;
        Interface iface = null;
        com.savvytest.eclipse.core.model.xml.stub.DocumentRoot root = stubFactory.createDocumentRoot();
        Stub stub = stubFactory.createStub();
        root.setStub(stub);
        String version = Savvytest.getVersion();
        String creationTime = DateFormat.getDateTimeInstance(2, 2).format(Calendar.getInstance().getTime());
        String comment = MessageFormat.format(Savvytest.getGlobalString((String)"xmltimestamp", (Object[])new Object[0]), version, creationTime);
        FeatureMapUtil.addProcessingInstruction((FeatureMap)root.getMixed(), (int)0, (String)"savvytestVersion", (String)version);
        FeatureMapUtil.addComment((FeatureMap)root.getMixed(), (int)1, (String)comment);
        this.newFileCreationPage.getFileName();
        String savvyAlias = this.defaultPage.getSavvytestAlias();
        String savvyDesc = this.defaultPage.getSavvytestDescription();
        stub.setId(this.getModelFile().getProjectRelativePath().toString());
        if (savvyAlias != null) {
            stub.setAlias(savvyAlias);
        }
        if (savvyDesc != null) {
            stub.setDescription(savvyDesc);
        }
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("interface", new InterfaceResourceFactoryImpl());
        InterfacePackage.eINSTANCE.eClass();
        URI fileURI = URI.createPlatformResourceURI((String)this.savvytestPage.getInterfaceFile().getFullPath().toString(), (boolean)true);
        Resource res = resourceSet.getResource(fileURI, true);
        DocumentRoot doc = (DocumentRoot)res.getContents().get(0);
        iface = doc.getInterface();
        stub.setInterface(iface);
        int i = 0;
        while (i < iface.getArguments().size()) {
            String prefix = "output.arg" + i;
            com.savvytest.eclipse.core.model.xml.iface.Argument argument = (com.savvytest.eclipse.core.model.xml.iface.Argument)iface.getArguments().get(i);
            Argument arg = StubFactory.eINSTANCE.createArgument();
            arg.setListructure(argument.getListructure());
            com.savvytest.eclipse.core.model.xml.data.Argument dataArg = argument.getListructure().convertToArgument();
            BuildStubDataVisitor testDataVisitor = new BuildStubDataVisitor(dataArg, prefix);
            List theList = testDataVisitor.getStubData();
            arg.getDatas().addAll((Collection)theList);
            stub.getOutput().add((Object)arg);
            ++i;
        }
        if (iface.getResult() != null && iface.getResult().getListructure() != null) {
            Argument arg = StubFactory.eINSTANCE.createArgument();
            arg.setListructure(iface.getResult().getListructure());
            com.savvytest.eclipse.core.model.xml.data.Argument dataArg = iface.getResult().getListructure().convertToArgument();
            BuildStubDataVisitor testDataVisitor = new BuildStubDataVisitor(dataArg);
            List theList = testDataVisitor.getStubData();
            arg.getDatas().addAll((Collection)theList);
            stub.setResult(arg);
        }
        return root;
    }

    public boolean performFinish() {
        IFile modelFile;
        block6: {
            try {
                modelFile = this.getModelFile();
                WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                    protected void execute(IProgressMonitor progressMonitor) {
                        try {
                            try {
                                ResourceSetImpl resourceSet = new ResourceSetImpl();
                                URI fileURI = URI.createPlatformResourceURI((String)modelFile.getFullPath().toString(), (boolean)true);
                                Resource resource = resourceSet.createResource(fileURI);
                                EObject rootObject = StubModelWizard.this.createInitialModel();
                                if (rootObject != null) {
                                    resource.getContents().add((Object)rootObject);
                                }
                                HashMap<String, String> options = new HashMap<String, String>();
                                options.put("ENCODING", "UTF-8");
                                resource.save(options);
                            }
                            catch (Exception exception) {
                                StubEditorPlugin.INSTANCE.log(exception);
                                progressMonitor.done();
                            }
                        }
                        finally {
                            progressMonitor.done();
                        }
                    }
                };
                this.getContainer().run(false, false, (IRunnableWithProgress)operation);
                if (modelFile.isAccessible()) break block6;
                DefaultSavvytestWizardPage.displayFileCreationErrorMessage((Shell)this.getShell());
                return true;
            }
            catch (Exception exception) {
                StubEditorPlugin.INSTANCE.log(exception);
                return false;
            }
        }
        IWorkbenchWindow workbenchWindow = this.workbench.getActiveWorkbenchWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        final IWorkbenchPart activePart = page.getActivePart();
        if (activePart instanceof ISetSelectionTarget) {
            StructuredSelection targetSelection = new StructuredSelection((Object)modelFile);
            this.getShell().getDisplay().asyncExec(new Runnable((ISelection)targetSelection){
                private final /* synthetic */ ISelection val$targetSelection;
                {
                    this.val$targetSelection = iSelection;
                }

                @Override
                public void run() {
                    ((ISetSelectionTarget)activePart).selectReveal(this.val$targetSelection);
                }
            });
        }
        try {
            page.openEditor((IEditorInput)new FileEditorInput(modelFile), this.workbench.getEditorRegistry().getDefaultEditor(modelFile.getFullPath().toString()).getId());
        }
        catch (PartInitException exception) {
            MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)StubEditorPlugin.INSTANCE.getString("_UI_OpenEditorError_label"), (String)exception.getMessage());
            return false;
        }
        return true;
    }

    public void addPages() {
        Object selectedElement;
        this.defaultPage = new DefaultSavvytestWizardPage("DefPage");
        this.defaultPage.setTitle(StubEditorPlugin.INSTANCE.getString("_UI_StubModelWizard_label"));
        this.defaultPage.setDescription(DefaultSavvytestWizardPage.DEFAULT_PAGE_DESCRIPTION);
        this.addPage((IWizardPage)this.defaultPage);
        this.savvytestPage = new SavvytestStubWizardPage("TMWInterfaceSelection");
        this.savvytestPage.setTitle(StubEditorPlugin.INSTANCE.getString("_UI_StubModelWizard_label"));
        this.savvytestPage.setDescription(StubModelWizard.getString("com.savvytest.eclipse.editor.stub.gui.StubModelWizard.savvytestpage.description"));
        this.addPage((IWizardPage)this.savvytestPage);
        this.newFileCreationPage = new StubModelWizardNewFileCreationPage("TMWNewFile", this.selection);
        this.newFileCreationPage.setTitle(StubEditorPlugin.INSTANCE.getString("_UI_StubModelWizard_label"));
        this.newFileCreationPage.setDescription(StubEditorPlugin.INSTANCE.getString("_UI_StubModelWizard_description"));
        this.newFileCreationPage.setFileExtension(FILE_EXTENSIONS.get(0));
        this.newFileCreationPage.setFileName(String.valueOf(StubEditorPlugin.INSTANCE.getString("_UI_StubEditorFilenameDefaultBase")) + "." + FILE_EXTENSIONS.get(0));
        this.addPage((IWizardPage)this.newFileCreationPage);
        IFolder container = null;
        if (this.selection != null && !this.selection.isEmpty() && (selectedElement = this.selection.getFirstElement()) instanceof IResource) {
            IResource resource = (IResource)selectedElement;
            IProject project = null;
            container = SavvytestTypeEnum.STUB.getDefaultFolder(resource);
            if (container != null) {
                project = container.getProject();
                this.defaultPage.setProject(project);
                this.defaultPage.setHideProject(true);
                this.savvytestPage.updateProject(project);
                this.newFileCreationPage.setContainerFullPath(container.getFullPath());
            }
            if (project != null) {
                switch (resource.getType()) {
                    case 1: {
                        if (SavvytestTypeEnum.INTERFACE.isType(resource)) {
                            this.savvytestPage.setInterfaceFile((IFile)resource);
                            break;
                        }
                        if (!SavvytestTypeEnum.STUB.isType(resource)) break;
                        this.newFileCreationPage.setContainerFullPath(((IFile)resource).getParent().getFullPath());
                        break;
                    }
                    case 2: {
                        if (!SavvytestTypeEnum.STUB.isType(resource)) break;
                        this.newFileCreationPage.setContainerFullPath(((IFolder)resource).getFullPath());
                    }
                }
            }
        }
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        Savvytest.setDynamicHelp((String)"com.savvytest.eclipse.help.DefaultContextHelp", (Control[])new Control[]{this.getShell()});
    }

    public IFile getModelFile() {
        return this.newFileCreationPage.getModelFile();
    }

    public class StubModelWizardInitialObjectCreationPage
    extends WizardPage {
        protected Combo initialObjectField;
        protected List<String> encodings;
        protected Combo encodingField;
        protected ModifyListener validator;

        public StubModelWizardInitialObjectCreationPage(String pageId) {
            super(pageId);
            this.validator = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    StubModelWizardInitialObjectCreationPage.this.setPageComplete(StubModelWizardInitialObjectCreationPage.this.validatePage());
                }
            };
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            layout.verticalSpacing = 12;
            composite.setLayout((Layout)layout);
            GridData data = new GridData();
            data.verticalAlignment = 4;
            data.grabExcessVerticalSpace = true;
            data.horizontalAlignment = 4;
            composite.setLayoutData((Object)data);
            Label containerLabel = new Label(composite, 16384);
            containerLabel.setText(StubEditorPlugin.INSTANCE.getString("_UI_ModelObject"));
            data = new GridData();
            data.horizontalAlignment = 4;
            containerLabel.setLayoutData((Object)data);
            this.initialObjectField = new Combo(composite, 2048);
            data = new GridData();
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            this.initialObjectField.setLayoutData((Object)data);
            for (String objectName : StubModelWizard.this.getInitialObjectNames()) {
                this.initialObjectField.add(this.getLabel(objectName));
            }
            if (this.initialObjectField.getItemCount() == 1) {
                this.initialObjectField.select(0);
            }
            this.initialObjectField.addModifyListener(this.validator);
            Label encodingLabel = new Label(composite, 16384);
            encodingLabel.setText(StubEditorPlugin.INSTANCE.getString("_UI_XMLEncoding"));
            GridData data2 = new GridData();
            data2.horizontalAlignment = 4;
            encodingLabel.setLayoutData((Object)data2);
            this.encodingField = new Combo(composite, 2048);
            data2 = new GridData();
            data2.horizontalAlignment = 4;
            data2.grabExcessHorizontalSpace = true;
            this.encodingField.setLayoutData((Object)data2);
            for (String encoding : this.getEncodings()) {
                this.encodingField.add(encoding);
            }
            this.encodingField.select(0);
            this.encodingField.addModifyListener(this.validator);
            this.setPageComplete(this.validatePage());
            this.setControl((Control)composite);
        }

        protected boolean validatePage() {
            return this.getInitialObjectName() != null && this.getEncodings().contains(this.encodingField.getText());
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible) {
                if (this.initialObjectField.getItemCount() == 1) {
                    this.initialObjectField.clearSelection();
                    this.encodingField.setFocus();
                } else {
                    this.encodingField.clearSelection();
                    this.initialObjectField.setFocus();
                }
            }
        }

        public String getInitialObjectName() {
            String label = this.initialObjectField.getText();
            for (String name : StubModelWizard.this.getInitialObjectNames()) {
                if (!this.getLabel(name).equals(label)) continue;
                return name;
            }
            return null;
        }

        public String getEncoding() {
            return this.encodingField.getText();
        }

        protected String getLabel(String featureName) {
            try {
                return StubEditPlugin.INSTANCE.getString("_UI_DocumentRoot_" + featureName + "_feature");
            }
            catch (MissingResourceException mre) {
                StubEditorPlugin.INSTANCE.log(mre);
                return featureName;
            }
        }

        protected Collection<String> getEncodings() {
            if (this.encodings == null) {
                this.encodings = new ArrayList<String>();
                StringTokenizer stringTokenizer = new StringTokenizer(StubEditorPlugin.INSTANCE.getString("_UI_XMLEncodingChoices"));
                while (stringTokenizer.hasMoreTokens()) {
                    this.encodings.add(stringTokenizer.nextToken());
                }
            }
            return this.encodings;
        }
    }

    public class StubModelWizardNewFileCreationPage
    extends WizardNewFileCreationPage {
        public StubModelWizardNewFileCreationPage(String pageId, IStructuredSelection selection) {
            super(pageId, selection);
        }

        protected boolean validatePage() {
            if (super.validatePage()) {
                String extension = new Path(this.getFileName()).getFileExtension();
                if (extension == null || !FILE_EXTENSIONS.contains(extension)) {
                    String key = FILE_EXTENSIONS.size() > 1 ? "_WARN_FilenameExtensions" : "_WARN_FilenameExtension";
                    this.setErrorMessage(StubEditorPlugin.INSTANCE.getString(key, new Object[]{FORMATTED_FILE_EXTENSIONS}));
                    return false;
                }
                return true;
            }
            return false;
        }

        public IFile getModelFile() {
            return ResourcesPlugin.getWorkspace().getRoot().getFile(this.getContainerFullPath().append(this.getFileName()));
        }
    }
}

