/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.wsdl.wizard;

import com.savvytest.eclipse.common.logging.LogLevel;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.common.savvytestnature.SavvytestTypeEnum;
import com.savvytest.eclipse.common.util.editing.EditingUtility;
import com.savvytest.eclipse.core.model.xml.iface.Argument;
import com.savvytest.eclipse.core.model.xml.iface.Interface;
import com.savvytest.eclipse.core.model.xml.listructure.Listructure;
import com.savvytest.eclipse.wsdl.WsdlPlugin;
import com.savvytest.eclipse.wsdl.wizard.ImportWsdlVisitor;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.Arrays;
import org.apache.woden.WSDLException;
import org.apache.woden.WSDLFactory;
import org.apache.woden.WSDLReader;
import org.apache.woden.wsdl20.Binding;
import org.apache.woden.wsdl20.Description;
import org.apache.woden.wsdl20.InterfaceMessageReference;
import org.apache.woden.wsdl20.InterfaceOperation;
import org.apache.woden.wsdl20.Service;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaSequenceMember;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class ImportWsdlOperation
extends WorkspaceModifyOperation {
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.wsdl.wizard.ImportWsdlOperation.";
    private final File wsdlFile;
    private final IFile targetFile;
    private final IFolder listructureFolder;
    private IFile replacementFile;
    private boolean overwrite;
    private Charset charset;

    private static String getClassString(String key, Object ... substitutes) {
        String translation = WsdlPlugin.INSTANCE.getString(TRANSLATION_PREFIX + key);
        if (substitutes.length > 0) {
            translation = MessageFormat.format(translation, substitutes);
        }
        return translation;
    }

    private static final String display(Description description) {
        StringBuilder builder = new StringBuilder(2048);
        builder.append("\nBindings: ");
        builder.append(description.getBindings().length);
        Binding[] bindingArray = description.getBindings();
        int n = bindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            Binding binding = bindingArray[n2];
            builder.append("\n  ");
            builder.append(binding);
            ++n2;
        }
        builder.append("\n\nInterfaces: ");
        builder.append(description.getInterfaces().length);
        bindingArray = description.getInterfaces();
        n = bindingArray.length;
        n2 = 0;
        while (n2 < n) {
            Binding iface = bindingArray[n2];
            builder.append("\n  ");
            builder.append(iface);
            builder.append("\n  Operations: ");
            builder.append(iface.getInterfaceOperations().length);
            InterfaceOperation[] interfaceOperationArray = iface.getInterfaceOperations();
            int n3 = interfaceOperationArray.length;
            int n4 = 0;
            while (n4 < n3) {
                InterfaceOperation operation = interfaceOperationArray[n4];
                builder.append("\n    ");
                builder.append(operation);
                builder.append("\n    Pattern: ");
                builder.append(operation.getMessageExchangePattern());
                builder.append("\n    Styles: ");
                builder.append(Arrays.toString(operation.getStyle()));
                builder.append("\n    Props: ");
                builder.append(Arrays.toString(operation.getExtensionProperties()));
                builder.append("\n    Faults: ");
                builder.append(Arrays.toString(operation.getInterfaceFaultReferences()));
                builder.append("\n    Messages: ");
                builder.append(operation.getInterfaceMessageReferences().length);
                InterfaceMessageReference[] interfaceMessageReferenceArray = operation.getInterfaceMessageReferences();
                int n5 = interfaceMessageReferenceArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    InterfaceMessageReference reference = interfaceMessageReferenceArray[n6];
                    builder.append("\n      ");
                    builder.append(reference);
                    builder.append("\n      Direction: ");
                    builder.append(reference.getDirection());
                    builder.append("\n      Identifier: ");
                    builder.append(reference.getFragmentIdentifier());
                    builder.append("\n      Label: ");
                    builder.append(reference.getMessageLabel());
                    builder.append("\n      Declaration: ");
                    builder.append(reference.getElementDeclaration());
                    builder.append("\n        Name: ");
                    builder.append(reference.getElementDeclaration().getName());
                    builder.append("\n        System: ");
                    builder.append(reference.getElementDeclaration().getSystem());
                    builder.append("\n        Model: ");
                    builder.append(reference.getElementDeclaration().getContentModel());
                    XmlSchemaElement element = (XmlSchemaElement)reference.getElementDeclaration().getContent();
                    ImportWsdlOperation.display(element, 8, builder);
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        builder.append("\n\nServices: ");
        builder.append(description.getServices().length);
        bindingArray = description.getServices();
        n = bindingArray.length;
        n2 = 0;
        while (n2 < n) {
            Binding service = bindingArray[n2];
            builder.append("\n  ");
            builder.append(service);
            ++n2;
        }
        return builder.toString();
    }

    private static final void display(XmlSchemaElement element, int indent, StringBuilder builder) {
        ImportWsdlOperation.indent(indent, builder);
        builder.append("Element: ");
        builder.append(element);
        ImportWsdlOperation.indent(indent + 2, builder);
        builder.append("Name: ");
        builder.append(element.getName());
        ImportWsdlOperation.display(element.getSchemaType(), indent + 2, builder);
    }

    private static final void display(XmlSchemaType schema, int indent, StringBuilder builder) {
        if (schema instanceof XmlSchemaComplexType) {
            ImportWsdlOperation.indent(indent, builder);
            XmlSchemaComplexType complex = (XmlSchemaComplexType)schema;
            builder.append("Complex Type: ");
            builder.append(complex);
            ImportWsdlOperation.indent(indent, builder);
            builder.append("Attributes: ");
            builder.append(complex.getAttributes());
            if (complex.getParticle() instanceof XmlSchemaSequence) {
                ImportWsdlOperation.indent(indent, builder);
                XmlSchemaSequence sequence = (XmlSchemaSequence)complex.getParticle();
                builder.append("Sequence");
                for (XmlSchemaSequenceMember member : sequence.getItems()) {
                    if (member instanceof XmlSchemaElement) {
                        ImportWsdlOperation.display((XmlSchemaElement)member, indent + 2, builder);
                        continue;
                    }
                    ImportWsdlOperation.indent(indent + 2, builder);
                    builder.append("Member: ");
                    builder.append(member);
                }
            } else {
                ImportWsdlOperation.indent(indent, builder);
                builder.append("Particel: ");
                builder.append(complex.getParticle());
            }
        } else if (schema instanceof XmlSchemaSimpleType) {
            ImportWsdlOperation.indent(indent, builder);
            XmlSchemaSimpleType simple = (XmlSchemaSimpleType)schema;
            builder.append("Type Name: ");
            builder.append(simple.getName());
        } else {
            ImportWsdlOperation.indent(indent, builder);
            builder.append("Schema Type: ");
            builder.append(schema);
        }
    }

    private static final void indent(int indent, StringBuilder builder) {
        builder.append('\n');
        int i = 0;
        while (i < indent) {
            builder.append(' ');
            ++i;
        }
    }

    public ImportWsdlOperation(File wsdlFile, IFile targetFile, IFolder listructureFolder) {
        this.wsdlFile = wsdlFile;
        this.targetFile = targetFile;
        this.listructureFolder = listructureFolder;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        Description description;
        AdapterFactoryEditingDomain domain = EditingUtility.createDefaultEditingDomain();
        Listructure replacementStructure = null;
        if (this.replacementFile != null) {
            replacementStructure = EditingUtility.loadListructure((IFile)this.replacementFile, (EditingDomain)domain);
        }
        try {
            WSDLFactory factory = WSDLFactory.newInstance();
            WSDLReader reader = factory.newWSDLReader();
            reader.setFeature("http://ws.apache.org/woden/features/validation", true);
            description = reader.readWSDL(URI.createFileURI((String)this.wsdlFile.getAbsolutePath()).toString());
        }
        catch (WSDLException e) {
            SavvytestSettings.INSTANCE.getLogger().log((Exception)((Object)e), (Object)this);
            String msg = ImportWsdlOperation.getClassString("errorMessageWSDL", this.wsdlFile.getName(), e.getLocalizedMessage());
            throw new InvocationTargetException(e, msg);
        }
        if (SavvytestSettings.INSTANCE.getLogLevel().ordinal() <= LogLevel.DEBUG.ordinal()) {
            SavvytestSettings.INSTANCE.getLogger().log(ImportWsdlOperation.display(description), LogLevel.DEBUG, (Object)this);
        }
        Service service = description.getServices()[0];
        ImportWsdlVisitor visitor = new ImportWsdlVisitor(replacementStructure);
        Interface iface = visitor.visitDescription(service.getInterface());
        iface.setTarget(service.getEndpoints()[0].getAddress().toString());
        try {
            for (Argument argument : iface.getArguments()) {
                Listructure listructure = argument.getListructure();
                if (replacementStructure == listructure) continue;
                IFile file = this.listructureFolder.getFile(String.valueOf(listructure.getAlias()) + "." + SavvytestTypeEnum.LISTRUCTURE.fileextension);
                listructure.setId(URI.encodeOpaquePart((String)file.getProjectRelativePath().toString(), (boolean)true));
                EditingUtility.createListructure((IFile)file, (Listructure)listructure, (EditingDomain)domain);
            }
            iface.setId(URI.encodeOpaquePart((String)this.targetFile.getProjectRelativePath().toString(), (boolean)true));
            EditingUtility.createInterface((IFile)this.targetFile, (Interface)iface, (EditingDomain)domain);
        }
        catch (Exception e) {
            SavvytestSettings.INSTANCE.getLogger().log(e, (Object)this);
            String msg = ImportWsdlOperation.getClassString("errorMessageCommon", this.wsdlFile.getName(), e.getLocalizedMessage());
            throw new InvocationTargetException(e, msg);
        }
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public IFile getReplacementFile() {
        return this.replacementFile;
    }

    public void setReplacementFile(IFile replacementFile) {
        this.replacementFile = replacementFile;
    }
}

