/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.core.model.xml.data.provider;

import com.savvytest.eclipse.core.model.xml.data.Array;
import com.savvytest.eclipse.core.model.xml.data.Atomic;
import com.savvytest.eclipse.core.model.xml.data.ContainerData;
import com.savvytest.eclipse.core.model.xml.data.Data;
import com.savvytest.eclipse.core.model.xml.data.DataPackage;
import com.savvytest.eclipse.core.model.xml.data.PersistentData;
import com.savvytest.eclipse.core.model.xml.data.provider.AbstractModifyPersistentDataCompoundCommand;
import com.savvytest.eclipse.core.model.xml.data.provider.UpdatePersistentDataIdCommand;
import com.savvytest.eclipse.core.model.xml.iface.BaseTypeExtension;
import com.savvytest.eclipse.core.model.xml.iface.Interface;
import com.savvytest.eclipse.core.model.xml.iface.util.InterfaceUtils;
import com.savvytest.eclipse.core.model.xml.listructure.ArrayType;
import com.savvytest.eclipse.core.model.xml.listructure.BaseType;
import com.savvytest.eclipse.core.model.xml.listructure.ListructurePackage;
import com.savvytest.eclipse.core.model.xml.stub.Argument;
import com.savvytest.eclipse.core.model.xml.stub.Stub;
import com.savvytest.eclipse.core.model.xml.stub.StubPackage;
import com.savvytest.eclipse.core.model.xml.testcase.Testcase;
import com.savvytest.eclipse.core.model.xml.testcase.TestcasePackage;
import com.savvytest.eclipse.core.model.xml.testcase.util.TestcaseUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public class AddArrayCommand
extends AbstractModifyPersistentDataCompoundCommand {
    private final Array array;
    private Data data;
    private Map<String, BaseTypeExtension> baseTypeExtensionMap;
    private final AddCommand baseAddCommand;
    private boolean createPersistantData = true;

    public static final Command createAddArrayCommand(EditingDomain domain, Array owner, int index) {
        ArrayType arrayType = (ArrayType)owner.getBaseType();
        if (!arrayType.getElements().isEmpty()) {
            FeatureMap.Entry entry = (FeatureMap.Entry)arrayType.getElements().get(0);
            BaseType element = (BaseType)entry.getValue();
            Data data = element.convertToData();
            return AddArrayCommand.createArrayCommand(domain, owner, data, index);
        }
        return UnexecutableCommand.INSTANCE;
    }

    public static final Command createDuplicateArrayCommand(EditingDomain domain, Array owner, Data toDuplicate, int index) {
        Data data = (Data)EcoreUtil.copy((EObject)toDuplicate);
        return AddArrayCommand.createArrayCommand(domain, owner, data, index);
    }

    private static final Command createArrayCommand(EditingDomain domain, Array owner, Data toAdd, int index) {
        int maxArraySize;
        ArrayType arrayType = (ArrayType)owner.getBaseType();
        FeatureMap.Entry entry = (FeatureMap.Entry)arrayType.getElements().get(0);
        int currentArraySize = owner.getElements().size();
        if (currentArraySize < (maxArraySize = arrayType.getLength().intValue())) {
            EReference feature = null;
            if (entry.getEStructuralFeature().equals(ListructurePackage.Literals.CONTAINER_TYPE__STRING)) {
                feature = DataPackage.Literals.CONTAINER_DATA__STRING;
            } else if (entry.getEStructuralFeature().equals(ListructurePackage.Literals.CONTAINER_TYPE__NUMBER)) {
                feature = DataPackage.Literals.CONTAINER_DATA__NUMBER;
            } else if (entry.getEStructuralFeature().equals(ListructurePackage.Literals.CONTAINER_TYPE__ARRAY)) {
                feature = DataPackage.Literals.CONTAINER_DATA__ARRAY;
            } else if (entry.getEStructuralFeature().equals(ListructurePackage.Literals.CONTAINER_TYPE__STRUCT)) {
                feature = DataPackage.Literals.CONTAINER_DATA__STRUCT;
            } else {
                System.err.println("Unknown feature to add into array: " + feature);
                return UnexecutableCommand.INSTANCE;
            }
            return new AddArrayCommand(domain, (EObject)owner, (EStructuralFeature)DataPackage.Literals.CONTAINER_DATA__ELEMENTS, Collections.singleton(FeatureMapUtil.createEntry((EStructuralFeature)feature, (Object)toAdd)), index);
        }
        return UnexecutableCommand.INSTANCE;
    }

    public AddArrayCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection<?> collection, int index) {
        super(domain, owner, feature, collection, index);
        this.resultIndex = 0;
        this.array = (Array)owner;
        if (collection.size() == 1) {
            Object element = collection.iterator().next();
            if (element instanceof FeatureMap.Entry) {
                this.data = (Data)((FeatureMap.Entry)element).getValue();
            }
            EObject parent = AddArrayCommand.getEnclosingParent(owner);
            Interface iface = AddArrayCommand.adaptToInterface(parent);
            String id = this.array.calculateId();
            int argumentIndex = AddArrayCommand.getArgumentIndex(id);
            com.savvytest.eclipse.core.model.xml.iface.Argument interfaceArgument = (com.savvytest.eclipse.core.model.xml.iface.Argument)iface.getArguments().get(argumentIndex);
            this.baseTypeExtensionMap = InterfaceUtils.createBaseTypeExtensionMap((Collection)interfaceArgument.getBaseTypeExtensions());
            this.setBaseTypeExtensions(this.data);
        }
        this.baseAddCommand = new AddCommand(domain, owner, feature, collection, index);
    }

    public boolean canExecute() {
        return this.baseAddCommand != null && this.baseAddCommand.canExecute();
    }

    public void execute() {
        this.appendAndExecute((Command)this.baseAddCommand);
        if (this.isCreatePersistantData()) {
            AbstractModifyPersistentDataCompoundCommand.ParentAdapter adapter = new AbstractModifyPersistentDataCompoundCommand.ParentAdapter(){

                @Override
                protected void adaptedToTestcase(Testcase testcase) {
                    if (AddArrayCommand.this.shouldCreateAddCommand(AddArrayCommand.this.data)) {
                        AddArrayCommand.this.appendAndExecute(AddArrayCommand.this.createAddTestcasePersistentDataCommand(testcase, AddArrayCommand.this.data));
                    }
                    TreeIterator iterator = EcoreUtil.getAllContents((EObject)AddArrayCommand.this.data, (boolean)false);
                    while (iterator.hasNext()) {
                        Data data;
                        Object o = iterator.next();
                        if (!(o instanceof Data) || !AddArrayCommand.this.shouldCreateAddCommand(data = (Data)o)) continue;
                        AddArrayCommand.this.appendAndExecute(AddArrayCommand.this.createAddTestcasePersistentDataCommand(testcase, data));
                    }
                }

                @Override
                protected void adaptedToStub(Stub stub) {
                    if (AddArrayCommand.this.shouldCreateAddCommand(AddArrayCommand.this.data)) {
                        AddArrayCommand.this.appendAndExecute(AddArrayCommand.this.createAddStubPersistentDataCommand(stub, AddArrayCommand.this.data));
                    }
                    TreeIterator iterator = EcoreUtil.getAllContents((EObject)AddArrayCommand.this.data, (boolean)false);
                    while (iterator.hasNext()) {
                        Data data;
                        Object o = iterator.next();
                        if (!(o instanceof Data) || !AddArrayCommand.this.shouldCreateAddCommand(data = (Data)o)) continue;
                        AddArrayCommand.this.appendAndExecute(AddArrayCommand.this.createAddStubPersistentDataCommand(stub, data));
                    }
                }
            };
            adapter.adapt((EObject)this.data);
            UpdatePersistentDataIdCommand updateIdCommand = new UpdatePersistentDataIdCommand(this.array, this.domain, this.index);
            updateIdCommand.setDirection(this.getDirection());
            this.appendAndExecute((Command)updateIdCommand);
        }
    }

    private void setBaseTypeExtensions(Data data) {
        if (data != null) {
            BaseType baseType = data.getBaseType();
            BaseTypeExtension baseTypeExtension = this.baseTypeExtensionMap.get(baseType.getId());
            data.setBaseTypeExtension(baseTypeExtension);
            if (data instanceof ContainerData) {
                ContainerData container = (ContainerData)data;
                for (FeatureMap.Entry entry : container.getElements()) {
                    Data child = (Data)entry.getValue();
                    this.setBaseTypeExtensions(child);
                }
            }
        }
    }

    private boolean shouldCreateAddCommand(Data data) {
        return data instanceof Atomic;
    }

    private Command createAddTestcasePersistentDataCommand(Testcase testcase, Data data) {
        BaseType baseType = data.getBaseType();
        String id = this.adaptID((EObject)testcase, data.calculateId());
        int argumentIndex = AddArrayCommand.getArgumentIndex(id);
        com.savvytest.eclipse.core.model.xml.testcase.Argument owner = this.getDirection() == AbstractModifyPersistentDataCompoundCommand.Direction.OUTPUT ? (com.savvytest.eclipse.core.model.xml.testcase.Argument)testcase.getOutput().get(argumentIndex) : (com.savvytest.eclipse.core.model.xml.testcase.Argument)testcase.getInput().get(argumentIndex);
        String value = null;
        Object obj = ((Atomic)data).getValue();
        if (obj != null) {
            value = obj.toString();
        }
        PersistentData pd = TestcaseUtil.createPersistentData((BaseType)baseType, (String)id, (String)value, (Data)data);
        return AddCommand.create((EditingDomain)this.domain, (Object)owner, (Object)TestcasePackage.Literals.ARGUMENT__DATAS, (Object)pd);
    }

    private Command createAddStubPersistentDataCommand(Stub stub, Data data) {
        BaseType baseType = data.getBaseType();
        String id = this.adaptID((EObject)stub, data.calculateId());
        int argumentIndex = AddArrayCommand.getArgumentIndex(id);
        Argument owner = (Argument)stub.getOutput().get(argumentIndex);
        String value = null;
        Object obj = ((Atomic)data).getValue();
        if (obj != null) {
            value = obj.toString();
        }
        PersistentData pd = TestcaseUtil.createPersistentData((BaseType)baseType, (String)id, (String)value, (Data)data);
        return AddCommand.create((EditingDomain)this.domain, (Object)owner, (Object)StubPackage.Literals.ARGUMENT__DATAS, (Object)pd);
    }

    public void setCreatePersistantData(boolean createPersistantData) {
        this.createPersistantData = createPersistantData;
    }

    public boolean isCreatePersistantData() {
        return this.createPersistantData;
    }
}

