/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.core.model.xml.data.provider;

import com.savvytest.eclipse.core.model.xml.data.Array;
import com.savvytest.eclipse.core.model.xml.data.Data;
import com.savvytest.eclipse.core.model.xml.data.DataPackage;
import com.savvytest.eclipse.core.model.xml.data.PersistentData;
import com.savvytest.eclipse.core.model.xml.data.provider.AbstractModifyPersistentDataCompoundCommand;
import com.savvytest.eclipse.core.model.xml.data.provider.AssignationCommand;
import com.savvytest.eclipse.core.model.xml.properties.Properties;
import com.savvytest.eclipse.core.model.xml.properties.PropertiesPackage;
import com.savvytest.eclipse.core.model.xml.properties.Property;
import com.savvytest.eclipse.core.model.xml.properties.util.PropertiesUtils;
import com.savvytest.eclipse.core.model.xml.stub.Argument;
import com.savvytest.eclipse.core.model.xml.stub.Stub;
import com.savvytest.eclipse.core.model.xml.stub.StubPackage;
import com.savvytest.eclipse.core.model.xml.testcase.Testcase;
import com.savvytest.eclipse.core.model.xml.testcase.TestcasePackage;
import java.util.Collection;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;

public class RemoveArrayCommand
extends AbstractModifyPersistentDataCompoundCommand {
    private final Array array;
    private final Data arrayElement;

    public static final Command create(EditingDomain domain, Data data) {
        EObject container = data.eContainer();
        if (!(container instanceof Array)) {
            return UnexecutableCommand.INSTANCE;
        }
        FeatureMap elements = ((Array)container).getElements();
        int i = 0;
        while (i < elements.size()) {
            Object element = AdapterFactoryEditingDomain.unwrap((Object)elements.get(i));
            if (element == data) {
                return RemoveArrayCommand.create(domain, (Array)container, i);
            }
            ++i;
        }
        return UnexecutableCommand.INSTANCE;
    }

    public static final Command create(EditingDomain domain, Array owner, int index) {
        if (index < 0 || index >= owner.getElements().size()) {
            return UnexecutableCommand.INSTANCE;
        }
        return new RemoveArrayCommand(domain, owner, index);
    }

    public RemoveArrayCommand(EditingDomain domain, Array owner, int index) {
        super(domain, (EObject)owner, (EStructuralFeature)DataPackage.Literals.CONTAINER_DATA__ELEMENTS, owner.getElements().get(index), index);
        this.array = owner;
        this.arrayElement = (Data)AdapterFactoryEditingDomain.unwrap((Object)this.value);
    }

    protected boolean prepare() {
        if (this.getCommandList().isEmpty()) {
            this.append((Command)new RemoveCommand(this.domain, this.owner, this.feature, this.value));
            this.handlePersisentData();
        }
        return super.prepare();
    }

    private void handlePersisentData() {
        EObject parent = RemoveArrayCommand.getEnclosingParent((EObject)this.array);
        final String id = this.adaptID(parent, this.arrayElement.calculateId());
        final int argIndex = RemoveArrayCommand.getArgumentIndex(id);
        AbstractModifyPersistentDataCompoundCommand.ParentAdapter adapter = new AbstractModifyPersistentDataCompoundCommand.ParentAdapter(){

            @Override
            protected void adaptedToTestcase(Testcase testcase) {
                RemoveArrayCommand.this.createTestcaseCommands(testcase, argIndex, id.substring(0, id.lastIndexOf(91) + 1));
            }

            @Override
            protected void adaptedToStub(Stub stub) {
                RemoveArrayCommand.this.createStubCommands(stub, argIndex, id.substring(0, id.lastIndexOf(91) + 1));
            }
        };
        adapter.adapt(parent);
    }

    private void createTestcaseCommands(Testcase testcase, int argIndex, String search) {
        com.savvytest.eclipse.core.model.xml.testcase.Argument argument = this.getDirection() == AbstractModifyPersistentDataCompoundCommand.Direction.OUTPUT ? (com.savvytest.eclipse.core.model.xml.testcase.Argument)testcase.getOutput().get(argIndex) : (com.savvytest.eclipse.core.model.xml.testcase.Argument)testcase.getInput().get(argIndex);
        EList datas = argument.getDatas();
        this.addPersistentDataCommands((Collection<PersistentData>)datas, search, this.index, (EObject)argument, TestcasePackage.Literals.ARGUMENT__DATAS);
    }

    private void createStubCommands(Stub stub, int argIndex, String search) {
        Argument argument = (Argument)stub.getOutput().get(argIndex);
        EList datas = argument.getDatas();
        this.addPersistentDataCommands((Collection<PersistentData>)datas, search, this.index, (EObject)argument, StubPackage.Literals.ARGUMENT__DATAS);
    }

    private void addPersistentDataCommands(Collection<PersistentData> data, String search, int removedIndex, EObject owner, EReference reference) {
        for (PersistentData pd : data) {
            int rightBracket;
            String id = pd.getId();
            if (!id.startsWith(search)) continue;
            for (Data assignationData : pd.getVolatileData().getAssignationSuppliesVolatileData()) {
                this.append((Command)new AssignationCommand(this.domain, assignationData, null));
            }
            int leftBracket = search.length() - 1;
            int index = Integer.parseInt(id.substring(leftBracket + 1, rightBracket = id.indexOf(93, search.length())));
            if (index == removedIndex) {
                this.append(this.createRemoveCommand(pd, owner, reference));
                continue;
            }
            if (index <= removedIndex) continue;
            String newID = String.valueOf(id.substring(0, leftBracket + 1)) + (index - 1) + id.substring(rightBracket);
            this.append(this.createSetCommand(pd, newID));
        }
    }

    private Command createRemoveCommand(PersistentData pd, EObject owner, EReference reference) {
        return new RemoveCommand(this.domain, owner, (EStructuralFeature)reference, (Object)pd);
    }

    private Command createSetCommand(PersistentData pd, String newID) {
        CompoundCommand cc = new CompoundCommand();
        cc.append((Command)new SetCommand(this.domain, (EObject)pd, (EStructuralFeature)DataPackage.Literals.PERSISTENT_DATA__ID, (Object)newID));
        Property prop = PropertiesUtils.getProperty((Properties)pd.getProperties(), (PropertiesUtils.PropertyEnum)PropertiesUtils.PropertyEnum.INDEX);
        cc.append((Command)new SetCommand(this.domain, (EObject)prop, (EStructuralFeature)PropertiesPackage.Literals.PROPERTY__VALUE, (Object)newID));
        return cc;
    }
}

