/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.common.actions;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;

public abstract class AbstractCommandAction
extends Action
implements IDisposable {
    protected ISelection lastSelection;
    protected Command lastCommand = UnexecutableCommand.INSTANCE;
    protected EditingDomain domain;
    private boolean wasExecuted = false;

    public AbstractCommandAction(EditingDomain domain, ISelectionProvider selectionProvider) {
        this.domain = domain;
        if (selectionProvider == null) {
            this.updateCommand(null);
        } else {
            selectionProvider.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ISelection newSelection = event.getSelection();
                    if (!newSelection.equals(AbstractCommandAction.this.lastSelection)) {
                        AbstractCommandAction.this.lastSelection = newSelection;
                        AbstractCommandAction.this.updateCommand(newSelection);
                    }
                }
            });
            this.updateCommand(selectionProvider.getSelection());
        }
    }

    public void dispose() {
        if (!this.wasExecuted) {
            this.lastCommand.dispose();
        }
    }

    protected void updateCommand(ISelection selection) {
        if (!this.wasExecuted) {
            this.lastCommand.dispose();
        }
        this.wasExecuted = false;
        this.lastCommand = this.createCommand(selection);
        this.setEnabled(this.lastCommand.canExecute());
        String displayText = this.createText(selection);
        if (displayText != null) {
            this.setText(displayText);
        }
    }

    protected abstract Command createCommand(ISelection var1);

    public String createText(ISelection selection) {
        return null;
    }

    public void run() {
        if (this.lastCommand.canExecute()) {
            this.wasExecuted = true;
            this.domain.getCommandStack().execute(this.lastCommand);
            this.notifyResult(true);
            this.updateCommand(this.lastSelection);
        } else {
            this.notifyResult(false);
        }
    }
}

