/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.common.commands;

import com.savvytest.eclipse.common.Savvytest;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AbstractOverrideableCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public class SwapCommand
extends AbstractOverrideableCommand {
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.common.commands.SwapCommand.";
    private static final String LABEL = SwapCommand.getClassString("label");
    private static final String DESCRIPTION = SwapCommand.getClassString("description");
    private EList<Object> list;
    private int index1;
    private int index2;
    private EObject owner;

    private static String getClassString(String key) {
        return Savvytest.getString(TRANSLATION_PREFIX + key, new Object[0]);
    }

    public SwapCommand(EditingDomain editingDomain, EObject owner, EStructuralFeature feature, Object value1, Object value2) {
        super(editingDomain, LABEL, DESCRIPTION);
        this.owner = owner;
        this.list = SwapCommand.getOwnerList((EObject)owner, (EStructuralFeature)feature);
        if (this.list != null) {
            int i1 = this.list.indexOf(value1);
            int i2 = this.list.indexOf(value2);
            this.index1 = Math.min(i1, i2);
            this.index2 = Math.max(i1, i2);
        }
    }

    public SwapCommand(EditingDomain editingDomain, EObject owner, EStructuralFeature feature, int index1, int index2) {
        super(editingDomain, LABEL, DESCRIPTION);
        this.owner = owner;
        this.list = SwapCommand.getOwnerList((EObject)owner, (EStructuralFeature)feature);
        this.index1 = Math.min(index1, index2);
        this.index2 = Math.max(index1, index2);
    }

    protected boolean prepare() {
        return this.list != null && this.index1 >= 0 && this.index2 >= 0 && this.index1 < this.list.size() && this.index2 < this.list.size();
    }

    public void doExecute() {
        if (this.index1 != this.index2) {
            Object obj2 = this.list.remove(this.index2);
            Object obj1 = this.list.remove(this.index1);
            this.list.add(this.index1, obj2);
            this.list.add(this.index2, obj1);
        }
    }

    public void doRedo() {
        this.doExecute();
    }

    public void doUndo() {
        this.doExecute();
    }

    public Collection<?> doGetAffectedObjects() {
        return Collections.singleton(this.owner);
    }

    public Collection<?> doGetResult() {
        return Collections.singleton(this.owner);
    }
}

