/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.common.license;

import com.savvytest.eclipse.common.Activator;
import com.savvytest.eclipse.common.Savvytest;
import com.savvytest.eclipse.common.logging.AbstractSavvytestLogging;
import com.savvytest.eclipse.common.logging.LogLevel;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public final class License {
    public static final int OPTION_EVALUATION = 2;
    public static final int OPTION_EXCELIO = 1;
    public static final int OPTION_Z1090 = 64;
    public static final int OPTION_STUBS = 16;
    public static final int OPTION_DB2MOCKUP = 32;
    public static final char LICENSE_KEY_SEPARATOR = '|';
    private static final String LICENSE_KEY_SPLIT = "\\|";
    public static final String PROPERTIES_LOCATION = "savvytest.licensefile";
    private static final String LICENSE_KEY_PROP = "savvytest.licensekey";
    private static final String LICENSEE_PROP = "savvytest.licensee";
    private static final String LAST_LICENSE_LOCATION = "platform:/plugin/com.savvytest.eclipse.common/savvytest.properties";
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.common.license.License.";
    private static License instance;
    private String licenseKey;
    private String licensee;
    private Date expires;
    private int addons;
    private boolean licenseDataValid;

    private static String getClassString(String key, Object ... substitutes) {
        String translation = Activator.INSTANCE.getString(TRANSLATION_PREFIX + key);
        if (substitutes.length > 0) {
            translation = MessageFormat.format(translation, substitutes);
        }
        return translation;
    }

    public static final License getInstance() {
        if (instance == null) {
            instance = new License();
        }
        return instance;
    }

    public static final void refreshLicense() {
        instance = null;
        if (Savvytest.isEclipseRunning().booleanValue()) {
            IPreferenceStore preferenceStore = Activator.getPreferenceStore();
            preferenceStore.putValue(LICENSE_KEY_PROP, "");
            preferenceStore.putValue(LICENSEE_PROP, "");
        }
    }

    private License() {
        if (Savvytest.isEclipseRunning().booleanValue()) {
            this.loadEclipseLicense();
        } else {
            this.loadNonEclipseLicense();
        }
    }

    License(String licenseKey, String licensee) {
        this.setLicenseData(licenseKey, licensee);
    }

    private void loadEclipseLicense() {
        IPreferenceStore preferenceStore = Activator.getPreferenceStore();
        Exception exception = null;
        LicenseData licenseData = null;
        try {
            licenseData = this.getFromPrefStore(preferenceStore);
            if (licenseData == null) {
                licenseData = this.getFromSystemProperties();
            }
            if (licenseData == null) {
                licenseData = this.getFromSystemEnvironment();
            }
            if (licenseData == null) {
                Bundle commonBundle = Platform.getBundle((String)"com.savvytest.eclipse.common");
                File commonFile = FileLocator.getBundleFile((Bundle)commonBundle);
                if (commonFile.isFile()) {
                    commonFile = commonFile.getParentFile();
                }
                File licenseFile = new File(String.valueOf(commonFile.toString()) + System.getProperty("file.separator") + "savvytest.properties");
                SavvytestSettings.INSTANCE.getLogger().log("Checking whether license file " + licenseFile + " can be read: " + licenseFile.canRead(), LogLevel.DEBUG, this);
                if (licenseFile.canRead()) {
                    URL licenseURL = licenseFile.toURI().toURL();
                    SavvytestSettings.INSTANCE.getLogger().log("Loading license from: " + licenseURL, LogLevel.INFO, this);
                    licenseData = this.getFromLocation(licenseURL);
                    if (licenseData == null) {
                        SavvytestSettings.INSTANCE.getLogger().log("No license information found at: " + licenseURL, LogLevel.INFO, this);
                    }
                }
            }
        }
        catch (Exception e) {
            exception = e;
        }
        if (licenseData == null && exception == null) {
            try {
                SavvytestSettings.INSTANCE.getLogger().log("Loading license from: platform:/plugin/com.savvytest.eclipse.common/savvytest.properties", LogLevel.INFO, this);
                licenseData = this.getFromLocation(new URL(LAST_LICENSE_LOCATION));
                if (licenseData == null) {
                    SavvytestSettings.INSTANCE.getLogger().log("No license information found at: platform:/plugin/com.savvytest.eclipse.common/savvytest.properties", LogLevel.INFO, this);
                }
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {}
        }
        if (licenseData == null) {
            SavvytestSettings.INSTANCE.getLogger().log("Loading cached license.", LogLevel.INFO, this);
            licenseData = this.getFromFallback(preferenceStore);
        }
        this.setLicenseData(licenseData);
        AbstractSavvytestLogging logger = SavvytestSettings.INSTANCE.getLogger();
        if (logger.getLogLevel().ordinal() >= LogLevel.DEBUG.ordinal()) {
            logger.log("License validation.", LogLevel.DEBUG, this);
            logger.log("Licensee: " + this.getLicensee(), LogLevel.DEBUG, this);
            logger.log("License key: " + this.getLicenseKey(), LogLevel.DEBUG, this);
            logger.log("License valid: " + this.isValid(), LogLevel.DEBUG, this);
            if (this.isValid()) {
                logger.log("License expires: " + this.getExpireDate(), LogLevel.DEBUG, this);
                logger.log("Evaluation license: " + this.isEvaluationLicense(), LogLevel.DEBUG, this);
                logger.log("Excel I/O licensed: " + this.isOptionExcelIoLicensed(), LogLevel.DEBUG, this);
                logger.log("Stubs licensed: " + this.isOptionStubsLicensed(), LogLevel.DEBUG, this);
                logger.log("DB2 Mockup licensed: " + this.isOptionDB2MokcupLicensed(), LogLevel.DEBUG, this);
            }
            logger.log("License validation finished.", LogLevel.DEBUG, this);
        }
        if (exception != null) {
            String errorMessage = License.getClassString("error.licenseLoading", exception.getLocalizedMessage());
            if (this.isValid()) {
                SavvytestSettings.INSTANCE.getLogger().log(errorMessage, LogLevel.WARNING, this);
            } else {
                SavvytestSettings.INSTANCE.getLogger().log(exception, (Object)this);
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Savvytest.getGlobalString("error", new Object[0]), (String)errorMessage);
            }
        } else if (!this.isValid()) {
            String warningMessage = License.getClassString("error.licenseInvalid", this.getLicenseKey(), this.getLicensee());
            SavvytestSettings.INSTANCE.getLogger().log(warningMessage, LogLevel.WARNING, this);
            MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Savvytest.getGlobalString("warning", new Object[0]), (String)warningMessage);
        }
        preferenceStore.putValue(LICENSE_KEY_PROP, this.isValid() ? this.getLicenseKey() : "");
        preferenceStore.putValue(LICENSEE_PROP, this.isValid() ? this.getLicensee() : "");
    }

    private void loadNonEclipseLicense() {
        try {
            LicenseData licenseData = this.getFromSystemProperties();
            if (licenseData == null) {
                licenseData = this.getFromSystemEnvironment();
            }
            if (licenseData == null) {
                String fileLocation = "file:///" + System.getProperty("user.dir") + System.getProperty("file.separator") + "savvytest.properties";
                File file = new File(new URL(fileLocation).toURI());
                System.out.println("Checking whether license file " + file + " can be read: " + file.canRead());
                if (file.canRead()) {
                    URL licenseUrl = file.toURI().toURL();
                    System.out.println("Loading license from: " + licenseUrl);
                    licenseData = this.getFromLocation(licenseUrl);
                }
            }
            if (licenseData == null) {
                String jarLocation = License.class.getProtectionDomain().getCodeSource().getLocation().toURI().toString();
                String licenseLocation = "jar:" + jarLocation + "!/savvytest.properties";
                System.out.println("Loading license from: " + licenseLocation);
                licenseData = this.getFromLocation(new URL(licenseLocation));
            }
            this.setLicenseData(licenseData);
            if (!this.licenseDataValid) {
                System.err.println(MessageFormat.format("The given license data are invalid. savvytest tests are disabled. Licensee: {1}. License Key: {0}", this.licenseKey, this.licensee));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    private LicenseData getFromFallback(IPreferenceStore prefStore) {
        String licenseKey = prefStore.getString(LICENSE_KEY_PROP);
        String licensee = prefStore.getString(LICENSEE_PROP);
        return this.wrap(licenseKey, licensee);
    }

    private LicenseData getFromPrefStore(IPreferenceStore prefStore) throws MalformedURLException, IOException {
        String licenseLocation = prefStore.getString(PROPERTIES_LOCATION);
        if (licenseLocation != null && !licenseLocation.isEmpty()) {
            return this.getFromLocation(new URL(licenseLocation));
        }
        return null;
    }

    private LicenseData getFromSystemEnvironment() throws MalformedURLException, IOException {
        String licensee;
        String licenseKey = System.getenv(LICENSE_KEY_PROP);
        LicenseData data = this.wrap(licenseKey, licensee = System.getenv(LICENSEE_PROP));
        if (data != null) {
            return data;
        }
        String licenseLocation = System.getenv(PROPERTIES_LOCATION);
        if (licenseLocation != null && !licenseLocation.isEmpty()) {
            return this.getFromLocation(new URL(licenseLocation));
        }
        return null;
    }

    private LicenseData getFromSystemProperties() throws MalformedURLException, IOException {
        String licensee;
        String licenseKey = System.getProperty(LICENSE_KEY_PROP);
        LicenseData data = this.wrap(licenseKey, licensee = System.getProperty(LICENSEE_PROP));
        if (data != null) {
            return data;
        }
        String licenseLocation = System.getProperty(PROPERTIES_LOCATION);
        if (licenseLocation != null && !licenseLocation.isEmpty()) {
            return this.getFromLocation(new URL(licenseLocation));
        }
        return null;
    }

    private LicenseData getFromLocation(URL url) throws IOException {
        LicenseData licenseData;
        block7: {
            InputStream stream = null;
            try {
                stream = url.openStream();
                Properties licenseProperties = new Properties();
                licenseProperties.load(stream);
                licenseData = this.getFromProperties(licenseProperties);
                if (stream == null) break block7;
            }
            catch (Throwable throwable) {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        return licenseData;
    }

    private LicenseData getFromProperties(Properties properties) {
        String licenseKey = properties.getProperty(LICENSE_KEY_PROP);
        String licensee = properties.getProperty(LICENSEE_PROP);
        return this.wrap(licenseKey, licensee);
    }

    private LicenseData wrap(String licenseKey, String licensee) {
        if (licenseKey != null && licensee != null && !licenseKey.isEmpty() && !licensee.isEmpty()) {
            LicenseData data = new LicenseData();
            data.licenseKey = licenseKey;
            data.licensee = licensee;
            return data;
        }
        return null;
    }

    private void setLicenseData(LicenseData licenseData) {
        if (licenseData != null) {
            this.setLicenseData(licenseData.licenseKey, licenseData.licensee);
        } else {
            this.setLicenseData(null, null);
        }
    }

    private void setLicenseData(String licenseKey, String licensee) {
        if (licenseKey != null) {
            this.licenseKey = licenseKey.replace("-", "").replace(" ", "");
        }
        this.licensee = licensee;
        this.checkLicenseValid();
    }

    public String getLicenseKey() {
        return this.licenseKey;
    }

    public String getHumanReadableLicenseKey() {
        if (this.licenseKey == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder(this.licenseKey.length() + this.licenseKey.length() / 4);
        String[] licenseKeys = this.licenseKey.split(LICENSE_KEY_SPLIT);
        int i = 0;
        while (i < licenseKeys.length) {
            if (i != 0) {
                builder.append(" ");
                builder.append('|');
                builder.append(" ");
            }
            int index = 0;
            while (true) {
                if (index + 4 >= licenseKeys[i].length()) break;
                builder.append(licenseKeys[i].subSequence(index, index + 4));
                builder.append('-');
                index += 4;
            }
            builder.append(licenseKeys[i].substring(index));
            ++i;
        }
        return builder.toString();
    }

    public String getLicensee() {
        return this.licensee;
    }

    private void checkLicenseValid() {
        String[] licenseKeys;
        this.licenseDataValid = false;
        this.expires = null;
        this.addons = 0;
        if (this.licenseKey == null || this.licensee == null) {
            return;
        }
        if (this.licensee.length() < 5) {
            return;
        }
        String[] stringArray = licenseKeys = this.licenseKey.split(LICENSE_KEY_SPLIT);
        int n = licenseKeys.length;
        int n2 = 0;
        while (n2 < n) {
            String licenseKey = stringArray[n2];
            if (licenseKey.length() != 20) {
                return;
            }
            String license = licenseKey.substring(0, 18);
            if (!this.myhash(license).equals(licenseKey.substring(18, 20))) {
                return;
            }
            String datakey = String.valueOf(this.myhash(this.licensee.substring(0, 4))) + this.myhash(this.licensee.substring(2));
            license = this.decrypt(license, datakey);
            String randomkey = license.substring(6, 10);
            String decoded = this.decrypt(this.decrypt(license.substring(10, 18), randomkey), datakey);
            String ldata = this.decrypt(license.substring(0, 6), randomkey);
            if (!this.myhash(this.licensee).equals(ldata.substring(0, 2))) {
                return;
            }
            String expiresKey = decoded.substring(2);
            String addonsKey = decoded.substring(0, 2);
            if (!this.myhash(String.valueOf(expiresKey) + addonsKey).equals(ldata.substring(4, 6))) {
                return;
            }
            Date expiresDateKey = this.extractDate(expiresKey);
            if (this.expires == null) {
                this.expires = expiresDateKey;
            } else if (this.expires.before(expiresDateKey)) {
                this.expires = expiresDateKey;
            }
            int addonsBits = Integer.parseInt(addonsKey, 16);
            this.addons = this.addons == 0 ? addonsBits : this.addons | addonsBits;
            ++n2;
        }
        this.licenseDataValid = true;
    }

    private String decrypt(String string, String encryptKey) {
        String code = "";
        int i = 0;
        while (i < string.length()) {
            int digit = string.charAt(i) - encryptKey.charAt(i % encryptKey.length());
            if (digit < 0) {
                digit += 10;
            }
            code = String.valueOf(code) + digit;
            ++i;
        }
        return code;
    }

    private String myhash(String string) {
        int code = 0;
        int i = 0;
        while (i < string.length()) {
            code += this.myord(string.charAt(i)) * (i % 7 + 1);
            ++i;
        }
        String hash = String.format("%02d", code %= 100);
        return hash;
    }

    private int myord(char mychar) {
        int myord = "5AB6C.DE7F&GH8+IJK_9LM-N0OPQ1RST2UVW3XYZ4".indexOf(Character.toUpperCase(mychar));
        myord = myord >= 0 ? (myord += 11) : 1;
        return myord;
    }

    private Date extractDate(String expireDate) {
        if (expireDate == "999999") {
            return new Date(Long.MAX_VALUE);
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        try {
            return df.parse("20" + expireDate + "000000000");
        }
        catch (ParseException e) {
            SavvytestSettings.INSTANCE.getLogger().log(e, (Object)this);
            return null;
        }
    }

    public boolean isValid() {
        return this.licenseDataValid;
    }

    public Date getExpireDate() {
        if (!this.isValid()) {
            return null;
        }
        return this.expires;
    }

    public int daysLeft() {
        if (!this.isValid()) {
            return Integer.MIN_VALUE;
        }
        Date today = new Date();
        long diffTime = this.getExpireDate().getTime() - today.getTime();
        long diffDays = diffTime / 86400000L + 1L;
        return (int)diffDays;
    }

    public boolean isOptionStubsLicensed() {
        return this.isOptionLicensed(16);
    }

    public boolean isOptionExcelIoLicensed() {
        return this.isOptionLicensed(1);
    }

    public boolean isOptionDB2MokcupLicensed() {
        return this.isOptionLicensed(32);
    }

    public boolean isOptionZ1090Licensed() {
        return this.isOptionLicensed(64);
    }

    public boolean isEvaluationLicense() {
        return this.isOptionLicensed(2);
    }

    public boolean isOptionLicensed(int options) {
        return this.isValid() && ((this.addons & options) == options || (this.addons & 2) == 2);
    }

    public boolean isValidCpuid(String cpuid) {
        if (!this.isValid()) {
            return false;
        }
        if (this.isEvaluationLicense()) {
            return true;
        }
        if (cpuid == null || cpuid.length() != 12) {
            return false;
        }
        String[] stringArray = this.licenseKey.split(LICENSE_KEY_SPLIT);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String aLicenseKey = stringArray[n2];
            String cpuserial = cpuid.substring(4);
            if (this.isOptionZ1090Licensed() && cpuserial.endsWith("1090")) {
                return true;
            }
            String license = aLicenseKey.substring(0, 18);
            String datakey = String.valueOf(this.myhash(this.licensee.substring(0, 4))) + this.myhash(this.licensee.substring(2));
            license = this.decrypt(license, datakey);
            String randomkey = license.substring(6, 10);
            String ldata = this.decrypt(license.substring(0, 6), randomkey);
            if (this.myhash(cpuserial).equals(ldata.substring(2, 4))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public IStatus getLicenseStatus() {
        return this.getLicenseStatus(null);
    }

    public IStatus getLicenseStatus(String cpuId) {
        if (!this.isValid()) {
            return new Status(4, "com.savvytest.eclipse.common", License.getClassString("status.invalidKey", new Object[0]));
        }
        if (cpuId != null && !cpuId.isEmpty() && !this.isValidCpuid(cpuId)) {
            return new Status(4, "com.savvytest.eclipse.common", License.getClassString("status.invalidCpuId", cpuId));
        }
        int daysLeft = this.daysLeft();
        if (daysLeft < 0) {
            return new Status(4, "com.savvytest.eclipse.common", License.getClassString("status.licenseExpired", daysLeft));
        }
        if (daysLeft <= 30) {
            return new Status(2, "com.savvytest.eclipse.common", License.getClassString("status.licenseAboutToExpire", daysLeft));
        }
        return Status.OK_STATUS;
    }

    private static final class LicenseData {
        public String licenseKey;
        public String licensee;

        private LicenseData() {
        }
    }
}

