/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.common.preferences;

import com.savvytest.eclipse.common.Activator;
import com.savvytest.eclipse.common.license.License;
import com.savvytest.eclipse.common.logging.AbstractSavvytestLogging;
import com.savvytest.eclipse.common.logging.ConsoleLogging;
import com.savvytest.eclipse.common.logging.LogLevel;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.themes.IThemeManager;

public enum SavvytestSettings {
    INSTANCE;

    public static final String LOG_LEVEL = "savvytest.loglevel";
    public static final String LOG_CLASS = "savvytest.logclass";
    public static final String REPORT_GENERATOR = "ResultReportGenerator";
    public static final String LICENSE_PROPERTIES_LOCATION = "savvytest.licensefile";
    private final IPreferenceStore prefStore;
    private AbstractSavvytestLogging logger;
    private LogLevel logLevel;
    private final ColorRegistry colorRegistry;
    private final FontRegistry fontRegistry;

    private SavvytestSettings() {
        if (Activator.getPlugin() == null) {
            this.logLevel = LogLevel.INFO;
            String logLevelString = System.getProperty(LOG_LEVEL);
            if (logLevelString == null) {
                logLevelString = System.getenv(LOG_LEVEL);
            }
            if (logLevelString != null) {
                try {
                    this.logLevel = LogLevel.valueOf(logLevelString.toUpperCase());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    System.out.println("Unknown log level " + logLevelString + ". Default log level " + (Object)((Object)this.logLevel) + " used instead.");
                }
            }
            this.logger = new ConsoleLogging();
            this.logger.setLogLevel(this.logLevel);
            this.prefStore = null;
            this.colorRegistry = null;
            this.fontRegistry = null;
            return;
        }
        this.prefStore = Activator.getPreferenceStore();
        this.logLevel = LogLevel.valueOf(this.prefStore.getString(LOG_LEVEL));
        this.loadLogger(this.prefStore.getString(LOG_CLASS));
        this.prefStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String prop = event.getProperty();
                if (prop.equals(SavvytestSettings.LOG_LEVEL)) {
                    SavvytestSettings.this.internalSetLogLevel(LogLevel.valueOf((String)event.getNewValue()));
                } else if (prop.equals(SavvytestSettings.LOG_CLASS)) {
                    SavvytestSettings.this.loadLogger((String)event.getNewValue());
                } else if (prop.equals(SavvytestSettings.LICENSE_PROPERTIES_LOCATION)) {
                    License.refreshLicense();
                    License.getInstance();
                }
            }
        });
        IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        ITheme currentTheme = themeManager.getCurrentTheme();
        this.colorRegistry = currentTheme.getColorRegistry();
        this.fontRegistry = currentTheme.getFontRegistry();
    }

    public License getLicense() {
        return License.getInstance();
    }

    public String getReportGeneratorId() {
        if (this.prefStore != null) {
            return this.prefStore.getString(REPORT_GENERATOR);
        }
        return null;
    }

    public void setReportGeneratorId(String generatorId) {
        if (this.prefStore != null) {
            if (generatorId != null) {
                this.prefStore.setValue(REPORT_GENERATOR, generatorId);
            } else {
                this.prefStore.setToDefault(REPORT_GENERATOR);
            }
        }
    }

    public Font getFont(String fontID) {
        if (this.fontRegistry != null) {
            return this.fontRegistry.get(fontID);
        }
        return null;
    }

    public Color getColor(String colorID) {
        if (this.colorRegistry != null) {
            return this.colorRegistry.get(colorID);
        }
        return null;
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(LogLevel level) {
        if (level != null && this.prefStore != null) {
            this.prefStore.setValue(LOG_LEVEL, level.name());
        } else if (level != null) {
            this.internalSetLogLevel(this.logLevel);
        }
    }

    private void internalSetLogLevel(LogLevel level) {
        this.logLevel = level;
        if (this.logger != null) {
            this.logger.setLogLevel(level);
        }
    }

    public AbstractSavvytestLogging getLogger() {
        return this.logger;
    }

    public void setLogger(AbstractSavvytestLogging logger) {
        if (logger != null) {
            this.logger = logger;
            this.logger.setLogLevel(this.getLogLevel());
        }
    }

    protected void loadLogger(String className) {
        if (className != null) {
            try {
                Class<?> clazz = Class.forName(className);
                clazz.asSubclass(AbstractSavvytestLogging.class);
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                this.logger = (AbstractSavvytestLogging)constructor.newInstance(new Object[0]);
                this.logger.setLogLevel(this.getLogLevel());
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (ClassCastException e) {
                e.printStackTrace();
            }
        }
    }
}

