/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.common.savvytestnature;

import com.savvytest.eclipse.common.Savvytest;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;

public enum SavvytestTypeEnum {
    LISTRUCTURE("structures", "listructure", "com.savvytest.eclipse.common.savvytestStructure", null),
    INTERFACE("interfaces", "interface", "com.savvytest.eclipse.common.savvytestInterface", "com.savvytest.eclipse.editor.iface.SavvytestInterfaceEditorID"),
    TESTSCENARIO("scenarios", "testscenario", "com.savvytest.eclipse.common.savvytestTestscenario", "com.savvytest.eclipse.editor.testscenario.SavvytestTestscenarioEditorID"),
    TESTSUITE("suites", "testsuite", "com.savvytest.eclipse.common.savvytestTestsuite", "com.savvytest.eclipse.editor.testsuite.SavvytestTestsuiteEditorID"),
    RESULT("results", "result", "com.savvytest.eclipse.common.savvytestResult", null),
    REPORT("reports", "report", null, null),
    OUTPUT("output", "archive", "com.savvytest.eclipse.common.savvytestArchive", "com.savvytest.eclipse.editor.result.SavvytestResultEditorID"),
    ARCHIVE("archive", "archive", "com.savvytest.eclipse.common.savvytestArchive", "com.savvytest.eclipse.editor.result.SavvytestResultEditorID"),
    STUB("stubs", "stub", "com.savvytest.eclipse.common.savvytestStub", "com.savvytest.eclipse.editor.stub.SavvytestStubEditorID"),
    TEMP(".temp", null, null, null),
    JCL("jcl", "jcl", null, null);

    public final String foldername;
    public final String fileextension;
    public final String contentTypeID;
    public final String defaultEditorId;

    private SavvytestTypeEnum(String foldername, String fileextension, String contentTypeID, String defaultEditorId) {
        this.foldername = foldername;
        this.fileextension = fileextension;
        this.contentTypeID = contentTypeID;
        this.defaultEditorId = defaultEditorId;
    }

    public IFolder getDefaultFolder(IResource resource) {
        IFolder folder;
        if (resource == null) {
            return null;
        }
        IProject project = resource.getProject();
        if (Savvytest.hasSavvytestNature(project) && (folder = project.getFolder(this.foldername)).isAccessible()) {
            return folder;
        }
        return null;
    }

    public boolean isType(IResource resource) {
        if (resource == null) {
            return false;
        }
        if (resource.getType() == 1) {
            IFile file = (IFile)resource;
            if (this.contentTypeID != null && resource.isAccessible()) {
                try {
                    IContentType contentType;
                    IContentDescription contentDescription = file.getContentDescription();
                    if (contentDescription != null && this.contentTypeID.equals((contentType = contentDescription.getContentType()).getId())) {
                        return true;
                    }
                }
                catch (CoreException e) {
                    SavvytestSettings.INSTANCE.getLogger().log((Exception)((Object)e), (Object)this);
                }
            }
            return this.fileextension != null && this.fileextension.equals(file.getFileExtension());
        }
        if (resource.getType() == 2) {
            IFolder folder = (IFolder)resource;
            IContainer parent = folder.getParent();
            while (parent != null && parent.getType() != 4) {
                folder = parent;
                parent = folder.getParent();
            }
            return this.foldername != null && this.foldername.equals(folder.getName());
        }
        return false;
    }
}

