/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.common.util;

import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;

public class URIUtil {
    public static URI convertToFileURI(URI uri) {
        if (uri.isPlatform()) {
            URI workspaceURI = URI.createURI((String)ResourcesPlugin.getWorkspace().getRoot().getLocationURI().toString());
            URI workspaceRelativeResourceURI = uri.replacePrefix(URI.createPlatformResourceURI((String)"/", (boolean)true), URI.createURI((String)"/"));
            return URI.createURI((String)(String.valueOf(workspaceURI.toString()) + workspaceRelativeResourceURI.toString()));
        }
        return uri;
    }

    public static String convertToFileURIString(URI uri) {
        return URIUtil.convertToFileURI(uri).toString();
    }

    public static String convertToQuery(Map<String, ? extends Object> map) {
        StringBuilder builder = new StringBuilder();
        builder.append('?');
        for (Map.Entry<String, ? extends Object> entry : map.entrySet()) {
            try {
                builder.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
                builder.append('=');
                builder.append(URLEncoder.encode(String.valueOf(entry.getValue()), "UTF-8"));
                builder.append('&');
            }
            catch (UnsupportedEncodingException e) {
                SavvytestSettings.INSTANCE.getLogger().log(e, URIUtil.class);
            }
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }
}

