/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.common.util;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;

public class UtilityFunctions {
    private UtilityFunctions() {
    }

    public static final String leftTrim(String string) {
        if (string == null) {
            return null;
        }
        int idx = 0;
        while (idx < string.length() && string.charAt(idx) == ' ') {
            ++idx;
        }
        if (idx == 0) {
            return string;
        }
        if (idx >= string.length()) {
            return "";
        }
        return string.substring(idx);
    }

    public static final String rightTrim(String string) {
        if (string == null) {
            return null;
        }
        int idx = string.length() - 1;
        while (idx >= 0 && string.charAt(idx) == ' ') {
            --idx;
        }
        if (idx == string.length() - 1) {
            return string;
        }
        if (idx < 0) {
            return "";
        }
        return string.substring(0, idx + 1);
    }

    public static final boolean isEmpty(String text) {
        return text == null || text.length() <= 0;
    }

    public static final String humanReadableByteCount(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return String.valueOf(bytes) + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = String.valueOf((si ? "kMGTPE" : "KMGTPE").charAt(exp - 1)) + (si ? "" : "i");
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static final String truncate(String text, int limit) {
        return UtilityFunctions.truncate(text, limit, 0x1000008);
    }

    public static final String truncate(String text, int limit, String replacement) {
        return UtilityFunctions.truncate(text, limit, 0x1000008, replacement);
    }

    public static final String truncate(String text, int limit, int position) {
        return UtilityFunctions.truncate(text, limit, position, "...");
    }

    public static final String truncate(String text, int limit, int position, String replacement) {
        if (text == null) {
            return null;
        }
        if (limit <= 0) {
            throw new IllegalArgumentException("Limit must be positive.");
        }
        if (replacement == null) {
            throw new IllegalArgumentException("Replacement must not be null.");
        }
        if (position != 1 && position != 0x1000000 && position != 0x1000008) {
            throw new IllegalArgumentException("Position must be one of the following: SWT.BEGINNING, SWT.CENTER, SWT.END");
        }
        if (replacement.length() > limit) {
            throw new IllegalArgumentException("Replacement (" + replacement + ") can't be longer then the given limit (" + limit + ")");
        }
        if (text.length() <= limit) {
            return text;
        }
        switch (position) {
            case 1: {
                return String.valueOf(replacement) + text.substring(text.length() - (limit - replacement.length()));
            }
            case 0x1000000: {
                int beginningIndex = (limit - replacement.length() + 1) / 2;
                int endIndex = text.length() - (limit - replacement.length()) / 2;
                return String.valueOf(text.substring(0, beginningIndex)) + replacement + text.substring(endIndex);
            }
            case 0x1000008: {
                return String.valueOf(text.substring(0, limit - replacement.length())) + replacement;
            }
        }
        throw new IllegalStateException();
    }

    public static final boolean isPrintableChar(char c) {
        Character.UnicodeBlock block = Character.UnicodeBlock.of(c);
        return !Character.isISOControl(c) && block != null && block != Character.UnicodeBlock.SPECIALS;
    }

    public static final String nullToEmpty(String string) {
        return string == null ? "" : string;
    }

    public static final <T> T adapt(Object object, Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class must not be null.");
        }
        if (object == null) {
            return null;
        }
        Object unwrapped = AdapterFactoryEditingDomain.unwrap((Object)object);
        if (unwrapped == null) {
            return null;
        }
        if (clazz.isAssignableFrom(unwrapped.getClass())) {
            return clazz.cast(unwrapped);
        }
        if (unwrapped instanceof EObject) {
            return UtilityFunctions.adapt((EObject)unwrapped, clazz);
        }
        return null;
    }

    public static final <T> T adapt(EObject object, Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class must not be null.");
        }
        if (object == null) {
            return null;
        }
        if (clazz == Resource.class) {
            return clazz.cast(object.eResource());
        }
        EObject adapted = object;
        while (adapted != null) {
            if (clazz.isAssignableFrom(adapted.getClass())) {
                return clazz.cast(adapted);
            }
            adapted = adapted.eContainer();
        }
        return null;
    }
}

