/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.editor.testsuite.gui;

import com.savvytest.eclipse.common.Savvytest;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.common.savvytestnature.ISavvytestWizardPage;
import com.savvytest.eclipse.common.savvytestnature.SavvytestTypeEnum;
import com.savvytest.eclipse.common.util.GridDataCreator;
import com.savvytest.eclipse.common.util.SimpleXPathEvaluator;
import com.savvytest.eclipse.common.util.WizardPageValidator;
import com.savvytest.eclipse.common.util.editing.duallistselector.DualListAdapter;
import com.savvytest.eclipse.common.util.editing.duallistselector.DualListListener;
import com.savvytest.eclipse.common.util.editing.duallistselector.ElementInformation;
import com.savvytest.eclipse.common.util.editing.duallistselector.TreeFileSelector;
import com.savvytest.eclipse.editor.testsuite.gui.TestsuiteEditor;
import com.savvytest.eclipse.editor.testsuite.gui.TestsuiteModelWizard;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SavvytestTestsuiteWizardPage
extends WizardPage
implements ISavvytestWizardPage {
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.editor.testsuite.gui.SavvytestTestsuiteWizardPage.";
    private Composite container;
    private TreeFileSelector tfs;
    private WizardPageValidator validator;
    private TestsuiteModelWizard.TestsuiteModelWizardNewFileCreationPage filepage;
    private IProject containingProject;
    private List<IFile> preSetFiles;

    protected static String getString(String key) {
        return TestsuiteEditor.getString(key);
    }

    private static String getClassString(String key) {
        return SavvytestTestsuiteWizardPage.getString(TRANSLATION_PREFIX + key);
    }

    public SavvytestTestsuiteWizardPage(String pageName) {
        super(pageName);
    }

    public void dispose() {
        super.dispose();
        if (this.tfs != null) {
            this.tfs.dispose();
        }
    }

    public List<IFile> getTestscenarioFiles() {
        if (this.tfs == null) {
            return null;
        }
        return this.tfs.getSelected();
    }

    public void setTestscenariosFiles(List<IFile> testscenarios) {
        if (this.tfs != null) {
            this.tfs.setSelected(testscenarios);
        } else if (this.preSetFiles == null) {
            this.preSetFiles = new ArrayList<IFile>(testscenarios);
        } else {
            this.preSetFiles.clear();
            this.preSetFiles.addAll(testscenarios);
        }
    }

    public void createControl(Composite parent) {
        IWizardPage page;
        this.validator = new WizardPageValidator(this){

            protected String internalValidate() {
                if (SavvytestTestsuiteWizardPage.this.tfs.isNothingSelected()) {
                    return SavvytestTestsuiteWizardPage.getClassString("errors.parameters");
                }
                return null;
            }
        };
        Font font = SavvytestSettings.INSTANCE.getFont("com.savvytest.eclipse.common.fontNormal");
        Color color = SavvytestSettings.INSTANCE.getColor("com.savvytest.eclipse.common.colorForeground");
        this.container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        this.container.setLayout((Layout)layout);
        Group groupSuites = new Group(this.container, 16);
        Group groupInformation = new Group(this.container, 16);
        Label labelAlias = new Label((Composite)groupInformation, 0);
        final Text textAlias = new Text((Composite)groupInformation, 2060);
        Label labelFolder = new Label((Composite)groupInformation, 0);
        final Text textFolder = new Text((Composite)groupInformation, 2060);
        Label labelProject = new Label((Composite)groupInformation, 0);
        final Text textProject = new Text((Composite)groupInformation, 2060);
        groupSuites.setText(SavvytestTestsuiteWizardPage.getClassString("grouptestscenarios"));
        groupSuites.setLayoutData((Object)GridDataCreator.horizontalFill());
        groupSuites.setLayout((Layout)new GridLayout(2, false));
        groupSuites.setFont(font);
        groupSuites.setForeground(color);
        this.tfs = new TreeFileSelector((Composite)groupSuites, 0);
        this.tfs.setProjectRestriction(this.containingProject);
        this.tfs.setFileTypes(new SavvytestTypeEnum[]{SavvytestTypeEnum.TESTSCENARIO});
        this.tfs.setMultiple(false);
        this.tfs.setFont(font);
        this.tfs.setColor(color);
        this.tfs.getControl().setLayoutData((Object)GridDataCreator.fill());
        this.tfs.addDualListListener((DualListListener)new DualListAdapter<IFile>(){

            public void selectionEvent(int side, List<ElementInformation<IFile>> elements) {
                if (elements != null && elements.size() == 1 && ((IFile)elements.get((int)0).element).exists()) {
                    IFile file = (IFile)elements.get((int)0).element;
                    SimpleXPathEvaluator parser = new SimpleXPathEvaluator();
                    parser.setDocumentSecure(file);
                    parser.setXPath(SimpleXPathEvaluator.XPATH_ALIAS);
                    String alias = parser.evaluateXPathForStringSecure();
                    textAlias.setText(alias == null ? "" : alias);
                    textFolder.setText(file.getProjectRelativePath().removeLastSegments(1).toString());
                    textProject.setText(file.getProject().getName());
                } else {
                    textAlias.setText("");
                    textFolder.setText("");
                    textProject.setText("");
                }
            }

            public void movementEvent(int side, List<ElementInformation<IFile>> elements) {
                SavvytestTestsuiteWizardPage.this.validator.validate();
            }
        });
        groupInformation.setText(SavvytestTestsuiteWizardPage.getClassString("groupinfo"));
        groupInformation.setLayoutData((Object)GridDataCreator.horizontalFill());
        groupInformation.setLayout((Layout)new GridLayout(2, false));
        groupInformation.setFont(font);
        groupInformation.setForeground(color);
        labelAlias.setText(SavvytestTestsuiteWizardPage.getClassString("infoalias"));
        labelAlias.setLayoutData((Object)GridDataCreator.normal());
        labelAlias.setFont(font);
        labelAlias.setForeground(color);
        textAlias.setLayoutData((Object)GridDataCreator.horizontalFill());
        textAlias.setFont(font);
        textAlias.setForeground(color);
        labelFolder.setText(SavvytestTestsuiteWizardPage.getClassString("infofolder"));
        labelFolder.setLayoutData((Object)GridDataCreator.normal());
        labelFolder.setFont(font);
        labelFolder.setForeground(color);
        textFolder.setLayoutData((Object)GridDataCreator.horizontalFill());
        textFolder.setFont(font);
        textFolder.setForeground(color);
        labelProject.setText(SavvytestTestsuiteWizardPage.getClassString("infoproject"));
        labelProject.setLayoutData((Object)GridDataCreator.normal());
        labelProject.setFont(font);
        labelProject.setForeground(color);
        textProject.setLayoutData((Object)GridDataCreator.horizontalFill());
        textProject.setFont(font);
        textProject.setForeground(color);
        if (this.preSetFiles != null) {
            if (!this.preSetFiles.isEmpty()) {
                this.tfs.setSelected(this.preSetFiles);
                this.preSetFiles.clear();
            }
            this.preSetFiles = null;
        }
        if ((page = this.getNextPage()) instanceof TestsuiteModelWizard.TestsuiteModelWizardNewFileCreationPage) {
            this.filepage = (TestsuiteModelWizard.TestsuiteModelWizardNewFileCreationPage)page;
        }
        this.container.pack();
        this.setControl((Control)this.container);
        this.validator.validate();
        this.validator.setDisplayError(true);
        Savvytest.setDynamicHelp((String)"com.savvytest.eclipse.help.DefaultContextHelp", (Control[])new Control[]{this.getControl()});
    }

    public void updateName(String name) {
        if (this.filepage != null) {
            this.filepage.setFileName(String.valueOf(name) + '.' + TestsuiteModelWizard.FILE_EXTENSIONS.get(0));
            this.filepage.setPageComplete(this.filepage.validatePage());
            this.filepage.getWizard().getContainer().updateButtons();
        }
    }

    public void updateProject(IProject project) {
        this.containingProject = project;
        if (this.tfs != null) {
            this.tfs.setProjectRestriction(this.containingProject);
            this.validator.validate();
            if (this.filepage != null) {
                this.filepage.setContainerFullPath(SavvytestTypeEnum.TESTSUITE.getDefaultFolder((IResource)this.containingProject).getFullPath());
                this.filepage.setPageComplete(this.filepage.validatePage());
                this.filepage.getWizard().getContainer().updateButtons();
            }
        }
    }
}

