/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.editor.testsuite.gui;

import com.savvytest.eclipse.common.Savvytest;
import com.savvytest.eclipse.common.savvytestnature.DefaultSavvytestWizardPage;
import com.savvytest.eclipse.common.savvytestnature.SavvytestTypeEnum;
import com.savvytest.eclipse.core.model.xml.testscenario.DocumentRoot;
import com.savvytest.eclipse.core.model.xml.testscenario.TestscenarioPackage;
import com.savvytest.eclipse.core.model.xml.testscenario.util.TestscenarioResourceFactoryImpl;
import com.savvytest.eclipse.core.model.xml.testsuite.Testsuite;
import com.savvytest.eclipse.core.model.xml.testsuite.TestsuiteFactory;
import com.savvytest.eclipse.core.model.xml.testsuite.TestsuitePackage;
import com.savvytest.eclipse.core.model.xml.testsuite.provider.TestsuiteEditPlugin;
import com.savvytest.eclipse.editor.testsuite.gui.SavvytestTestsuiteWizardPage;
import com.savvytest.eclipse.editor.testsuite.gui.TestsuiteEditor;
import com.savvytest.eclipse.editor.testsuite.gui.TestsuiteEditorPlugin;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;

public class TestsuiteModelWizard
extends Wizard
implements INewWizard {
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.editor.testsuite.gui.TestsuiteModelWizard.";
    protected DefaultSavvytestWizardPage defaultPage;
    protected SavvytestTestsuiteWizardPage savvytestPage;
    public static final List<String> FILE_EXTENSIONS = Collections.unmodifiableList(Arrays.asList(TestsuiteEditorPlugin.INSTANCE.getString("_UI_TestsuiteEditorFilenameExtensions").split("\\s*,\\s*")));
    public static final String FORMATTED_FILE_EXTENSIONS = TestsuiteEditorPlugin.INSTANCE.getString("_UI_TestsuiteEditorFilenameExtensions").replaceAll("\\s*,\\s*", ", ");
    protected TestsuitePackage testsuitePackage = TestsuitePackage.eINSTANCE;
    protected TestsuiteFactory testsuiteFactory = this.testsuitePackage.getTestsuiteFactory();
    protected TestsuiteModelWizardNewFileCreationPage newFileCreationPage;
    protected TestsuiteModelWizardInitialObjectCreationPage initialObjectCreationPage;
    protected IStructuredSelection selection;
    protected IWorkbench workbench;
    protected List<String> initialObjectNames;

    protected static String getString(String key) {
        return TestsuiteEditor.getString(key);
    }

    private static String getClassString(String key) {
        return TestsuiteModelWizard.getString(TRANSLATION_PREFIX + key);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle(TestsuiteEditorPlugin.INSTANCE.getString("_UI_Wizard_label"));
        this.setDefaultPageImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(TestsuiteEditorPlugin.INSTANCE.getImage("full/wizban/NewTestsuite")));
    }

    protected Collection<String> getInitialObjectNames() {
        if (this.initialObjectNames == null) {
            this.initialObjectNames = new ArrayList<String>();
            for (EStructuralFeature eStructuralFeature : ExtendedMetaData.INSTANCE.getAllElements(ExtendedMetaData.INSTANCE.getDocumentRoot((EPackage)this.testsuitePackage))) {
                EClass eClass;
                EClassifier eClassifier;
                if (!eStructuralFeature.isChangeable() || !((eClassifier = eStructuralFeature.getEType()) instanceof EClass) || (eClass = (EClass)eClassifier).isAbstract()) continue;
                this.initialObjectNames.add(eStructuralFeature.getName());
            }
            Collections.sort(this.initialObjectNames, CommonPlugin.INSTANCE.getComparator());
        }
        return this.initialObjectNames;
    }

    protected EObject createInitialModel() {
        com.savvytest.eclipse.core.model.xml.testsuite.DocumentRoot root = this.testsuiteFactory.createDocumentRoot();
        Testsuite suite = this.testsuiteFactory.createTestsuite();
        suite.setId(URI.encodeOpaquePart((String)this.getModelFile().getProjectRelativePath().toString(), (boolean)true));
        if (this.defaultPage.getSavvytestAlias() != null) {
            suite.setAlias(this.defaultPage.getSavvytestAlias());
        }
        if (this.defaultPage.getSavvytestDescription() != null) {
            suite.setDescription(this.defaultPage.getSavvytestDescription());
        }
        root.setTestsuite(suite);
        String version = Savvytest.getVersion();
        String creationTime = DateFormat.getDateTimeInstance(2, 2).format(Calendar.getInstance().getTime());
        String comment = MessageFormat.format(Savvytest.getGlobalString((String)"xmltimestamp", (Object[])new Object[0]), version, creationTime);
        FeatureMapUtil.addProcessingInstruction((FeatureMap)root.getMixed(), (int)0, (String)"savvytestVersion", (String)version);
        FeatureMapUtil.addComment((FeatureMap)root.getMixed(), (int)1, (String)comment);
        EList scenList = suite.getTestscenarios();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("testscenario", new TestscenarioResourceFactoryImpl());
        TestscenarioPackage.eINSTANCE.eClass();
        for (IFile file : this.savvytestPage.getTestscenarioFiles()) {
            URI fileURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            Resource res = resourceSet.getResource(fileURI, true);
            scenList.add((Object)((DocumentRoot)res.getContents().get(0)).getTestscenario());
        }
        return root;
    }

    public boolean performFinish() {
        IFile modelFile;
        block6: {
            try {
                modelFile = this.getModelFile();
                WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                    protected void execute(IProgressMonitor progressMonitor) {
                        try {
                            try {
                                ResourceSetImpl resourceSet = new ResourceSetImpl();
                                URI fileURI = URI.createPlatformResourceURI((String)modelFile.getFullPath().toString(), (boolean)true);
                                Resource resource = resourceSet.createResource(fileURI);
                                EObject rootObject = TestsuiteModelWizard.this.createInitialModel();
                                if (rootObject != null) {
                                    resource.getContents().add((Object)rootObject);
                                }
                                HashMap<String, String> options = new HashMap<String, String>();
                                options.put("ENCODING", "UTF-8");
                                resource.save(options);
                            }
                            catch (Exception exception) {
                                TestsuiteEditorPlugin.INSTANCE.log(exception);
                                progressMonitor.done();
                            }
                        }
                        finally {
                            progressMonitor.done();
                        }
                    }
                };
                this.getContainer().run(false, false, (IRunnableWithProgress)operation);
                if (modelFile.isAccessible()) break block6;
                DefaultSavvytestWizardPage.displayFileCreationErrorMessage((Shell)this.getShell());
                return true;
            }
            catch (Exception exception) {
                TestsuiteEditorPlugin.INSTANCE.log(exception);
                return false;
            }
        }
        IWorkbenchWindow workbenchWindow = this.workbench.getActiveWorkbenchWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        final IWorkbenchPart activePart = page.getActivePart();
        if (activePart instanceof ISetSelectionTarget) {
            StructuredSelection targetSelection = new StructuredSelection((Object)modelFile);
            this.getShell().getDisplay().asyncExec(new Runnable((ISelection)targetSelection){
                private final /* synthetic */ ISelection val$targetSelection;
                {
                    this.val$targetSelection = iSelection;
                }

                @Override
                public void run() {
                    ((ISetSelectionTarget)activePart).selectReveal(this.val$targetSelection);
                }
            });
        }
        try {
            page.openEditor((IEditorInput)new FileEditorInput(modelFile), this.workbench.getEditorRegistry().getDefaultEditor(modelFile.getFullPath().toString()).getId());
        }
        catch (PartInitException exception) {
            MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)TestsuiteEditorPlugin.INSTANCE.getString("_UI_OpenEditorError_label"), (String)exception.getMessage());
            return false;
        }
        return true;
    }

    public void addPages() {
        this.defaultPage = new DefaultSavvytestWizardPage("DefPage");
        this.defaultPage.setTitle(TestsuiteEditorPlugin.INSTANCE.getString("_UI_TestsuiteModelWizard_label"));
        this.defaultPage.setDescription(DefaultSavvytestWizardPage.DEFAULT_PAGE_DESCRIPTION);
        this.addPage((IWizardPage)this.defaultPage);
        this.savvytestPage = new SavvytestTestsuiteWizardPage("ScenariosPage");
        this.savvytestPage.setTitle(TestsuiteEditorPlugin.INSTANCE.getString("_UI_TestsuiteModelWizard_label"));
        this.savvytestPage.setDescription(TestsuiteModelWizard.getClassString("description"));
        this.addPage((IWizardPage)this.savvytestPage);
        this.newFileCreationPage = new TestsuiteModelWizardNewFileCreationPage("NewPage", this.selection);
        this.newFileCreationPage.setFileExtension(FILE_EXTENSIONS.get(0));
        this.newFileCreationPage.setTitle(TestsuiteEditorPlugin.INSTANCE.getString("_UI_TestsuiteModelWizard_label"));
        this.newFileCreationPage.setDescription(TestsuiteEditorPlugin.INSTANCE.getString("_UI_TestsuiteModelWizard_description"));
        this.newFileCreationPage.setFileName(String.valueOf(TestsuiteEditorPlugin.INSTANCE.getString("_UI_TestsuiteEditorFilenameDefaultBase")) + "." + FILE_EXTENSIONS.get(0));
        this.addPage((IWizardPage)this.newFileCreationPage);
        IFolder container = null;
        IProject project = null;
        if (this.selection != null && !this.selection.isEmpty()) {
            ArrayList<IFile> files = new ArrayList<IFile>();
            for (Object selectedElement : this.selection) {
                if (!(selectedElement instanceof IResource)) continue;
                IResource resource = (IResource)selectedElement;
                if (container == null && (container = SavvytestTypeEnum.TESTSUITE.getDefaultFolder(resource)) != null) {
                    project = container.getProject();
                    this.defaultPage.setProject(project);
                    this.defaultPage.setHideProject(true);
                    this.savvytestPage.updateProject(project);
                    this.newFileCreationPage.setContainerFullPath(container.getFullPath());
                }
                if (!resource.getProject().equals(project)) continue;
                switch (resource.getType()) {
                    case 1: {
                        if (SavvytestTypeEnum.TESTSCENARIO.isType(resource)) {
                            files.add((IFile)resource);
                            break;
                        }
                        if (!SavvytestTypeEnum.TESTSUITE.isType(resource)) break;
                        this.newFileCreationPage.setContainerFullPath(((IFile)resource).getParent().getFullPath());
                        break;
                    }
                    case 2: {
                        if (!SavvytestTypeEnum.TESTSUITE.isType(resource)) break;
                        this.newFileCreationPage.setContainerFullPath(((IFolder)resource).getFullPath());
                    }
                }
            }
            this.savvytestPage.setTestscenariosFiles(files);
        }
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        Savvytest.setDynamicHelp((String)"com.savvytest.eclipse.help.DefaultContextHelp", (Control[])new Control[]{this.getShell()});
    }

    public IFile getModelFile() {
        return this.newFileCreationPage.getModelFile();
    }

    public class TestsuiteModelWizardInitialObjectCreationPage
    extends WizardPage {
        protected Combo initialObjectField;
        protected List<String> encodings;
        protected Combo encodingField;
        protected ModifyListener validator;

        public TestsuiteModelWizardInitialObjectCreationPage(String pageId) {
            super(pageId);
            this.validator = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    TestsuiteModelWizardInitialObjectCreationPage.this.setPageComplete(TestsuiteModelWizardInitialObjectCreationPage.this.validatePage());
                }
            };
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            layout.verticalSpacing = 12;
            composite.setLayout((Layout)layout);
            GridData data = new GridData();
            data.verticalAlignment = 4;
            data.grabExcessVerticalSpace = true;
            data.horizontalAlignment = 4;
            composite.setLayoutData((Object)data);
            Label containerLabel = new Label(composite, 16384);
            containerLabel.setText(TestsuiteEditorPlugin.INSTANCE.getString("_UI_ModelObject"));
            data = new GridData();
            data.horizontalAlignment = 4;
            containerLabel.setLayoutData((Object)data);
            this.initialObjectField = new Combo(composite, 2048);
            data = new GridData();
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            this.initialObjectField.setLayoutData((Object)data);
            for (String objectName : TestsuiteModelWizard.this.getInitialObjectNames()) {
                this.initialObjectField.add(this.getLabel(objectName));
            }
            if (this.initialObjectField.getItemCount() == 1) {
                this.initialObjectField.select(0);
            }
            this.initialObjectField.addModifyListener(this.validator);
            Label encodingLabel = new Label(composite, 16384);
            encodingLabel.setText(TestsuiteEditorPlugin.INSTANCE.getString("_UI_XMLEncoding"));
            GridData data2 = new GridData();
            data2.horizontalAlignment = 4;
            encodingLabel.setLayoutData((Object)data2);
            this.encodingField = new Combo(composite, 2048);
            data2 = new GridData();
            data2.horizontalAlignment = 4;
            data2.grabExcessHorizontalSpace = true;
            this.encodingField.setLayoutData((Object)data2);
            for (String encoding : this.getEncodings()) {
                this.encodingField.add(encoding);
            }
            this.encodingField.select(0);
            this.encodingField.addModifyListener(this.validator);
            this.setPageComplete(this.validatePage());
            this.setControl((Control)composite);
        }

        protected boolean validatePage() {
            return this.getInitialObjectName() != null && this.getEncodings().contains(this.encodingField.getText());
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible) {
                if (this.initialObjectField.getItemCount() == 1) {
                    this.initialObjectField.clearSelection();
                    this.encodingField.setFocus();
                } else {
                    this.encodingField.clearSelection();
                    this.initialObjectField.setFocus();
                }
            }
        }

        public String getInitialObjectName() {
            String label = this.initialObjectField.getText();
            for (String name : TestsuiteModelWizard.this.getInitialObjectNames()) {
                if (!this.getLabel(name).equals(label)) continue;
                return name;
            }
            return null;
        }

        public String getEncoding() {
            return this.encodingField.getText();
        }

        protected String getLabel(String featureName) {
            try {
                return TestsuiteEditPlugin.INSTANCE.getString("_UI_DocumentRoot_" + featureName + "_feature");
            }
            catch (MissingResourceException mre) {
                TestsuiteEditorPlugin.INSTANCE.log(mre);
                return featureName;
            }
        }

        protected Collection<String> getEncodings() {
            if (this.encodings == null) {
                this.encodings = new ArrayList<String>();
                StringTokenizer stringTokenizer = new StringTokenizer(TestsuiteEditorPlugin.INSTANCE.getString("_UI_XMLEncodingChoices"));
                while (stringTokenizer.hasMoreTokens()) {
                    this.encodings.add(stringTokenizer.nextToken());
                }
            }
            return this.encodings;
        }
    }

    public class TestsuiteModelWizardNewFileCreationPage
    extends WizardNewFileCreationPage {
        public TestsuiteModelWizardNewFileCreationPage(String pageId, IStructuredSelection selection) {
            super(pageId, selection);
        }

        protected boolean validatePage() {
            if (super.validatePage()) {
                String extension = new Path(this.getFileName()).getFileExtension();
                if (extension == null || !FILE_EXTENSIONS.contains(extension)) {
                    String key = FILE_EXTENSIONS.size() > 1 ? "_WARN_FilenameExtensions" : "_WARN_FilenameExtension";
                    this.setErrorMessage(TestsuiteEditorPlugin.INSTANCE.getString(key, new Object[]{FORMATTED_FILE_EXTENSIONS}));
                    return false;
                }
                return true;
            }
            return false;
        }

        public IFile getModelFile() {
            return ResourcesPlugin.getWorkspace().getRoot().getFile(this.getContainerFullPath().append(this.getFileName()));
        }
    }
}

