/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.editor.testscenario.gui;

import com.savvytest.eclipse.common.components.selection.SavvytestFileSelection;
import com.savvytest.eclipse.common.savvytestnature.SavvytestTypeEnum;
import com.savvytest.eclipse.common.util.GridDataCreator;
import com.savvytest.eclipse.core.model.xml.testcase.Testcase;
import com.savvytest.eclipse.editor.testscenario.gui.TestscenarioEditorPlugin;
import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class TestcaseComponent {
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.editor.testscenario.gui.TestcaseComponent.";
    private String testcaseName = "";
    private IFile interfaceFile;
    private String initialTestcaseName;
    private IResource initialSelection;
    private IProject projectRestriction;
    private boolean enableInterfaceSelection = true;
    private boolean allowInitialName = true;
    private List<Testcase> testcases;
    private final CopyOnWriteArraySet<Listener> validators = new CopyOnWriteArraySet();
    private Composite body;
    private SavvytestFileSelection interfaceSelection;

    protected static String getClassString(String key, Object ... substitutes) {
        String translation = TestscenarioEditorPlugin.INSTANCE.getString(TRANSLATION_PREFIX + key);
        if (substitutes.length > 0) {
            translation = MessageFormat.format(translation, substitutes);
        }
        return translation;
    }

    public Control createControl(Composite parent) {
        this.body = new Composite(parent, 0);
        this.body.setLayout((Layout)new GridLayout(2, false));
        this.body.setLayoutData((Object)GridDataCreator.fill());
        Label testcaseLabel = new Label(this.body, 0);
        testcaseLabel.setLayoutData((Object)GridDataCreator.normal());
        testcaseLabel.setText(TestcaseComponent.getClassString("testcaseLabel", new Object[0]));
        final Text testcaseText = new Text(this.body, 2048);
        testcaseText.setLayoutData((Object)GridDataCreator.horizontalFill());
        if (this.testcaseName != null) {
            this.initialTestcaseName = this.testcaseName;
            testcaseText.setText(this.testcaseName);
        }
        testcaseText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TestcaseComponent.this.testcaseName = testcaseText.getText();
                TestcaseComponent.this.notifyListeners();
            }
        });
        if (this.enableInterfaceSelection) {
            this.interfaceSelection = new SavvytestFileSelection();
            this.interfaceSelection.setTypes(new SavvytestTypeEnum[]{SavvytestTypeEnum.INTERFACE});
            this.interfaceSelection.setProjectRestriction(this.projectRestriction);
            this.interfaceSelection.setInitialSelection(this.initialSelection);
            this.interfaceSelection.addSelectionChangedListener(new ISelectionChangedListener(){
                private IFile lastFile;

                public void selectionChanged(SelectionChangedEvent event) {
                    IFile file = TestcaseComponent.this.interfaceSelection.getSelectedFile();
                    if (file != null) {
                        this.lastFile = TestcaseComponent.this.interfaceFile;
                        TestcaseComponent.this.interfaceFile = file;
                        if (testcaseText.getText().isEmpty() || this.lastFile != null && testcaseText.getText().equals(this.getTestcaseName(this.lastFile))) {
                            testcaseText.setText(this.getTestcaseName(TestcaseComponent.this.interfaceFile));
                        }
                    } else {
                        TestcaseComponent.this.interfaceFile = null;
                    }
                    TestcaseComponent.this.notifyListeners();
                }

                private String getTestcaseName(IFile file) {
                    return file.getProjectRelativePath().removeFileExtension().lastSegment();
                }
            });
            Control interfaceSelectionControl = this.interfaceSelection.createControl(this.body, 4096);
            interfaceSelectionControl.setLayoutData((Object)GridDataCreator.horizontalSpan((GridData)GridDataCreator.fill(), (int)2));
            interfaceSelectionControl.moveAbove(null);
        }
        return this.body;
    }

    public String getValidationMessage() {
        if (this.enableInterfaceSelection && (this.interfaceFile == null || !this.interfaceFile.exists())) {
            return TestcaseComponent.getClassString("error.nointerface", new Object[0]);
        }
        if (this.testcaseName.isEmpty()) {
            return TestcaseComponent.getClassString("error.noname", new Object[0]);
        }
        if (!(this.testcases == null || this.allowInitialName && this.testcaseName.equals(this.initialTestcaseName))) {
            for (Testcase testcase : this.testcases) {
                if (!this.testcaseName.equals(testcase.getName())) continue;
                return TestcaseComponent.getClassString("error.samename", new Object[0]);
            }
        }
        return null;
    }

    private void notifyListeners() {
        for (Listener listener : this.validators) {
            listener.handleEvent(new Event());
        }
    }

    public Control getControl() {
        return this.body;
    }

    public void addValidator(Listener listener) {
        this.validators.add(listener);
    }

    public void removeValidator(Listener listener) {
        this.validators.remove(listener);
    }

    public void setProjectRestriction(IProject projectRestriction) {
        this.projectRestriction = projectRestriction;
        if (this.interfaceSelection != null) {
            this.interfaceSelection.setProjectRestriction(projectRestriction);
        }
    }

    public void setEnableInterfaceSelection(boolean enableInterfaceSelection) {
        this.enableInterfaceSelection = enableInterfaceSelection;
    }

    public void setAllowInitialName(boolean allowInitialName) {
        this.allowInitialName = allowInitialName;
    }

    public void setTestcases(List<Testcase> testcases) {
        this.testcases = testcases;
    }

    public void setTestcaseName(String testcaseName) {
        this.testcaseName = testcaseName;
    }

    public String getTestcaseName() {
        return this.testcaseName;
    }

    public IFile getInterfaceFile() {
        return this.interfaceFile;
    }

    public void setInitialSelection(IResource initialSelection) {
        this.initialSelection = initialSelection;
    }

    public IResource getInitialSelection() {
        return this.initialSelection;
    }
}

