/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.editor.testscenario.gui.provider;

import com.savvytest.eclipse.core.model.xml.data.Argument;
import com.savvytest.eclipse.core.model.xml.data.Atomic;
import com.savvytest.eclipse.core.model.xml.data.Data;
import com.savvytest.eclipse.core.model.xml.data.Parameters;
import com.savvytest.eclipse.core.model.xml.properties.Properties;
import com.savvytest.eclipse.core.model.xml.properties.util.PropertiesUtils;
import com.savvytest.eclipse.core.model.xml.testcase.Testcase;
import com.savvytest.eclipse.editor.testscenario.gui.provider.TestcaseDataValueEditor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.DelegatingWrapperItemProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.swt.graphics.Color;

public class TestcaseLabelProvider
extends AdapterFactoryLabelProvider
implements ITableColorProvider {
    private Color colorDefault;
    private Color colorError;
    private Color colorIrrelevant;

    public TestcaseLabelProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public Color getForeground(Object object, int columnIndex) {
        if (columnIndex == 1) {
            String text = this.getColumnText(object, columnIndex);
            if (TestcaseDataValueEditor.isStringLengthTooLong(object, text)) {
                return this.getColorError();
            }
            String value = super.getColumnText(object, columnIndex);
            if (value == null || value.length() == 0) {
                return this.getColorDefault();
            }
        } else if (columnIndex == 2) {
            String value = super.getColumnText(object, 1);
            if (AdapterFactoryEditingDomain.unwrap((Object)object) instanceof Atomic && value != null && value.length() != 0) {
                return this.getColorIrrelevant();
            }
        }
        return super.getForeground(object, columnIndex);
    }

    public String getText(Object object) {
        return this.getColumnText(object, 0);
    }

    public String getColumnText(Object object, int columnIndex) {
        if (columnIndex == 0) {
            if (object instanceof DelegatingWrapperItemProvider) {
                String alias;
                Data data = (Data)((DelegatingWrapperItemProvider)object).getEditableValue(object);
                if (data.getBaseTypeExtension() != null && (alias = PropertiesUtils.getStringProperty((Properties)data.getBaseTypeExtension().getProperties(), (PropertiesUtils.PropertyEnum)PropertiesUtils.PropertyEnum.ALIAS)) != null && alias.length() > 0) {
                    return alias;
                }
            } else if (object instanceof Argument) {
                Argument arg = (Argument)object;
                String name = arg.getListructure().getName();
                if (name != null && name.length() > 0) {
                    return String.valueOf(super.getColumnText(object, columnIndex)) + ' ' + name;
                }
            } else if (object instanceof Parameters) {
                Parameters param = (Parameters)object;
                Argument arg = (Argument)param.eContainer();
                Testcase testcase = (Testcase)arg.eContainer();
                int index = testcase.getInputUi().indexOf((Object)arg);
                com.savvytest.eclipse.core.model.xml.iface.Argument argI = (com.savvytest.eclipse.core.model.xml.iface.Argument)testcase.getInterface().getArguments().get(index);
                String alias = PropertiesUtils.getStringProperty((Properties)argI.getProperties(), (PropertiesUtils.PropertyEnum)PropertiesUtils.PropertyEnum.ALIAS);
                if (alias != null && alias.length() > 0) {
                    return String.valueOf(super.getColumnText(object, columnIndex)) + ' ' + alias;
                }
            }
        } else if (columnIndex == 1) {
            Object obj = AdapterFactoryEditingDomain.unwrap((Object)object);
            if (obj instanceof Atomic) {
                if ((obj = ((Atomic)obj).getEffectiveValue()) != null) {
                    return obj.toString();
                }
                return null;
            }
        } else if (columnIndex == 2) {
            Data assignation;
            Object obj = AdapterFactoryEditingDomain.unwrap((Object)object);
            if (obj instanceof Data && (assignation = ((Data)obj).getAssignationVolatileData()) != null) {
                return String.valueOf(this.getTestcaseName(assignation)) + ": " + assignation.getName();
            }
            return null;
        }
        return super.getColumnText(object, columnIndex);
    }

    private String getTestcaseName(Data data) {
        Data object = data;
        while (object != null && !(object instanceof Testcase)) {
            object = object.eContainer();
        }
        if (object == null) {
            return "<null>";
        }
        return ((Testcase)object).getName();
    }

    public Color getColorDefault() {
        return this.colorDefault;
    }

    public void setColorDefault(Color color) {
        this.colorDefault = color;
    }

    public Color getColorError() {
        return this.colorError;
    }

    public void setColorError(Color color) {
        this.colorError = color;
    }

    public Color getColorIrrelevant() {
        return this.colorIrrelevant;
    }

    public void setColorIrrelevant(Color color) {
        this.colorIrrelevant = color;
    }

    public void setColors(Color colorDefault, Color colorError, Color colorIrrelevant) {
        this.setColorDefault(colorDefault);
        this.setColorError(colorError);
        this.setColorIrrelevant(colorIrrelevant);
    }
}

