/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.editor.testscenario.handlers;

import com.savvytest.eclipse.core.model.xml.testcase.Testcase;
import com.savvytest.eclipse.core.model.xml.testcase.TestcasePackage;
import com.savvytest.eclipse.core.model.xml.testscenario.Testcases;
import com.savvytest.eclipse.editor.testscenario.gui.SavvytestTestscenarioEditor;
import com.savvytest.eclipse.editor.testscenario.gui.TestcaseDialog;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class RenameTestcaseHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String newTestcaseName;
        SavvytestTestscenarioEditor editor = (SavvytestTestscenarioEditor)HandlerUtil.getActiveEditor((ExecutionEvent)event);
        EditingDomain editingDomain = editor.getEditingDomain();
        IStructuredSelection currentSelection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        Testcase testcase = (Testcase)currentSelection.getFirstElement();
        if (!editor.checkEditing()) {
            return null;
        }
        TestcaseDialog dialog = TestcaseDialog.createRenameDialog(HandlerUtil.getActiveShell((ExecutionEvent)event));
        String oldTestcaseName = testcase.getName();
        dialog.setTestcaseName(oldTestcaseName);
        dialog.setTestcases((List<Testcase>)((Testcases)testcase.eContainer()).getTestcases());
        if (dialog.open() == 0 && !(newTestcaseName = dialog.getTestcaseName()).equals(oldTestcaseName)) {
            String newTestcaseId = String.valueOf(testcase.getId().substring(0, testcase.getId().lastIndexOf(URI.encodeOpaquePart((String)oldTestcaseName, (boolean)true)))) + URI.encodeOpaquePart((String)newTestcaseName, (boolean)true);
            Command command = SetCommand.create((EditingDomain)editingDomain, (Object)testcase, (Object)TestcasePackage.eINSTANCE.getTestcase_Id(), (Object)newTestcaseId);
            editingDomain.getCommandStack().execute(command);
        }
        return null;
    }
}

