/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.editor.testscenario.migration;

import com.savvytest.eclipse.common.logging.LogLevel;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.core.model.xml.data.Argument;
import com.savvytest.eclipse.core.model.xml.data.Array;
import com.savvytest.eclipse.core.model.xml.data.Atomic;
import com.savvytest.eclipse.core.model.xml.data.Data;
import com.savvytest.eclipse.core.model.xml.data.DataFactory;
import com.savvytest.eclipse.core.model.xml.data.Number;
import com.savvytest.eclipse.core.model.xml.data.Parameters;
import com.savvytest.eclipse.core.model.xml.data.PersistentData;
import com.savvytest.eclipse.core.model.xml.data.String;
import com.savvytest.eclipse.core.model.xml.data.Struct;
import com.savvytest.eclipse.core.model.xml.data.provider.AddArrayCommand;
import com.savvytest.eclipse.core.model.xml.iface.BaseTypeExtension;
import com.savvytest.eclipse.core.model.xml.listructure.UsageType;
import com.savvytest.eclipse.core.model.xml.properties.Properties;
import com.savvytest.eclipse.core.model.xml.properties.Property;
import com.savvytest.eclipse.core.model.xml.properties.util.PropertiesUtils;
import com.savvytest.eclipse.core.model.xml.testcase.AssertEnum;
import com.savvytest.eclipse.core.model.xml.testcase.SimpleCheckcondition;
import com.savvytest.eclipse.core.model.xml.testcase.Testcase;
import com.savvytest.eclipse.core.model.xml.testcase.TestcasePackage;
import com.savvytest.eclipse.core.model.xml.testcase.util.TestcaseElementMigrationInfo;
import com.savvytest.eclipse.core.model.xml.testcase.util.TestcaseUtil;
import com.savvytest.eclipse.editor.testscenario.gui.SavvytestTestscenarioCheckconditionsPage;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public class TestscenarioElementMigration {
    private static final Pattern ARGUMENT_PATTERN = Pattern.compile(".*\\.arg(\\d+)\\.(.*)");
    private static final AbstractCommand DUMMY_COMMAND = new AbstractCommand(){

        protected boolean prepare() {
            return true;
        }

        public boolean canUndo() {
            return false;
        }

        public void execute() {
        }

        public void redo() {
        }
    };
    public final Map<PersistentData, java.lang.String> migrationMap = new HashMap<PersistentData, java.lang.String>();
    private HashMap<PersistentData, java.lang.String[]> mapUnused2Strings;
    private HashMap<PersistentData, Map<Integer, Integer>> mapUnused2ArrayPos;
    private HashMap<java.lang.String, java.lang.String[]> mapAdded2Strings;
    private HashMap<java.lang.String, Set<Integer>> mapAdded2ArrayPos;
    private HashMap<java.lang.String, PersistentData> mapID2Added;
    private HashMap<java.lang.String, SimpleCheckcondition> mapID2Checkcondition;
    private TestcaseElementMigrationInfo temi;

    public TestscenarioElementMigration() {
        this(null);
    }

    public TestscenarioElementMigration(TestcaseElementMigrationInfo info) {
        this.temi = info;
    }

    public void prepare() {
        this.prepare(true);
    }

    protected void prepare(boolean overwrite) {
        if (overwrite || this.mapUnused2Strings == null) {
            int startIndex;
            int i;
            java.lang.String[] tokenized;
            java.lang.String id;
            HashMap<Integer, Integer> arrayPosMap = new HashMap<Integer, Integer>();
            this.mapUnused2Strings = new HashMap(this.temi.unusedElements.size());
            this.mapUnused2ArrayPos = new HashMap(this.temi.unusedElements.size());
            for (PersistentData pd : this.temi.unusedElements) {
                id = pd.getId();
                tokenized = id.split("\\.");
                i = 0;
                while (i < tokenized.length) {
                    startIndex = tokenized[i].indexOf(91);
                    if (startIndex != -1) {
                        int endIndex = tokenized[i].indexOf(93);
                        java.lang.String value = tokenized[i].substring(startIndex + 1, endIndex);
                        arrayPosMap.put(i, Integer.valueOf(value));
                        tokenized[i] = tokenized[i].substring(0, startIndex);
                    }
                    ++i;
                }
                this.mapUnused2Strings.put(pd, tokenized);
                if (!arrayPosMap.isEmpty()) {
                    this.mapUnused2ArrayPos.put(pd, new HashMap(arrayPosMap));
                }
                arrayPosMap.clear();
            }
            this.mapAdded2Strings = new HashMap(this.temi.addedElements.size());
            this.mapAdded2ArrayPos = new HashMap(this.temi.addedElements.size());
            this.mapID2Added = new HashMap(this.temi.addedElements.size());
            for (PersistentData persistentData : this.temi.addedElements) {
                id = persistentData.getId();
                tokenized = id.split("\\.");
                i = 0;
                while (i < tokenized.length) {
                    startIndex = tokenized[i].indexOf(91);
                    if (startIndex != -1) {
                        arrayPosMap.put(i, null);
                        tokenized[i] = tokenized[i].substring(0, startIndex);
                    }
                    ++i;
                }
                this.mapID2Added.put(id, persistentData);
                this.mapAdded2Strings.put(id, tokenized);
                if (!arrayPosMap.isEmpty()) {
                    this.mapAdded2ArrayPos.put(id, new HashSet(arrayPosMap.keySet()));
                }
                arrayPosMap.clear();
            }
            this.mapID2Checkcondition = new HashMap(this.temi.checkconditions.size());
            for (SimpleCheckcondition checkcondition : this.temi.checkconditions) {
                if (checkcondition.getPersistentDataReference() == null || checkcondition.getPersistentDataReference().getId() == null) continue;
                id = checkcondition.getPersistentDataReference().getId();
                this.mapID2Checkcondition.put(id, checkcondition);
            }
        }
    }

    public void compute() {
        this.computeSameName();
    }

    public void computeSameName() {
        this.prepare(false);
        for (PersistentData unusedBTE : this.temi.unusedElements) {
            int matchCount = 0;
            java.lang.String matched = null;
            java.lang.String[] unused = this.mapUnused2Strings.get(unusedBTE);
            for (PersistentData persistentData : this.temi.addedElements) {
                java.lang.String structureID = persistentData.getId();
                java.lang.String[] compare = this.mapAdded2Strings.get(structureID);
                int minSize = Math.min(unused.length, compare.length);
                int i = 1;
                while (i <= minSize) {
                    if (!unused[unused.length - i].equalsIgnoreCase(compare[compare.length - i])) break;
                    ++i;
                }
                if (i - 1 <= matchCount) continue;
                matchCount = i - 1;
                matched = structureID;
                if (matchCount == unused.length) break;
            }
            if (matched == null) continue;
            Set<Integer> arrayPos = this.mapAdded2ArrayPos.get(matched);
            if (arrayPos != null) {
                java.lang.String[] id = this.mapAdded2Strings.get(matched);
                Map<Integer, Integer> unusedArrayPos = this.mapUnused2ArrayPos.get(unusedBTE);
                java.lang.String[] unusedID = this.mapUnused2Strings.get(unusedBTE);
                StringBuilder builder = new StringBuilder(16 * id.length);
                int i = 0;
                while (i < id.length) {
                    Integer index = i;
                    builder.append(id[i]);
                    if (arrayPos.contains(index)) {
                        builder.append('[');
                        int pos = -1;
                        for (Map.Entry<Integer, Integer> entry : unusedArrayPos.entrySet()) {
                            if (!id[i].equalsIgnoreCase(unusedID[entry.getKey()])) continue;
                            pos = entry.getValue();
                            break;
                        }
                        if (pos == -1) {
                            for (Map.Entry<Integer, Integer> entry : unusedArrayPos.entrySet()) {
                                if (i != entry.getKey()) continue;
                                pos = entry.getValue();
                                break;
                            }
                        }
                        if (pos == -1) {
                            pos = 0;
                            SavvytestSettings.INSTANCE.getLogger().log("Could not compute matching array position, setting to zero. ID: " + matched + " ; arrayID: " + id[i], LogLevel.DEBUG, (Object)this);
                        }
                        builder.append(pos);
                        builder.append(']');
                    }
                    builder.append('.');
                    ++i;
                }
                builder.deleteCharAt(builder.length() - 1);
                this.migrationMap.put(unusedBTE, builder.toString());
                continue;
            }
            this.migrationMap.put(unusedBTE, matched);
        }
    }

    public void applyMap(EditingDomain editingDomain, Testcase testcase) {
        TestcaseElementMigrationInfo workingCopy = this.temi.clone();
        for (Map.Entry<PersistentData, java.lang.String> entry : this.migrationMap.entrySet()) {
            java.lang.String searchForWhole = entry.getValue();
            Matcher matcher = ARGUMENT_PATTERN.matcher(searchForWhole);
            if (matcher.matches()) {
                Object value;
                int index = Integer.parseInt(matcher.group(1));
                java.lang.String searchFor = matcher.group(2);
                Parameters param = this.retrieve(index, testcase);
                EList datas = ((com.savvytest.eclipse.core.model.xml.testcase.Argument)testcase.getInput().get(index)).getDatas();
                Data data = this.retrieve(searchFor, param, editingDomain);
                if (data == null) continue;
                PersistentData persistent = data.getPersistentData();
                if (persistent == null) {
                    persistent = DataFactory.eINSTANCE.createPersistentData();
                    persistent.setVolatileData(data);
                    data.setPersistentData(persistent);
                    workingCopy.addedElements.add(persistent);
                }
                Properties props = entry.getKey().getProperties();
                persistent.setProperties(props);
                Property indexProp = PropertiesUtils.getProperty((Properties)props, (PropertiesUtils.PropertyEnum)PropertiesUtils.PropertyEnum.INDEX);
                indexProp.setValue(searchForWhole);
                if (data instanceof String) {
                    value = PropertiesUtils.getStringProperty((Properties)props, (PropertiesUtils.PropertyEnum)PropertiesUtils.PropertyEnum.VALUE_STRING);
                    ((String)data).setValue((java.lang.String)value);
                } else if (data instanceof Number) {
                    value = PropertiesUtils.getNumberProperty((Properties)props, (PropertiesUtils.PropertyEnum)PropertiesUtils.PropertyEnum.VALUE_NUMBER);
                    ((Number)data).setValue((BigDecimal)value);
                }
                SimpleCheckcondition checkcondition = this.mapID2Checkcondition.get(entry.getKey().getId());
                if (checkcondition != null) {
                    checkcondition.setVolatileDataReference(data);
                    checkcondition.setExpression(TestcaseUtil.computeExpression((SimpleCheckcondition)checkcondition));
                    this.mapID2Checkcondition.remove(checkcondition);
                    workingCopy.checkconditions.remove(checkcondition);
                }
                datas.remove((Object)entry.getKey());
                workingCopy.unusedElements.remove(entry.getKey());
                continue;
            }
            SavvytestSettings.INSTANCE.getLogger().log("Could not retrieve argument ID: " + searchForWhole, LogLevel.DEBUG, (Object)this);
        }
        for (PersistentData removeData : workingCopy.unusedElements) {
            RemoveCommand.create((EditingDomain)editingDomain, (Object)removeData).execute();
        }
        for (SimpleCheckcondition checkcondition : workingCopy.checkconditions) {
            if (checkcondition.getExpectation().getAssert() == AssertEnum.NOASSERT) {
                RemoveCommand.create((EditingDomain)editingDomain, (Object)checkcondition.eContainer(), (Object)TestcasePackage.Literals.CHECKCONDITIONS__SIMPLE_CHECKCONDITIONS, (Object)checkcondition).execute();
                continue;
            }
            SetCommand.create((EditingDomain)editingDomain, (Object)checkcondition, (Object)TestcasePackage.Literals.CHECKCONDITION__PERSISTENT_DATA_REFERENCE, null).execute();
        }
        for (PersistentData addData : workingCopy.addedElements) {
            UsageType usage;
            BaseTypeExtension baseTypeExtension;
            int index;
            Parameters param;
            Matcher matcher = ARGUMENT_PATTERN.matcher(addData.getId());
            if (matcher.matches() && (param = this.retrieve(index = Integer.parseInt(matcher.group(1)), testcase)) != null) {
                EList datas = ((com.savvytest.eclipse.core.model.xml.testcase.Argument)testcase.getInput().get(index)).getDatas();
                datas.add((Object)addData);
            }
            if ((baseTypeExtension = addData.getVolatileData().getBaseTypeExtension()) == null || (usage = PropertiesUtils.getUsage((Properties)baseTypeExtension.getProperties())) != UsageType.INOUT && usage != UsageType.OUT) continue;
            Command command = SavvytestTestscenarioCheckconditionsPage.addSimpleCheckcondition(editingDomain, (Atomic)addData.getVolatileData(), testcase.getCheckconditions(), null);
            if (command.canExecute()) {
                command.execute();
                continue;
            }
            SavvytestSettings.INSTANCE.getLogger().log("Failed to execute command to create simple checkcondition: " + command, LogLevel.WARNING, (Object)this);
        }
        editingDomain.getCommandStack().execute((Command)DUMMY_COMMAND);
    }

    private Parameters retrieve(int index, Testcase testcase) {
        Argument arg = (Argument)testcase.getInputUi().get(index);
        return arg.getParameters();
    }

    private Data retrieve(java.lang.String wholeID, Parameters param, EditingDomain domain) {
        int index = wholeID.indexOf(46);
        java.lang.String id = index == -1 ? wholeID : wholeID.substring(0, index);
        java.lang.String subID = index == -1 ? "" : wholeID.substring(index + 1);
        FeatureMap parameters = param.getParameters();
        int i = 0;
        while (i < parameters.size()) {
            Data data;
            Object value = parameters.getValue(i);
            if (value instanceof Data && id.equals((data = (Data)value).getName())) {
                return this.retrieve(subID, data, -1, domain);
            }
            ++i;
        }
        return null;
    }

    private Data retrieve(java.lang.String wholeID, Data data, int arrayIndex, EditingDomain domain) {
        if (wholeID == null) {
            return null;
        }
        if (wholeID.length() == 0) {
            return data;
        }
        int index = wholeID.indexOf(46);
        java.lang.String id = index == -1 ? wholeID : wholeID.substring(0, index);
        java.lang.String subID = index == -1 ? "" : wholeID.substring(index + 1);
        int newArrayIndex = -1;
        int startIndex = id.indexOf(91);
        if (startIndex != -1) {
            int endIndex = id.indexOf(93);
            java.lang.String value = id.substring(startIndex + 1, endIndex);
            newArrayIndex = Integer.parseInt(value);
            id = id.substring(0, startIndex);
        }
        if (data instanceof Array) {
            if (wholeID.length() == 0) {
                return data;
            }
            if (arrayIndex == -1) {
                SavvytestSettings.INSTANCE.getLogger().log("During migration, found array but no index was given: " + ((Array)data).calculateId(), LogLevel.DEBUG, (Object)this);
                return null;
            }
            Array array = (Array)data;
            FeatureMap elements = array.getElements();
            while (elements.size() <= arrayIndex) {
                Command acc = AddArrayCommand.createAddArrayCommand((EditingDomain)domain, (Array)array, (int)-1);
                acc.execute();
            }
            Object value = elements.getValue(arrayIndex);
            if (value instanceof Data) {
                return this.retrieve(wholeID, (Data)value, newArrayIndex, domain);
            }
            return null;
        }
        if (data instanceof Struct) {
            FeatureMap elements = ((Struct)data).getElements();
            int i = 0;
            while (i < elements.size()) {
                Data child;
                Object value = elements.getValue(i);
                if (value instanceof Data && id.equals((child = (Data)value).getName())) {
                    return this.retrieve(subID, child, newArrayIndex, domain);
                }
                ++i;
            }
            return null;
        }
        return null;
    }

    public void setElementMigrationInfo(TestcaseElementMigrationInfo temi) {
        this.temi = temi;
        this.mapUnused2Strings = null;
        this.migrationMap.clear();
    }

    public TestcaseElementMigrationInfo getElementMigrationInfo() {
        return this.temi;
    }
}

