/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.core.model.xml.archive.util;

import com.savvytest.eclipse.core.model.xml.archive.Archive;
import com.savvytest.eclipse.core.model.xml.archive.ArchiveFactory;
import com.savvytest.eclipse.core.model.xml.archive.ArchivePackage;
import com.savvytest.eclipse.core.model.xml.archive.DocumentRoot;
import com.savvytest.eclipse.core.model.xml.archive.util.ArchiveResourceFactoryImpl;
import com.savvytest.eclipse.core.model.xml.data.DataPackage;
import com.savvytest.eclipse.core.model.xml.iface.Argument;
import com.savvytest.eclipse.core.model.xml.iface.Interface;
import com.savvytest.eclipse.core.model.xml.iface.InterfacePackage;
import com.savvytest.eclipse.core.model.xml.iface.ui.InterfaceUiPackage;
import com.savvytest.eclipse.core.model.xml.iface.util.InterfaceResourceFactoryImpl;
import com.savvytest.eclipse.core.model.xml.listructure.Listructure;
import com.savvytest.eclipse.core.model.xml.listructure.ListructurePackage;
import com.savvytest.eclipse.core.model.xml.listructure.util.ListructureResourceFactoryImpl;
import com.savvytest.eclipse.core.model.xml.properties.PropertiesFactory;
import com.savvytest.eclipse.core.model.xml.properties.PropertiesPackage;
import com.savvytest.eclipse.core.model.xml.result.ResultPackage;
import com.savvytest.eclipse.core.model.xml.result.util.ResultResourceFactoryImpl;
import com.savvytest.eclipse.core.model.xml.stub.Stub;
import com.savvytest.eclipse.core.model.xml.stub.StubPackage;
import com.savvytest.eclipse.core.model.xml.stub.util.StubResourceFactoryImpl;
import com.savvytest.eclipse.core.model.xml.testcase.Testcase;
import com.savvytest.eclipse.core.model.xml.testcase.TestcasePackage;
import com.savvytest.eclipse.core.model.xml.testscenario.Testscenario;
import com.savvytest.eclipse.core.model.xml.testscenario.TestscenarioPackage;
import com.savvytest.eclipse.core.model.xml.testscenario.util.TestscenarioResourceFactoryImpl;
import com.savvytest.eclipse.core.model.xml.testsuite.Testsuite;
import com.savvytest.eclipse.core.model.xml.testsuite.TestsuitePackage;
import com.savvytest.eclipse.core.model.xml.testsuite.util.TestsuiteResourceFactoryImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ArchiveBuilder {
    private final Archive archive;
    private final ResourceSet resourceSet = ArchiveBuilder.getResourceSet();

    private static final ResourceSet getResourceSet() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        PropertiesPackage.eINSTANCE.eClass();
        DataPackage.eINSTANCE.eClass();
        ListructurePackage.eINSTANCE.eClass();
        InterfacePackage.eINSTANCE.eClass();
        InterfaceUiPackage.eINSTANCE.eClass();
        StubPackage.eINSTANCE.eClass();
        TestcasePackage.eINSTANCE.eClass();
        TestscenarioPackage.eINSTANCE.eClass();
        TestsuitePackage.eINSTANCE.eClass();
        ResultPackage.eINSTANCE.eClass();
        ArchivePackage.eINSTANCE.eClass();
        Map extensionMap = resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap();
        extensionMap.put("listructure", new ListructureResourceFactoryImpl());
        extensionMap.put("interface", new InterfaceResourceFactoryImpl());
        extensionMap.put("stub", new StubResourceFactoryImpl());
        extensionMap.put("testscenario", new TestscenarioResourceFactoryImpl());
        extensionMap.put("testsuite", new TestsuiteResourceFactoryImpl());
        extensionMap.put("result", new ResultResourceFactoryImpl());
        extensionMap.put("archive", new ArchiveResourceFactoryImpl());
        Map contentTypeMap = resourceSet.getResourceFactoryRegistry().getContentTypeToFactoryMap();
        contentTypeMap.put("com.savvytest.eclipse.common.savvytestTestsuite", extensionMap.get("testsuite"));
        contentTypeMap.put("com.savvytest.eclipse.common.savvytestArchive", extensionMap.get("archive"));
        return resourceSet;
    }

    public ArchiveBuilder(URI testsuiteFileURI) throws IOException {
        Resource testsuiteResource = this.resourceSet.createResource(testsuiteFileURI, "com.savvytest.eclipse.common.savvytestTestsuite");
        testsuiteResource.load(null);
        com.savvytest.eclipse.core.model.xml.testsuite.DocumentRoot testsuiteDoc = (com.savvytest.eclipse.core.model.xml.testsuite.DocumentRoot)testsuiteResource.getContents().get(0);
        this.archive = this.build(testsuiteDoc.getTestsuite());
    }

    public ArchiveBuilder(Testsuite testsuite) {
        this.archive = this.build(testsuite);
    }

    public void saveArchive(URI archiveURI) throws Exception {
        Resource archiveResource = this.resourceSet.createResource(archiveURI, "com.savvytest.eclipse.common.savvytestArchive");
        DocumentRoot doc = this.getArchiveDocument();
        archiveResource.getContents().add((Object)doc);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", "UTF-8");
        archiveResource.save(options);
    }

    public void saveArchive(OutputStream outputStream) throws Exception {
        Resource archiveResource = this.resourceSet.createResource(URI.createURI((String)"outputstream.archive"), "com.savvytest.eclipse.common.savvytestArchive");
        DocumentRoot doc = this.getArchiveDocument();
        archiveResource.getContents().add((Object)doc);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", "UTF-8");
        archiveResource.save(outputStream, options);
    }

    public Archive getArchive() {
        return this.archive;
    }

    private DocumentRoot getArchiveDocument() throws Exception {
        DocumentRoot doc = ArchiveFactory.eINSTANCE.createDocumentRoot();
        doc.setArchive(this.getArchive());
        return doc;
    }

    private Archive build(Testsuite testsuite) {
        Testsuite testsuiteCopy = (Testsuite)EcoreUtil.copy((EObject)testsuite);
        Archive archive = ArchiveFactory.eINSTANCE.createArchive();
        archive.setProperties(PropertiesFactory.eINSTANCE.createProperties());
        archive.setTestsuite(testsuiteCopy);
        this.resolve(testsuiteCopy, archive);
        this.visitTestscenarios(archive, (List<Testscenario>)testsuiteCopy.getTestscenarios());
        return archive;
    }

    private void visitTestscenarios(Archive archive, List<Testscenario> testscenarios) {
        HashSet<String> usedIds = new HashSet<String>();
        ArrayList<Testcase> testcases = new ArrayList<Testcase>();
        for (Testscenario testscenario : testscenarios) {
            if (usedIds.contains(testscenario.getId())) continue;
            usedIds.add(testscenario.getId());
            archive.getTestscenarios().add((Object)testscenario);
            testcases.addAll((Collection<Testcase>)testscenario.getTestcases().getTestcases());
        }
        this.visitTestcases(archive, testcases);
    }

    private void visitTestcases(Archive archive, List<Testcase> testcases) {
        ArrayList<Stub> stubs = new ArrayList<Stub>();
        ArrayList<Interface> ifaces = new ArrayList<Interface>();
        for (Testcase testcase : testcases) {
            stubs.addAll((Collection<Stub>)testcase.getStubs().getStubs());
            ifaces.add(testcase.getInterface());
        }
        ifaces.addAll(this.visitStubs(archive, stubs));
        this.visitIfaces(archive, ifaces);
    }

    private List<Interface> visitStubs(Archive archive, List<Stub> stubs) {
        HashSet<String> usedIds = new HashSet<String>();
        ArrayList<Interface> ifaces = new ArrayList<Interface>();
        for (Stub stub : stubs) {
            if (usedIds.contains(stub.getId())) continue;
            usedIds.add(stub.getId());
            archive.getStubs().add((Object)stub);
            ifaces.add(stub.getInterface());
        }
        return ifaces;
    }

    private void visitIfaces(Archive archive, List<Interface> ifaces) {
        HashSet<String> usedIds = new HashSet<String>();
        ArrayList<Listructure> listructures = new ArrayList<Listructure>();
        for (Interface iface : ifaces) {
            if (usedIds.contains(iface.getId())) continue;
            usedIds.add(iface.getId());
            archive.getInterfaces().add((Object)iface);
            for (Argument argument : iface.getArguments()) {
                listructures.add(argument.getListructure());
            }
        }
        this.visitListructures(archive, listructures);
    }

    private void visitListructures(Archive archive, List<Listructure> listructures) {
        HashSet<String> usedIds = new HashSet<String>();
        for (Listructure listructure : listructures) {
            if (usedIds.contains(listructure.getId())) continue;
            usedIds.add(listructure.getId());
            archive.getListructures().add((Object)listructure);
        }
    }

    private void resolve(EObject theEObject, Archive archive) {
        EcoreUtil.resolveAll((ResourceSet)this.resourceSet);
        Map map = EcoreUtil.ExternalCrossReferencer.find((EObject)theEObject);
        for (EObject eObject : map.keySet()) {
            Resource r = eObject.eResource();
            if (r == null) continue;
            this.resourceSet.getResources().add((Object)r);
            EObject root = (EObject)r.getContents().get(0);
            if (root instanceof com.savvytest.eclipse.core.model.xml.listructure.DocumentRoot) {
                Listructure listructure = ((com.savvytest.eclipse.core.model.xml.listructure.DocumentRoot)root).getListructure();
                this.resolve(listructure, archive);
                continue;
            }
            if (root instanceof com.savvytest.eclipse.core.model.xml.iface.DocumentRoot) {
                Interface iface = ((com.savvytest.eclipse.core.model.xml.iface.DocumentRoot)root).getInterface();
                this.resolve(iface, archive);
                continue;
            }
            if (root instanceof com.savvytest.eclipse.core.model.xml.testscenario.DocumentRoot) {
                Testscenario testscenario = ((com.savvytest.eclipse.core.model.xml.testscenario.DocumentRoot)root).getTestscenario();
                this.resolve(testscenario, archive);
                continue;
            }
            if (root instanceof com.savvytest.eclipse.core.model.xml.testcase.DocumentRoot) {
                Testcase testcase = ((com.savvytest.eclipse.core.model.xml.testcase.DocumentRoot)root).getTestcase();
                this.resolve(testcase, archive);
                continue;
            }
            if (!(root instanceof com.savvytest.eclipse.core.model.xml.stub.DocumentRoot)) continue;
            Stub stub = ((com.savvytest.eclipse.core.model.xml.stub.DocumentRoot)root).getStub();
            this.resolve(stub, archive);
        }
    }
}

