/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.core.model.xml.data.impl;

import com.savvytest.eclipse.core.model.xml.data.Argument;
import com.savvytest.eclipse.core.model.xml.data.Array;
import com.savvytest.eclipse.core.model.xml.data.Atomic;
import com.savvytest.eclipse.core.model.xml.data.Boolean;
import com.savvytest.eclipse.core.model.xml.data.ContainerData;
import com.savvytest.eclipse.core.model.xml.data.DataPackage;
import com.savvytest.eclipse.core.model.xml.data.DataVisitor;
import com.savvytest.eclipse.core.model.xml.data.Number;
import com.savvytest.eclipse.core.model.xml.data.Parameters;
import com.savvytest.eclipse.core.model.xml.data.String;
import com.savvytest.eclipse.core.model.xml.data.Struct;
import com.savvytest.eclipse.core.model.xml.testcase.Testcase;
import java.util.Iterator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;

public class DataVisitorImpl
implements DataVisitor {
    @Override
    public Object visit(Struct struct) throws Exception {
        return this.visitContainer(struct);
    }

    @Override
    public Object visit(Array array) throws Exception {
        return this.visitContainer(array);
    }

    protected Object visitContainer(ContainerData container) throws Exception {
        return this.visit(container.getElements());
    }

    @Override
    public Object visit(String string) throws Exception {
        return this.visitAtomic(string);
    }

    @Override
    public Object visit(Number number) throws Exception {
        return this.visitAtomic(number);
    }

    @Override
    public Object visit(Boolean bool) throws Exception {
        return this.visitAtomic(bool);
    }

    protected Object visitAtomic(Atomic atomic) throws Exception {
        return null;
    }

    public Object visit(Testcase testcase) throws Exception {
        for (Argument argument : testcase.getInputUi()) {
            this.visit(argument);
        }
        return null;
    }

    public Object visitOutput(Testcase testcase) throws Exception {
        for (Argument argument : testcase.getOutputUi()) {
            this.visit(argument);
        }
        return null;
    }

    public Object visit(Argument argument) throws Exception {
        return this.visit(argument.getParameters());
    }

    public Object visit(Parameters parameters) throws Exception {
        return this.visit(parameters.getParameters());
    }

    public Object visit(FeatureMap map) throws Exception {
        Iterator iterator = map.iterator();
        while (iterator.hasNext()) {
            this.visit((FeatureMap.Entry)iterator.next());
        }
        return null;
    }

    public Object visit(FeatureMap.Entry entry) throws Exception {
        EStructuralFeature feature = entry.getEStructuralFeature();
        if (feature == DataPackage.Literals.CONTAINER_DATA__BOOLEAN) {
            return this.visit((Boolean)entry.getValue());
        }
        if (feature == DataPackage.Literals.CONTAINER_DATA__NUMBER) {
            return this.visit((Number)entry.getValue());
        }
        if (feature == DataPackage.Literals.CONTAINER_DATA__STRING) {
            return this.visit((String)entry.getValue());
        }
        if (feature == DataPackage.Literals.CONTAINER_DATA__STRUCT) {
            return this.visit((Struct)entry.getValue());
        }
        if (feature == DataPackage.Literals.CONTAINER_DATA__ARRAY) {
            return this.visit((Array)entry.getValue());
        }
        if (feature == DataPackage.Literals.PARAMETERS__STRUCT) {
            return this.visit((Struct)entry.getValue());
        }
        if (feature == DataPackage.Literals.PARAMETERS__ARRAY) {
            return this.visit((Array)entry.getValue());
        }
        if (feature == DataPackage.Literals.PARAMETERS__BOOLEAN) {
            return this.visit((Boolean)entry.getValue());
        }
        if (feature == DataPackage.Literals.PARAMETERS__NUMBER) {
            return this.visit((Number)entry.getValue());
        }
        if (feature == DataPackage.Literals.PARAMETERS__STRING) {
            return this.visit((String)entry.getValue());
        }
        return null;
    }
}

