/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.core.model.xml.data.impl;

import com.savvytest.eclipse.core.model.xml.data.Data;
import com.savvytest.eclipse.core.model.xml.data.impl.DataVisitorImpl;
import com.savvytest.eclipse.core.model.xml.iface.BaseTypeExtension;
import com.savvytest.eclipse.core.model.xml.listructure.BaseType;
import com.savvytest.eclipse.core.model.xml.listructure.UsageType;
import com.savvytest.eclipse.core.model.xml.properties.util.PropertiesUtils;
import java.util.EnumSet;
import org.eclipse.emf.ecore.util.FeatureMap;

public class UsageDataVisitor
extends DataVisitorImpl {
    private final EnumSet<UsageType> visitUsages;
    private final boolean visitFiller;

    public UsageDataVisitor(EnumSet<UsageType> visitUsages) {
        this(visitUsages, false);
    }

    public UsageDataVisitor(EnumSet<UsageType> visitUsages, boolean showFiller) {
        this.visitUsages = EnumSet.copyOf(visitUsages);
        this.visitFiller = showFiller;
    }

    @Override
    public Object visit(FeatureMap.Entry entry) throws Exception {
        if (entry.getValue() instanceof Data && !this.isValid((Data)entry.getValue())) {
            return null;
        }
        return super.visit(entry);
    }

    protected boolean isValid(Data data) {
        if (data == null) {
            return false;
        }
        BaseTypeExtension bte = data.getBaseTypeExtension();
        BaseType bt = data.getBaseType();
        if (bte != null && bt != null) {
            UsageType type = UsageType.getByName(PropertiesUtils.getStringProperty(bte.getProperties(), PropertiesUtils.PropertyEnum.USAGE));
            boolean isFiller = PropertiesUtils.getBooleanProperty(bt.getProperties(), PropertiesUtils.PropertyEnum.FILLER, false);
            boolean passFiller = this.visitFiller || !isFiller;
            boolean passUsageType = this.visitUsages.contains((Object)type);
            return passUsageType && passFiller;
        }
        return false;
    }
}

