/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.core.model.xml.data.util;

import com.savvytest.eclipse.core.model.xml.data.PersistentData;
import java.util.HashSet;
import java.util.Set;

public class PersistentDataMigrationInfo
implements Cloneable {
    public final Set<PersistentData> unusedElements;
    public final Set<PersistentData> addedElements;

    public PersistentDataMigrationInfo() {
        this(null, null);
    }

    public PersistentDataMigrationInfo(Set<PersistentData> unusedElements, Set<PersistentData> addedElements) {
        this.unusedElements = unusedElements == null ? new HashSet<PersistentData>() : unusedElements;
        this.addedElements = addedElements == null ? new HashSet<PersistentData>() : addedElements;
    }

    public boolean isEmpty() {
        return this.unusedElements.isEmpty() && this.addedElements.isEmpty();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(500);
        builder.append("Unused extensions: ");
        builder.append(this.unusedElements.toString());
        builder.append("; Structure IDs: ");
        builder.append(this.addedElements.toString());
        return builder.toString();
    }

    public PersistentDataMigrationInfo clone() {
        PersistentDataMigrationInfo newIEM = null;
        try {
            newIEM = (PersistentDataMigrationInfo)super.clone();
            newIEM.unusedElements.addAll(this.unusedElements);
            newIEM.addedElements.addAll(this.addedElements);
        }
        catch (CloneNotSupportedException e) {
            System.err.println(e.getMessage());
        }
        return newIEM;
    }
}

