/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.core.model.xml.iface.util;

import com.savvytest.eclipse.core.model.xml.iface.Argument;
import com.savvytest.eclipse.core.model.xml.iface.BaseTypeExtension;
import com.savvytest.eclipse.core.model.xml.iface.Interface;
import com.savvytest.eclipse.core.model.xml.iface.InterfaceFactory;
import com.savvytest.eclipse.core.model.xml.iface.util.InterfaceElementMigrationInfo;
import com.savvytest.eclipse.core.model.xml.listructure.BaseType;
import com.savvytest.eclipse.core.model.xml.listructure.ContainerType;
import com.savvytest.eclipse.core.model.xml.listructure.Listructure;
import com.savvytest.eclipse.core.model.xml.listructure.UsageType;
import com.savvytest.eclipse.core.model.xml.listructure.util.ListructureUtils;
import com.savvytest.eclipse.core.model.xml.properties.Properties;
import com.savvytest.eclipse.core.model.xml.properties.PropertiesFactory;
import com.savvytest.eclipse.core.model.xml.properties.Property;
import com.savvytest.eclipse.core.model.xml.properties.util.PropertiesUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;

public class InterfaceUtils {
    public static Map<String, BaseTypeExtension> createBaseTypeExtensionMap(Collection<BaseTypeExtension> list) {
        HashMap<String, BaseTypeExtension> baseTypeExtensionMap = new HashMap<String, BaseTypeExtension>();
        for (BaseTypeExtension baseTypeExtension : list) {
            baseTypeExtensionMap.put(baseTypeExtension.getBaseType().getId(), baseTypeExtension);
        }
        return baseTypeExtensionMap;
    }

    public static void updateListrucure(Listructure listructure, Map<String, BaseTypeExtension> map, boolean updateInitialValueFromBaseType, boolean updateAliasFromBaseType) {
        TreeIterator iterator = EcoreUtil.getAllProperContents((EObject)listructure, (boolean)true);
        while (iterator.hasNext()) {
            String aliasValue;
            String fixedValue;
            BaseType baseType;
            BaseTypeExtension ext;
            EObject object = (EObject)iterator.next();
            if (!(object instanceof BaseType) || (ext = map.get((baseType = (BaseType)object).getId())) == null) continue;
            String usageStr = PropertiesUtils.getStringProperty(ext.getProperties(), PropertiesUtils.PropertyEnum.USAGE);
            UsageType usage = UsageType.get(usageStr);
            if (usage != null) {
                baseType.setUsage(usage);
            }
            if (updateInitialValueFromBaseType && (fixedValue = PropertiesUtils.getPropertyValue(ext.getProperties(), PropertiesUtils.PropertyEnum.VALUE)) != null && fixedValue.length() > 0) {
                baseType.setInitial(fixedValue);
            }
            if (!updateAliasFromBaseType || (aliasValue = PropertiesUtils.getStringProperty(ext.getProperties(), PropertiesUtils.PropertyEnum.ALIAS)) == null || aliasValue.length() <= 0) continue;
            baseType.setAlias(aliasValue);
        }
    }

    public static Listructure createListructureUi(Argument argument, InterfaceElementMigrationInfo migration) {
        Listructure orgListructure = argument.getListructure();
        Listructure uiListructure = (Listructure)EcoreUtil.copy((EObject)orgListructure);
        Map<String, BaseTypeExtension> map = InterfaceUtils.createBaseTypeExtensionMap(argument.getBaseTypeExtensions());
        HashSet<BaseTypeExtension> unused = new HashSet<BaseTypeExtension>((Collection<BaseTypeExtension>)argument.getBaseTypeExtensions());
        TreeIterator iterator = EcoreUtil.getAllProperContents((EObject)uiListructure, (boolean)true);
        TreeIterator orgIterator = EcoreUtil.getAllProperContents((EObject)orgListructure, (boolean)true);
        while (iterator.hasNext()) {
            EObject object = (EObject)iterator.next();
            EObject orgObject = (EObject)orgIterator.next();
            if (!(object instanceof BaseType)) continue;
            BaseType baseType = (BaseType)object;
            BaseTypeExtension ext = map.get(baseType.getId());
            if (ext == null) {
                ext = InterfaceFactory.eINSTANCE.createBaseTypeExtension();
                ext.setProperties(PropertiesFactory.eINSTANCE.createProperties());
                ext.setBaseType((BaseType)orgObject);
                migration.addedElements.add(ext);
                migration.mapExtension2UIBaseType.put(ext, baseType);
            } else {
                unused.remove(ext);
            }
            ListructureUtils.updateBaseTypeFromProperties(baseType, ext.getProperties());
        }
        migration.unusedElements.addAll(unused);
        return uiListructure;
    }

    public static void createBaseTypeExtension(BaseType baseType, Collection<BaseTypeExtension> list) {
        InterfaceUtils.createBaseTypeExtension(baseType, list, EnumSet.of(PropertiesUtils.PropertyEnum.USAGE));
    }

    public static void createBaseTypeExtension(BaseType baseType, Collection<BaseTypeExtension> list, EnumSet<PropertiesUtils.PropertyEnum> inheritProperties) {
        Property property;
        BaseTypeExtension ext = InterfaceFactory.eINSTANCE.createBaseTypeExtension();
        Properties properties = PropertiesFactory.eINSTANCE.createProperties();
        if (inheritProperties.contains((Object)PropertiesUtils.PropertyEnum.USAGE)) {
            property = PropertiesUtils.createProperty(PropertiesUtils.PropertyEnum.USAGE, baseType.getUsage().getLiteral());
            properties.getProperties().add((Object)property);
        }
        if (inheritProperties.contains((Object)PropertiesUtils.PropertyEnum.VALUE) && baseType.getInitial() != null && baseType.getInitial().length() > 0) {
            property = ListructureUtils.createInitialProperty(baseType);
            properties.getProperties().add((Object)property);
        }
        if (inheritProperties.contains((Object)PropertiesUtils.PropertyEnum.ALIAS) && baseType.getAlias() != null && baseType.getAlias().length() > 0) {
            property = PropertiesUtils.createProperty(PropertiesUtils.PropertyEnum.ALIAS, baseType.getAlias());
            properties.getProperties().add((Object)property);
        }
        ext.setBaseType(baseType);
        ext.setProperties(properties);
        list.add(ext);
        if (baseType instanceof ContainerType) {
            ContainerType containerType = (ContainerType)baseType;
            for (FeatureMap.Entry entry : containerType.getElements()) {
                BaseType child = (BaseType)entry.getValue();
                InterfaceUtils.createBaseTypeExtension(child, list, inheritProperties);
            }
        }
    }

    public static void fillInterface(Interface iface, Collection<Listructure> listructures, Listructure result) {
        InterfaceUtils.fillInterface(iface, listructures, result, EnumSet.of(PropertiesUtils.PropertyEnum.USAGE));
    }

    public static void fillInterface(Interface iface, Collection<Listructure> listructures, Listructure result, EnumSet<PropertiesUtils.PropertyEnum> inheritProperties) {
        if (result != null) {
            Argument resultArgument = InterfaceFactory.eINSTANCE.createArgument();
            resultArgument.setListructure(result);
            ArrayList<BaseTypeExtension> baseTypeExtensions = new ArrayList<BaseTypeExtension>();
            for (FeatureMap.Entry entry : result.getElements()) {
                BaseType baseType = (BaseType)entry.getValue();
                InterfaceUtils.createBaseTypeExtension(baseType, baseTypeExtensions, inheritProperties);
            }
            resultArgument.getBaseTypeExtensions().addAll(baseTypeExtensions);
            iface.setResult(resultArgument);
        }
        for (Listructure listructure : listructures) {
            Argument arg = InterfaceFactory.eINSTANCE.createArgument();
            arg.setProperties(PropertiesFactory.eINSTANCE.createProperties());
            arg.setListructure(listructure);
            ArrayList<BaseTypeExtension> baseTypeExtensions = new ArrayList<BaseTypeExtension>();
            for (FeatureMap.Entry entry : listructure.getElements()) {
                BaseType baseType = (BaseType)entry.getValue();
                InterfaceUtils.createBaseTypeExtension(baseType, baseTypeExtensions, inheritProperties);
            }
            arg.getBaseTypeExtensions().addAll(baseTypeExtensions);
            iface.getArguments().add((Object)arg);
        }
        if (iface.getProperties() == null) {
            iface.setProperties(PropertiesFactory.eINSTANCE.createProperties());
        }
    }
}

