/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.core.model.xml.listructure.util;

import com.savvytest.eclipse.core.model.xml.listructure.BaseType;
import com.savvytest.eclipse.core.model.xml.listructure.BooleanType;
import com.savvytest.eclipse.core.model.xml.listructure.ContainerType;
import com.savvytest.eclipse.core.model.xml.listructure.Listructure;
import com.savvytest.eclipse.core.model.xml.listructure.NumberType;
import com.savvytest.eclipse.core.model.xml.listructure.StringType;
import com.savvytest.eclipse.core.model.xml.listructure.UsageType;
import com.savvytest.eclipse.core.model.xml.properties.Properties;
import com.savvytest.eclipse.core.model.xml.properties.PropertiesFactory;
import com.savvytest.eclipse.core.model.xml.properties.Property;
import com.savvytest.eclipse.core.model.xml.properties.util.PropertiesUtils;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.util.FeatureMap;

public class ListructureUtils {
    public static Map<String, BaseType> createBaseTypeMap(Listructure listructure) {
        HashMap<String, BaseType> baseTypeMap = new HashMap<String, BaseType>();
        for (FeatureMap.Entry entry : listructure.getElements()) {
            ListructureUtils.buildBaseTypeMap(baseTypeMap, (BaseType)entry.getValue());
        }
        return baseTypeMap;
    }

    private static void buildBaseTypeMap(Map<String, BaseType> baseTypeMap, BaseType baseType) {
        baseTypeMap.put(baseType.getId(), baseType);
        if (baseType instanceof ContainerType) {
            for (FeatureMap.Entry entry : ((ContainerType)baseType).getElements()) {
                ListructureUtils.buildBaseTypeMap(baseTypeMap, (BaseType)entry.getValue());
            }
        }
    }

    public static void clearInitialValue(Listructure listructure) {
        for (FeatureMap.Entry entry : listructure.getElements()) {
            BaseType baseType = (BaseType)entry.getValue();
            ListructureUtils.clearInitialValue(baseType, true);
        }
    }

    public static void clearInitialValue(BaseType baseType, boolean recursive) {
        baseType.setInitial(null);
        if (baseType instanceof ContainerType && recursive) {
            ContainerType container = (ContainerType)baseType;
            for (FeatureMap.Entry entry : container.getElements()) {
                ListructureUtils.clearInitialValue((BaseType)entry.getValue(), recursive);
            }
        }
    }

    public static void clearUsage(Listructure listructure) {
        for (FeatureMap.Entry entry : listructure.getElements()) {
            BaseType baseType = (BaseType)entry.getValue();
            ListructureUtils.clearUsage(baseType, true);
        }
    }

    public static void clearUsage(BaseType baseType, boolean recursive) {
        baseType.unsetUsage();
        if (recursive && baseType instanceof ContainerType) {
            ContainerType container = (ContainerType)baseType;
            for (FeatureMap.Entry entry : container.getElements()) {
                ListructureUtils.clearUsage((BaseType)entry.getValue(), recursive);
            }
        }
    }

    public static void setUsage(Listructure listructure, UsageType usage) {
        for (FeatureMap.Entry entry : listructure.getElements()) {
            BaseType baseType = (BaseType)entry.getValue();
            ListructureUtils.setUsage(baseType, usage, true);
        }
    }

    public static void setUsage(BaseType baseType, UsageType usage, boolean recursive) {
        baseType.setUsage(usage);
        if (recursive && baseType instanceof ContainerType) {
            ContainerType container = (ContainerType)baseType;
            for (FeatureMap.Entry entry : container.getElements()) {
                ListructureUtils.setUsage((BaseType)entry.getValue(), usage, recursive);
            }
        }
    }

    public static void updateBaseTypeFromProperties(BaseType baseType, Properties props) {
        if (PropertiesUtils.hasProperty(props, PropertiesUtils.PropertyEnum.USAGE)) {
            baseType.setUsage(PropertiesUtils.getUsage(props));
        }
        String fixedValue = PropertiesUtils.getPropertyValue(props, PropertiesUtils.PropertyEnum.VALUE);
        baseType.setInitial(fixedValue);
        String aliasValue = PropertiesUtils.getStringProperty(props, PropertiesUtils.PropertyEnum.ALIAS);
        baseType.setAlias(aliasValue);
    }

    public static final Property createInitialProperty(BaseType baseType) {
        Property propFixedValue = PropertiesFactory.eINSTANCE.createProperty();
        if (baseType instanceof StringType) {
            propFixedValue.setName(PropertiesUtils.PropertyEnum.VALUE_STRING.getName());
            propFixedValue.setType(PropertiesUtils.PropertyEnum.VALUE_STRING.getType());
        } else if (baseType instanceof NumberType) {
            propFixedValue.setName(PropertiesUtils.PropertyEnum.VALUE_NUMBER.getName());
            propFixedValue.setType(PropertiesUtils.PropertyEnum.VALUE_NUMBER.getType());
        } else if (baseType instanceof BooleanType) {
            propFixedValue.setName(PropertiesUtils.PropertyEnum.VALUE_BOOLEAN.getName());
            propFixedValue.setType(PropertiesUtils.PropertyEnum.VALUE_BOOLEAN.getType());
        } else {
            throw new IllegalArgumentException("Unknown base type to create property for: " + baseType);
        }
        propFixedValue.setValue(baseType.getInitial());
        return propFixedValue;
    }
}

