/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.core.model.xml.testcase.util;

import com.savvytest.eclipse.core.model.xml.data.Argument;
import com.savvytest.eclipse.core.model.xml.data.Atomic;
import com.savvytest.eclipse.core.model.xml.data.ContainerData;
import com.savvytest.eclipse.core.model.xml.data.Data;
import com.savvytest.eclipse.core.model.xml.data.DataFactory;
import com.savvytest.eclipse.core.model.xml.data.PersistentData;
import com.savvytest.eclipse.core.model.xml.data.impl.DataVisitorImpl;
import com.savvytest.eclipse.core.model.xml.listructure.BaseType;
import com.savvytest.eclipse.core.model.xml.listructure.BooleanType;
import com.savvytest.eclipse.core.model.xml.listructure.NumberType;
import com.savvytest.eclipse.core.model.xml.listructure.StringType;
import com.savvytest.eclipse.core.model.xml.properties.Properties;
import com.savvytest.eclipse.core.model.xml.properties.PropertiesFactory;
import com.savvytest.eclipse.core.model.xml.properties.Property;
import com.savvytest.eclipse.core.model.xml.properties.util.PropertiesUtils;
import com.savvytest.eclipse.core.model.xml.testcase.AssertEnum;
import com.savvytest.eclipse.core.model.xml.testcase.Expectation;
import com.savvytest.eclipse.core.model.xml.testcase.ExpectationTypeEnum;
import com.savvytest.eclipse.core.model.xml.testcase.SimpleCheckcondition;
import com.savvytest.eclipse.core.model.xml.testcase.Testcase;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;

public class TestcaseUtil {
    private static final String TARGET = "TARGET";
    private static final Pattern HEX_NUMBER = Pattern.compile("[xX]'(([0-9a-fA-F][0-9a-fA-F])+)'");
    private static final Pattern REPLACEMENT = Pattern.compile("\\{([^}]+)\\}");

    public static final Map<Data, Data> getAssignationMap(Testcase testcase) throws Exception {
        final LinkedHashMap<Data, Data> assignationMap = new LinkedHashMap<Data, Data>();
        DataVisitorImpl visitor = new DataVisitorImpl(){

            @Override
            protected Object visitContainer(ContainerData container) throws Exception {
                this.checkAssignation(container);
                return super.visitContainer(container);
            }

            @Override
            protected Object visitAtomic(Atomic atomic) throws Exception {
                this.checkAssignation(atomic);
                return super.visitAtomic(atomic);
            }

            private void checkAssignation(Data data) {
                if (data.getAssignationVolatileData() != null) {
                    assignationMap.put(data, data.getAssignationVolatileData());
                }
            }
        };
        visitor.visit(testcase);
        return assignationMap;
    }

    public static final Map<Data, Data> getAssignationSuppliesMap(Testcase testcase) throws Exception {
        final LinkedHashMap<Data, Data> assignationMap = new LinkedHashMap<Data, Data>();
        DataVisitorImpl visitor = new DataVisitorImpl(){

            @Override
            protected Object visitContainer(ContainerData container) throws Exception {
                this.checkAssignation(container);
                return super.visitContainer(container);
            }

            @Override
            protected Object visitAtomic(Atomic atomic) throws Exception {
                this.checkAssignation(atomic);
                return super.visitAtomic(atomic);
            }

            private void checkAssignation(Data data) {
                if (!data.getAssignationSuppliesVolatileData().isEmpty()) {
                    for (Data assignationData : data.getAssignationSuppliesVolatileData()) {
                        assignationMap.put(assignationData, data);
                    }
                }
            }
        };
        visitor.visit(testcase);
        return assignationMap;
    }

    public static final PersistentData createPersistentData(BaseType baseType, String id, String value, Data data) {
        PersistentData persistentData = DataFactory.eINSTANCE.createPersistentData();
        Properties properties = PropertiesFactory.eINSTANCE.createProperties();
        PropertiesUtils.PropertyEnum valuePropertyType = TestcaseUtil.getPropertyTypeForValueStoring(baseType);
        if (valuePropertyType != null) {
            Property valueProperty = PropertiesUtils.createProperty(valuePropertyType, value);
            properties.getProperties().add((Object)valueProperty);
        }
        Property indexProperty = PropertiesUtils.createProperty(PropertiesUtils.PropertyEnum.INDEX, id);
        properties.getProperties().add((Object)indexProperty);
        persistentData.setBaseType(baseType);
        persistentData.setId(id);
        persistentData.setProperties(properties);
        if (data != null) {
            persistentData.setVolatileData(data);
            data.setPersistentData(persistentData);
        }
        return persistentData;
    }

    public static final PropertiesUtils.PropertyEnum getPropertyTypeForValueStoring(Atomic atomic) {
        return TestcaseUtil.getPropertyTypeForValueStoring(atomic.getBaseType());
    }

    private static final PropertiesUtils.PropertyEnum getPropertyTypeForValueStoring(BaseType bt) {
        if (bt instanceof StringType) {
            return PropertiesUtils.PropertyEnum.VALUE_STRING;
        }
        if (bt instanceof NumberType) {
            return PropertiesUtils.PropertyEnum.VALUE_NUMBER;
        }
        if (bt instanceof BooleanType) {
            return PropertiesUtils.PropertyEnum.VALUE_BOOLEAN;
        }
        return null;
    }

    public static String computeExpression(SimpleCheckcondition sc) {
        Expectation exp = sc.getExpectation();
        if (exp == null) {
            return null;
        }
        return TestcaseUtil.computeExpression(sc.getVolatileDataReference(), exp.getAssert(), exp.getValue(), exp.getType());
    }

    public static String computeExpression(Data ref, AssertEnum ae, String value, ExpectationTypeEnum type) {
        String theValue = value;
        if (ae == AssertEnum.NOASSERT) {
            return null;
        }
        if (ref != null && ae != null && (theValue != null || ae == AssertEnum.SAME || type == ExpectationTypeEnum.STRING)) {
            if (theValue == null) {
                theValue = "";
            }
            String fullID = ref.calculateId();
            StringBuilder builder = new StringBuilder(100);
            block0 : switch (ae) {
                case SAME: {
                    builder.append("output.");
                    builder.append(fullID);
                    builder.append(' ');
                    builder.append(TestcaseUtil.jexlOperator(ae));
                    builder.append(" input.");
                    builder.append(fullID);
                    break;
                }
                case NOASSERT: {
                    return null;
                }
                default: {
                    switch (type) {
                        case STRING: {
                            if (HEX_NUMBER.matcher(theValue).matches()) {
                                builder.append(theValue);
                            } else {
                                builder.append('\'');
                                builder.append(theValue);
                                builder.append('\'');
                            }
                            builder.append(' ');
                            builder.append(TestcaseUtil.jexlOperator(ae));
                            builder.append(' ');
                            builder.append("output.");
                            builder.append(fullID);
                            break block0;
                        }
                        case NUMBER: {
                            if (theValue.equals("null")) {
                                builder.append("null ");
                                builder.append(TestcaseUtil.jexlOperator(ae));
                                builder.append(' ');
                                builder.append(fullID);
                                break block0;
                            }
                            builder.append("BigDecimalCreator.make('");
                            builder.append(theValue);
                            builder.append("').compareTo(output.");
                            builder.append(fullID);
                            builder.append(") ");
                            builder.append(TestcaseUtil.jexlOperator(ae));
                            builder.append(" 0");
                            break block0;
                        }
                    }
                    System.err.println("Error in simple checkcondition. Type not recognized: " + (Object)((Object)type));
                }
            }
            return builder.toString();
        }
        return null;
    }

    private static String jexlOperator(AssertEnum ae) {
        switch (ae) {
            case EQ: 
            case SAME: {
                return "eq";
            }
            case NE: {
                return "ne";
            }
            case GE: {
                return "le";
            }
            case GT: {
                return "lt";
            }
            case LE: {
                return "ge";
            }
            case LT: {
                return "gt";
            }
        }
        return "";
    }

    public static final String getTarget(Testcase testcase) {
        Object argument;
        String target = testcase.getInterface().getTarget();
        int index = -1;
        EList<com.savvytest.eclipse.core.model.xml.iface.Argument> arguments = testcase.getInterface().getArguments();
        int i = 0;
        while (i < arguments.size()) {
            argument = (com.savvytest.eclipse.core.model.xml.iface.Argument)arguments.get(i);
            if (TARGET.equalsIgnoreCase(PropertiesUtils.getStringProperty(argument.getProperties(), PropertiesUtils.PropertyEnum.USAGE_TARGET))) {
                index = i;
                break;
            }
            ++i;
        }
        if (index != -1) {
            final HashMap map = new HashMap();
            argument = (Argument)testcase.getInputUi().get(index);
            DataVisitorImpl visitor = new DataVisitorImpl(){

                @Override
                protected Object visitAtomic(Atomic atomic) throws Exception {
                    Object value = atomic.getEffectiveValue();
                    map.put(atomic.getName(), value == null ? "" : value.toString());
                    return null;
                }
            };
            try {
                visitor.visit((Argument)argument);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Matcher matcher = REPLACEMENT.matcher(target);
            while (matcher.find()) {
                String replacement = (String)map.get(matcher.group(1));
                target = matcher.replaceFirst(replacement == null ? "" : replacement);
                matcher = REPLACEMENT.matcher(target);
            }
        }
        return target;
    }

    private TestcaseUtil() {
    }
}

