/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.runner;

import com.savvytest.eclipse.common.Savvytest;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.common.util.MissingResourceUtil;
import com.savvytest.eclipse.common.util.editing.EditingUtility;
import com.savvytest.eclipse.core.model.xml.testscenario.Testscenario;
import com.savvytest.eclipse.core.model.xml.testsuite.Testsuite;
import com.savvytest.eclipse.runner.RunTestsuiteJob;
import com.savvytest.eclipse.runner.RunnerInformation;
import com.savvytest.eclipse.runner.RunnerSettingsDialog;
import com.savvytest.eclipse.runner.SavvytestRunnerPlugin;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.osgi.service.prefs.BackingStoreException;

public abstract class AbstractRunAction
implements IObjectActionDelegate {
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.runner.AbstractRunAction.";
    private IFile[] files;
    private IWorkbenchPart part;

    protected static String getClassString(String key, Object ... substitutes) {
        String translation = SavvytestRunnerPlugin.INSTANCE.getString(TRANSLATION_PREFIX + key);
        if (substitutes.length > 0) {
            translation = MessageFormat.format(translation, substitutes);
        }
        return translation;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.setFiles(new IFile[0]);
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            IProject project = null;
            ArrayList<IFile> files = new ArrayList<IFile>();
            for (Object element : (IStructuredSelection)selection) {
                if (!(element instanceof IFile)) continue;
                try {
                    IContentDescription contentDescription;
                    IFile selFile = (IFile)element;
                    if (project == null) {
                        project = selFile.getProject();
                    }
                    if ((contentDescription = selFile.getContentDescription()) == null || !this.getFileContentTypeID().equals(contentDescription.getContentType().getId()) || !project.equals((Object)selFile.getProject())) continue;
                    files.add(selFile);
                }
                catch (CoreException e) {
                    SavvytestSettings.INSTANCE.getLogger().log((Exception)((Object)e), (Object)this);
                }
            }
            this.setFiles(files.toArray(new IFile[files.size()]));
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.setPart(targetPart);
    }

    protected Job createJob(IFile suiteFile, RunnerInformation information) throws OperationCanceledException {
        IFile testsuiteFile = suiteFile;
        if (this.needsTemporaryFile(testsuiteFile)) {
            testsuiteFile = this.createTemporaryTestsuiteFile(testsuiteFile);
        }
        RunTestsuiteJob job = new RunTestsuiteJob(testsuiteFile, information);
        job.setPriority(30);
        job.setUser(true);
        return job;
    }

    protected RunnerInformation getDefaultRunnerInformation(IProject project) throws OperationCanceledException {
        RunnerInformation information = new RunnerInformation();
        try {
            information.loadFromProjectPreferences(project);
        }
        catch (CoreException e) {
            SavvytestSettings.INSTANCE.getLogger().log((Exception)((Object)e), (Object)this);
        }
        catch (BackingStoreException e) {
            SavvytestSettings.INSTANCE.getLogger().log((Exception)((Object)e), (Object)this);
        }
        RunnerSettingsDialog dialog = new RunnerSettingsDialog(this.part.getSite().getShell(), project);
        dialog.setInformation(information);
        if (dialog.open() == 0) {
            return dialog.getInformation();
        }
        throw new OperationCanceledException();
    }

    private boolean needsTemporaryFile(IFile suiteFile) {
        Testsuite testsuite = EditingUtility.loadTestsuite((IFile)suiteFile, null);
        Map missingResources = MissingResourceUtil.checkMissingResourcesForTestsuite((Testsuite)testsuite);
        if (missingResources.isEmpty()) {
            return false;
        }
        String missingResourcesString = MissingResourceUtil.buildMissingResourcesString((Map)missingResources, (String)"\n");
        if (!MessageDialog.openConfirm((Shell)this.getPart().getSite().getShell(), (String)AbstractRunAction.getClassString("missingresourcestitle", new Object[0]), (String)AbstractRunAction.getClassString("missingresourcesmessage", missingResourcesString))) {
            throw new OperationCanceledException();
        }
        return true;
    }

    private IFile createTemporaryTestsuiteFile(IFile suiteFile) {
        IFile tempFile;
        AdapterFactoryEditingDomain editingDomain = EditingUtility.createDefaultEditingDomain();
        Testsuite testsuite = EditingUtility.loadTestsuite((IFile)suiteFile, (EditingDomain)editingDomain);
        Iterator testscenarios = testsuite.getTestscenarios().iterator();
        while (testscenarios.hasNext()) {
            Testscenario testscenario = (Testscenario)testscenarios.next();
            if (!testscenario.eIsProxy() && MissingResourceUtil.checkMissingResourcesForTestscenario((Testscenario)testscenario).isEmpty()) continue;
            testscenarios.remove();
        }
        if (testsuite.getTestscenarios().isEmpty()) {
            MessageDialog.openError((Shell)this.getPart().getSite().getShell(), (String)Savvytest.getGlobalString((String)"error", (Object[])new Object[0]), (String)AbstractRunAction.getClassString("error.notestscenarios", new Object[0]));
            throw new OperationCanceledException();
        }
        try {
            tempFile = EditingUtility.getTemporaryFile((String)suiteFile.getName(), (IProject)suiteFile.getProject());
            EditingUtility.createTestsuite((IFile)tempFile, (Testsuite)testsuite, (EditingDomain)editingDomain);
        }
        catch (IOException e) {
            SavvytestSettings.INSTANCE.getLogger().log((Exception)e, (Object)this);
            MessageDialog.openError((Shell)this.getPart().getSite().getShell(), (String)Savvytest.getGlobalString((String)"error", (Object[])new Object[0]), (String)AbstractRunAction.getClassString("tempfile", new Object[0]));
            throw new OperationCanceledException();
        }
        catch (CoreException e) {
            SavvytestSettings.INSTANCE.getLogger().log((Exception)((Object)e), (Object)this);
            MessageDialog.openError((Shell)this.getPart().getSite().getShell(), (String)Savvytest.getGlobalString((String)"error", (Object[])new Object[0]), (String)AbstractRunAction.getClassString("tempfile", new Object[0]));
            throw new OperationCanceledException();
        }
        return tempFile;
    }

    protected void appendDeleteJob(final IFile file, Job waitJob) {
        if (file == null || waitJob == null) {
            return;
        }
        final Job job = new Job(AbstractRunAction.getClassString("deletetempjobname", new Object[0])){

            protected IStatus run(IProgressMonitor progressMonitor) {
                try {
                    if (file.isAccessible()) {
                        file.delete(true, progressMonitor);
                    }
                    if (progressMonitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                }
                catch (CoreException e) {
                    return new Status(4, "com.savvytest.eclipse.runner", e.getLocalizedMessage(), (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(20);
        job.setSystem(true);
        job.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().deleteRule((IResource)file));
        waitJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                job.schedule();
            }
        });
    }

    protected abstract String getFileContentTypeID();

    public void setFiles(IFile ... files) {
        this.files = files;
    }

    public IFile[] getFiles() {
        return this.files;
    }

    public void setPart(IWorkbenchPart part) {
        this.part = part;
    }

    public IWorkbenchPart getPart() {
        return this.part;
    }
}

