/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.runner;

import com.savvytest.eclipse.common.Savvytest;
import com.savvytest.eclipse.common.logging.LogLevel;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.common.savvytestnature.SavvytestTypeEnum;
import com.savvytest.eclipse.common.util.editing.EditingUtility;
import com.savvytest.eclipse.core.model.xml.archive.Archive;
import com.savvytest.eclipse.core.model.xml.archive.DocumentRoot;
import com.savvytest.eclipse.core.model.xml.archive.util.ArchiveBuilder;
import com.savvytest.eclipse.core.model.xml.properties.Properties;
import com.savvytest.eclipse.core.model.xml.properties.util.PropertiesUtils;
import com.savvytest.eclipse.core.model.xml.result.Result;
import com.savvytest.eclipse.core.model.xml.result.ResultFactory;
import com.savvytest.eclipse.core.model.xml.testsuite.Testsuite;
import com.savvytest.eclipse.reportgenerator.AbstractResultReportGenerator;
import com.savvytest.eclipse.reportgenerator.IResultReportGenerator;
import com.savvytest.eclipse.resultchecker.JexlResultchecker;
import com.savvytest.eclipse.runner.RunnerInformation;
import com.savvytest.eclipse.runner.SavvytestRunnerPlugin;
import com.savvytest.eclipse.runner.connector.ConnectorExtensionPointInformation;
import com.savvytest.eclipse.runner.connector.IConnector;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class RunTestsuiteOperation
implements IRunnableWithProgress {
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.runner.RunTestsuiteOperation.";
    private final IFile testsuiteFile;
    private final RunnerInformation information;
    private static final SimpleDateFormat FORMAT = new SimpleDateFormat("yyyyMMdd_HHmmss");
    private IFile outputFile;

    private static String getClassString(String key) {
        return SavvytestRunnerPlugin.getPlugin().getString(TRANSLATION_PREFIX + key);
    }

    public RunTestsuiteOperation(IFile testsuiteFile, RunnerInformation information) {
        this.testsuiteFile = testsuiteFile;
        this.information = information;
        if (testsuiteFile == null) {
            throw new IllegalArgumentException("TestsuiteFile must not be null.");
        }
        if (information == null) {
            throw new IllegalArgumentException("Information must not be null.");
        }
    }

    public IFile getOutputFile() {
        return this.outputFile;
    }

    private void createArchiveFile() throws Exception {
        URI outputURI = URI.createPlatformResourceURI((String)this.outputFile.getFullPath().toString(), (boolean)true);
        URI testsuiteURI = URI.createPlatformResourceURI((String)this.testsuiteFile.getFullPath().toString(), (boolean)true);
        this.logDebug("Creating archive file (" + outputURI + ") out of testsuite (" + testsuiteURI + ").");
        ArchiveBuilder archiveBuilder = new ArchiveBuilder(testsuiteURI);
        Archive archive = archiveBuilder.getArchive();
        EList properties = archive.getProperties().getProperties();
        SimpleDateFormat iso8601 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        properties.add((Object)PropertiesUtils.createProperty((PropertiesUtils.PropertyEnum)PropertiesUtils.PropertyEnum.ARCHIVE_TIMESTAMP, (String)iso8601.format(Calendar.getInstance().getTime())));
        properties.add((Object)PropertiesUtils.createProperty((PropertiesUtils.PropertyEnum)PropertiesUtils.PropertyEnum.RUNNER_DATABASE_RESET, (String)Boolean.toString(this.information.databaseReset)));
        properties.add((Object)PropertiesUtils.createProperty((PropertiesUtils.PropertyEnum)PropertiesUtils.PropertyEnum.RUNNER_REPEAT, (String)Integer.toString(this.information.repeat)));
        properties.add((Object)PropertiesUtils.createProperty((PropertiesUtils.PropertyEnum)PropertiesUtils.PropertyEnum.RUNNER_USE_STUBS, (String)Boolean.toString(this.information.useStubs)));
        if (this.information.filler != null) {
            properties.add((Object)PropertiesUtils.createProperty((PropertiesUtils.PropertyEnum)PropertiesUtils.PropertyEnum.RUNNER_FILLER, (String)this.information.filler));
        }
        archiveBuilder.saveArchive(outputURI);
        this.logDebug("Archive file (" + outputURI + ") created.");
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, OperationCanceledException {
        monitor.beginTask(MessageFormat.format(RunTestsuiteOperation.getClassString("monitor.runtestsuite"), this.testsuiteFile.getName()), -1);
        this.logDebug("Starting 'run testsuite operation' on testsuite: " + this.testsuiteFile);
        this.logDebug("Used operation information: " + this.information);
        String version = Savvytest.getVersion();
        String creationTime = DateFormat.getDateTimeInstance(2, 2).format(Calendar.getInstance().getTime());
        String comment = MessageFormat.format(Savvytest.getGlobalString((String)"xmltimestamp", (Object[])new Object[0]), version, creationTime);
        IProject project = this.information.connection.getProject();
        String fileName = this.testsuiteFile.getFullPath().removeFileExtension().lastSegment();
        IFolder outputFolder = project.getFolder(SavvytestTypeEnum.OUTPUT.foldername);
        this.outputFile = outputFolder.getFile(String.valueOf(fileName) + "." + SavvytestTypeEnum.OUTPUT.fileextension);
        IFolder resultsFolder = project.getFolder(SavvytestTypeEnum.RESULT.foldername);
        IFile resultFile = resultsFolder.getFile(String.valueOf(fileName) + "." + SavvytestTypeEnum.RESULT.fileextension);
        IFolder reportsFolder = project.getFolder(SavvytestTypeEnum.REPORT.foldername);
        IFile reportFile = reportsFolder.getFile(String.valueOf(fileName) + "." + SavvytestTypeEnum.REPORT.fileextension);
        InputStream in = null;
        try {
            try {
                this.createArchiveFile();
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ConnectorExtensionPointInformation connectorInformation = ConnectorExtensionPointInformation.getInformation(this.information.connection.getConnectorId());
                IConnector connector = connectorInformation.createConnector();
                connector.setRunnerInformation(this.information);
                this.logDebug("Running connector: " + connector);
                in = this.outputFile.getContents();
                connector.run(in, out, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                this.logDebug("Finished running connector: " + connector);
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                URI archiveURI = URI.createPlatformResourceURI((String)this.outputFile.getFullPath().toString(), (boolean)true);
                Resource archiveResource = resourceSet.createResource(archiveURI);
                URI resultURI = URI.createPlatformResourceURI((String)resultFile.getFullPath().toString(), (boolean)true);
                Resource resultResource = resourceSet.createResource(resultURI);
                this.logDebug("Loading archive.");
                archiveResource.load((InputStream)new ByteArrayInputStream(out.toByteArray()), null);
                DocumentRoot archiveDoc = (DocumentRoot)archiveResource.getContents().get(0);
                FeatureMapUtil.addProcessingInstruction((FeatureMap)archiveDoc.getMixed(), (int)0, (String)"savvytestVersion", (String)version);
                FeatureMapUtil.addComment((FeatureMap)archiveDoc.getMixed(), (int)1, (String)comment);
                Archive archive = archiveDoc.getArchive();
                monitor.subTask(RunTestsuiteOperation.getClassString("monitor.result"));
                this.logDebug("Computing results");
                HashMap archiveProperties = PropertiesUtils.getPropertiesMap((Properties)archive.getProperties());
                Result result = JexlResultchecker.getResult((Testsuite)archive.getTestsuite(), (String)((String)archiveProperties.get(PropertiesUtils.PropertyEnum.HEX_ENCODING.getName())));
                this.logDebug("Saving archive to: " + archiveURI);
                archive.setResult(result);
                archiveResource.save(EditingUtility.DEFAULT_SAVE_OPTIONS);
                this.logDebug("Saving result to: " + resultURI);
                com.savvytest.eclipse.core.model.xml.result.DocumentRoot resultDoc = ResultFactory.eINSTANCE.createDocumentRoot();
                FeatureMapUtil.addProcessingInstruction((FeatureMap)resultDoc.getMixed(), (int)0, (String)"savvytestVersion", (String)version);
                FeatureMapUtil.addComment((FeatureMap)resultDoc.getMixed(), (int)1, (String)comment);
                resultResource.getContents().add((Object)resultDoc);
                resultDoc.setResult(result);
                resultResource.save(EditingUtility.DEFAULT_SAVE_OPTIONS);
                resultFile.setDerived(true, (IProgressMonitor)new NullProgressMonitor());
                monitor.worked(1);
                this.createReport(reportFile, result, archiveProperties, monitor);
                if (this.information.saveSeveralArchives) {
                    this.saveSeveralArchives(project, fileName, monitor);
                }
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                throw new InvocationTargetException(e, e.getMessage());
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                SavvytestSettings.INSTANCE.getLogger().log((Exception)e, (Object)this);
            }
            monitor.done();
            this.logDebug("Finished testsuite operation for: " + this.testsuiteFile);
        }
    }

    private void saveSeveralArchives(IProject project, String fileName, IProgressMonitor monitor) throws CoreException {
        IFolder archiveFolder = project.getFolder(SavvytestTypeEnum.ARCHIVE.foldername);
        String archivedFilename = String.valueOf(fileName) + "_" + FORMAT.format(new Date());
        IPath archivedFile = archiveFolder.getFullPath().append(archivedFilename).addFileExtension(SavvytestTypeEnum.ARCHIVE.fileextension);
        this.logDebug("Saving archive to: " + archivedFile);
        this.outputFile.copy(archivedFile, true, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
    }

    private void createReport(IFile reportFile, Result result, Map<String, String> archiveProperties, IProgressMonitor monitor) throws CoreException, UnsupportedEncodingException {
        this.logDebug("Saving report to: " + reportFile);
        monitor.subTask(RunTestsuiteOperation.getClassString("monitor.createreport"));
        IResultReportGenerator generator = AbstractResultReportGenerator.getGenerator();
        generator.setResult(result.getTestsuiteResult());
        generator.setArchiveProperties(archiveProperties);
        String report = generator.generateReport();
        if (reportFile.exists()) {
            reportFile.setContents((InputStream)new ByteArrayInputStream(report.getBytes("UTF-8")), true, false, monitor);
        } else {
            reportFile.create((InputStream)new ByteArrayInputStream(report.getBytes("UTF-8")), 1025, monitor);
        }
        reportFile.setDerived(true, (IProgressMonitor)new NullProgressMonitor());
        monitor.worked(1);
    }

    private void logDebug(String debug) {
        SavvytestSettings.INSTANCE.getLogger().log(debug, LogLevel.DEBUG, (Object)this);
    }
}

