/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.builderparser.util;

import java.math.BigInteger;
import java.util.Arrays;

public class ByteArrayHelper {
    public static void byteCopy(byte[] source, int sourceStartPos, int bytesToCopy, byte[] destination, int destStartPos) {
        System.arraycopy(source, sourceStartPos, destination, destStartPos, bytesToCopy);
    }

    public static void byteCopy(byte[] source, byte[] destination) {
        System.arraycopy(source, 0, destination, 0, source.length);
    }

    public static void byteCopyFixedLength(byte[] source, int sourceStartPos, byte[] destination, int destStartPos, int length, byte fillValue) {
        int remainingLength = source.length - sourceStartPos;
        if (remainingLength >= length) {
            System.arraycopy(source, sourceStartPos, destination, destStartPos, length);
        } else {
            System.arraycopy(source, sourceStartPos, destination, destStartPos, remainingLength);
            Arrays.fill(destination, destStartPos + remainingLength, destStartPos + length, fillValue);
        }
    }

    public static byte[] cloneBytes(byte[] source, int sourceStartPos, int bytesToCopy) {
        byte[] destination = null;
        if (bytesToCopy > 0) {
            destination = new byte[bytesToCopy];
            System.arraycopy(source, sourceStartPos, destination, 0, bytesToCopy);
        }
        return destination;
    }

    public static void writeInt(int value, byte[] destination, int destStartPos) {
        BigInteger bigIntValue = new BigInteger(String.valueOf(value));
        byte[] byteArray = bigIntValue.toByteArray();
        if (byteArray.length < 4) {
            int i = 0;
            while (i < 4 - byteArray.length) {
                destination[destStartPos + i] = 0;
                ++i;
            }
            ByteArrayHelper.byteCopy(byteArray, 0, byteArray.length, destination, destStartPos + i);
        } else {
            ByteArrayHelper.byteCopy(byteArray, 0, 4, destination, destStartPos);
        }
    }

    public static int readInt(byte[] source, int sourceStartPos) {
        BigInteger intValue = new BigInteger(ByteArrayHelper.cloneBytes(source, sourceStartPos, 4));
        return intValue.intValue();
    }

    public static void fill(byte[] source, byte fillByte) {
        Arrays.fill(source, fillByte);
    }

    public static void fill(byte[] source, byte fillByte, int sourceStartPos, int length) {
        Arrays.fill(source, sourceStartPos, sourceStartPos + length, fillByte);
    }
}

