/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.builderparser.util;

import com.savvytest.eclipse.common.logging.LogLevel;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import java.util.ArrayList;
import java.util.List;

public class ErrorHandler {
    private final List<IErrorCode> errors = new ArrayList<IErrorCode>();
    private final List<IErrorCode> warnings = new ArrayList<IErrorCode>();

    public void handle(IErrorCode code) {
        if (code == null) {
            return;
        }
        switch (code.getType()) {
            case ERROR: {
                this.handleError(code);
                break;
            }
            case WARNING: {
                this.handleWarning(code);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown error code: " + (Object)((Object)code.getType()));
            }
        }
    }

    private void handleError(IErrorCode code) {
        this.getErrors().add(code);
        SavvytestSettings.INSTANCE.getLogger().log(code.getMessage(), LogLevel.ERROR, (Object)this);
    }

    private void handleWarning(IErrorCode code) {
        this.getWarnings().add(code);
        SavvytestSettings.INSTANCE.getLogger().log(code.getMessage(), LogLevel.WARNING, (Object)this);
    }

    public List<IErrorCode> getErrors() {
        return this.errors;
    }

    public List<IErrorCode> getWarnings() {
        return this.warnings;
    }

    public static class ErrorCode
    implements IErrorCode {
        private ErrorType type;
        private String message;
        private String name;

        public ErrorCode() {
        }

        public ErrorCode(ErrorType type, String name, String message) {
            this.type = type;
            this.message = message;
            this.name = name;
        }

        @Override
        public ErrorType getType() {
            return this.type;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public void setType(ErrorType type) {
            this.type = type;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static enum ErrorType {
        WARNING,
        ERROR;

    }

    public static interface IErrorCode {
        public ErrorType getType();

        public String getMessage();

        public String getName();
    }
}

