/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.common.components.selection;

import com.savvytest.eclipse.common.Savvytest;
import com.savvytest.eclipse.common.components.selection.AbstractSavvytestSelection;
import com.savvytest.eclipse.common.logging.LogLevel;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.common.savvytestnature.SavvytestTypeEnum;
import com.savvytest.eclipse.common.util.GridDataCreator;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SavvytestFileSelection
extends AbstractSavvytestSelection {
    private String initialFilename;

    public IFile getSelectedFile() {
        return (IFile)this.getSelectedResource(1);
    }

    public IFile[] getSelectedFiles() {
        IResource[] resources = this.getSelectedResources(1);
        return (IFile[])Arrays.copyOf(resources, resources.length, IFile[].class);
    }

    @Override
    protected Control createControl(Composite parent) {
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Composite body = new Composite(parent, 0);
        body.setLayout((Layout)layout);
        Control superControl = super.createControl(body);
        superControl.setLayoutData((Object)GridDataCreator.horizontalSpan(GridDataCreator.fill(), 2));
        if (this.getMode() == 8192) {
            Label label = new Label(body, 0);
            label.setLayoutData((Object)GridDataCreator.normal());
            label.setText(Savvytest.getGlobalString("label", Savvytest.getGlobalString("name", new Object[0])));
            final Text text = new Text(body, 2048);
            text.setLayoutData((Object)GridDataCreator.horizontalFill());
            if (this.getInitialSelection() != null && this.getInitialSelection().getType() == 1) {
                text.setText(this.getInitialSelection().getName());
            } else if (this.initialFilename != null) {
                text.setText(this.initialFilename);
            }
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SavvytestFileSelection.this.handleChange(SavvytestFileSelection.this.getSelectedResource(), text.getText().trim());
                }
            });
            this.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IResource resource = SavvytestFileSelection.this.getSelectedResource();
                    if (resource != null) {
                        if (resource.getType() == 1) {
                            String name = text.getText().trim();
                            if (!name.equals(resource.getName()) && !name.equals(resource.getFullPath().removeFileExtension().lastSegment())) {
                                text.setText(resource.getName());
                            }
                        } else {
                            SavvytestFileSelection.this.handleChange(resource, text.getText().trim());
                        }
                    }
                }
            });
            this.addStyledControl((Control)label);
            this.addStyledControl((Control)text);
        }
        return body;
    }

    private void handleChange(IResource resource, String name) {
        IFolder folder;
        if (resource == null || name == null || name.isEmpty()) {
            return;
        }
        SavvytestTypeEnum type = null;
        SavvytestTypeEnum[] savvytestTypeEnumArray = this.getTypes();
        int n = savvytestTypeEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            SavvytestTypeEnum check = savvytestTypeEnumArray[n2];
            if (check.isType(resource)) {
                type = check;
                break;
            }
            ++n2;
        }
        if (type == null) {
            SavvytestSettings.INSTANCE.getLogger().log("No applicable type discovered (" + Arrays.toString((Object[])this.getTypes()) + ") for resource: " + resource, LogLevel.DEBUG, this);
            return;
        }
        switch (resource.getType()) {
            case 1: {
                folder = (IFolder)resource.getParent();
                break;
            }
            case 2: {
                folder = (IFolder)resource;
                break;
            }
            default: {
                return;
            }
        }
        String extension = "." + type.fileextension;
        String filename = name;
        if (!filename.endsWith(extension)) {
            filename = String.valueOf(filename) + extension;
        }
        this.setNewSelection((IStructuredSelection)new StructuredSelection((Object)folder.getFile(filename)));
    }

    public String getInitialFilename() {
        return this.initialFilename;
    }

    public void setInitialFilename(String initialFilename) {
        this.initialFilename = initialFilename;
    }
}

