/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.common.logging;

import com.savvytest.eclipse.common.logging.LogLevel;
import org.eclipse.core.runtime.IStatus;

public abstract class AbstractSavvytestLogging {
    private LogLevel logLevel;

    public void log(String log, LogLevel level, Object caller) {
        if (level == null || level.ordinal() < this.getLogLevel().ordinal()) {
            return;
        }
        switch (level) {
            case DEBUG: {
                this.logDebug(log, caller);
                break;
            }
            case ERROR: {
                this.logError(log, caller);
                break;
            }
            case FATAL: {
                this.logFatal(log, caller);
                break;
            }
            case INFO: {
                this.logInfo(log, caller);
                break;
            }
            case WARNING: {
                this.logWarning(log, caller);
            }
        }
    }

    public void log(IStatus status, Object caller) {
        LogLevel level;
        if (status == null || status.isOK() || status.getSeverity() == 8) {
            return;
        }
        switch (status.getSeverity()) {
            case 1: {
                level = LogLevel.INFO;
                break;
            }
            case 2: {
                level = LogLevel.WARNING;
                break;
            }
            case 4: {
                level = LogLevel.ERROR;
                break;
            }
            default: {
                this.log("Unknown status severity to handle: " + status, LogLevel.ERROR, caller);
                return;
            }
        }
        this.log(status.getMessage(), level, caller);
    }

    public void log(Exception e, Object caller) {
        if (e == null || LogLevel.ERROR.ordinal() < this.getLogLevel().ordinal()) {
            return;
        }
        this.logException(e, caller);
    }

    protected abstract void logDebug(String var1, Object var2);

    protected abstract void logInfo(String var1, Object var2);

    protected abstract void logWarning(String var1, Object var2);

    protected abstract void logError(String var1, Object var2);

    protected abstract void logFatal(String var1, Object var2);

    protected abstract void logException(Exception var1, Object var2);

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(LogLevel level) {
        this.logLevel = level;
    }
}

