/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.common.util;

import com.savvytest.eclipse.common.Savvytest;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.common.savvytestnature.SavvytestTypeEnum;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentDescription;

public class SavvytestContentGatherer {
    private IProject project;
    private SavvytestTypeEnum theType;
    private IWorkspaceRoot workspaceRoot;

    protected IWorkspaceRoot getWorkspaceRoot() {
        if (this.workspaceRoot == null) {
            this.workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        }
        return this.workspaceRoot;
    }

    public List<IFile> searchType(SavvytestTypeEnum type) {
        if (type == null) {
            return null;
        }
        this.theType = type;
        IProject[] projects = this.project == null ? this.getWorkspaceRoot().getProjects() : new IProject[]{this.project};
        ArrayList<IFile> types = new ArrayList<IFile>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject proj = iProjectArray[n2];
            try {
                IFolder folder;
                if (proj.isAccessible() && Savvytest.hasSavvytestNature(proj) && (folder = proj.getFolder(this.theType.foldername)).exists()) {
                    this.gatherTypes(folder, types);
                }
            }
            catch (CoreException e) {
                SavvytestSettings.INSTANCE.getLogger().log((Exception)((Object)e), (Object)this);
            }
            ++n2;
        }
        return types;
    }

    private void gatherTypes(IFolder folder, List<IFile> types) throws CoreException {
        IResource[] iResourceArray = folder.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFolder childFolder;
            IResource resource = iResourceArray[n2];
            if (resource.getType() == 1) {
                IFile file = (IFile)resource;
                if (file.isAccessible()) {
                    if (this.theType.contentTypeID != null) {
                        IContentDescription desc = file.getContentDescription();
                        if (desc != null && desc.getContentType().getId().equals(this.theType.contentTypeID)) {
                            types.add(file);
                        }
                    } else if (this.theType.fileextension != null) {
                        if (this.theType.fileextension.equals(file.getFileExtension())) {
                            types.add(file);
                        }
                    } else {
                        types.add(file);
                    }
                }
            } else if (resource.getType() == 2 && (childFolder = (IFolder)resource).exists()) {
                this.gatherTypes(childFolder, types);
            }
            ++n2;
        }
    }

    public void setProject(String projectName) {
        IProject theProject = this.getWorkspaceRoot().getProject(projectName);
        this.setProject(theProject);
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public IProject getProject() {
        return this.project;
    }
}

