/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.common.util.editing;

import com.savvytest.eclipse.common.util.editing.CheckingPropertyEditingSupport;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.IPropertySourceProvider;

public class TablePropertyEditingSupport
extends CheckingPropertyEditingSupport {
    private final int columnIndex;
    private int previousIndex;
    private int nextIndex;

    public TablePropertyEditingSupport(TableViewer viewer, IPropertySourceProvider propertySourceProvider, Object propertyID, int columnIndex) {
        super((ColumnViewer)viewer, propertySourceProvider, propertyID);
        this.columnIndex = columnIndex;
    }

    private Object getSibling(Object object, int direction) {
        TableViewer table = (TableViewer)this.getViewer();
        TableItem[] items = table.getTable().getItems();
        int i = 0;
        block4: while (i < items.length) {
            if (items[i].getData().equals(object)) {
                switch (direction) {
                    case 128: {
                        if (i == 0) break block4;
                        return items[i - 1].getData();
                    }
                    case 1024: {
                        if (i == items.length - 1) break block4;
                        return items[i + 1].getData();
                    }
                }
                break;
            }
            ++i;
        }
        return null;
    }

    private void nextEdit(Object object, int direction) {
        ColumnViewer viewer = this.getViewer();
        switch (direction) {
            case 131072: {
                if (this.columnIndex >= this.nextIndex) {
                    Object sibling = this.getSibling(object, 1024);
                    if (sibling == null) break;
                    viewer.reveal(sibling);
                    viewer.editElement(sibling, this.nextIndex);
                    break;
                }
                viewer.editElement(object, this.nextIndex);
                break;
            }
            case 16384: {
                if (this.columnIndex <= this.previousIndex) {
                    Object sibling = this.getSibling(object, 128);
                    if (sibling == null) break;
                    viewer.reveal(sibling);
                    viewer.editElement(sibling, this.previousIndex);
                    break;
                }
                viewer.editElement(object, this.previousIndex);
                break;
            }
            case 128: {
                Object siblingUp = this.getSibling(object, 128);
                if (siblingUp == null) break;
                viewer.reveal(siblingUp);
                viewer.editElement(siblingUp, this.columnIndex);
                break;
            }
            case 1024: {
                Object siblingDown = this.getSibling(object, 1024);
                if (siblingDown == null) break;
                viewer.reveal(siblingDown);
                viewer.editElement(siblingDown, this.columnIndex);
            }
        }
    }

    protected CellEditor getCellEditor(final Object object) {
        CellEditor cellEditor = super.getCellEditor(object);
        Control cont = cellEditor.getControl();
        if (cont instanceof Text) {
            Text text = (Text)cont;
            Control table = this.getViewer().getControl();
            text.setFont(table.getFont());
            text.setForeground(table.getForeground());
            text.setBackground(table.getBackground());
        }
        cont.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\r' || event.character == '\n') {
                    TablePropertyEditingSupport.this.nextEdit(object, 1024);
                }
            }
        });
        cont.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent event) {
                if (event.detail == 16) {
                    TablePropertyEditingSupport.this.nextEdit(object, 131072);
                } else if (event.detail == 8) {
                    TablePropertyEditingSupport.this.nextEdit(object, 16384);
                }
            }
        });
        return cellEditor;
    }

    public void setBounds(int lowerBound, int upperBound) {
        if (this.columnIndex < lowerBound || this.columnIndex >= upperBound) {
            throw new IndexOutOfBoundsException();
        }
        this.previousIndex = this.columnIndex - 1;
        this.nextIndex = this.columnIndex + 1;
        if (this.columnIndex == lowerBound) {
            this.previousIndex = upperBound - 1;
        }
        if (this.columnIndex == upperBound - 1) {
            this.nextIndex = lowerBound;
        }
    }

    public void setEditableColumns(int ... columns) {
        int index = -1;
        int i = 0;
        while (i < columns.length) {
            if (columns[i] == this.columnIndex) {
                index = i;
                break;
            }
            ++i;
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.previousIndex = columns[(index - 1) % columns.length];
        this.nextIndex = columns[(index + 1) % columns.length];
    }
}

