/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.common.util.editing;

import com.savvytest.eclipse.common.util.editing.CutCopyPasteKeyListener;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertyEditingSupport;

public class TreePropertyEditingSupport
extends AdapterFactoryTreeEditor {
    private final TreeViewer treeViewer;
    private TreePropertyEditingSupport previousTPES;
    private TreePropertyEditingSupport nextTPES;
    private boolean firstEditing = false;
    private boolean lastEditing = false;
    private final ExposingPropertyEditingSupport exposingEditing;

    public TreePropertyEditingSupport(TreeViewer treeViewer, AdapterFactory adapterFactory, Object propertyID) {
        super(treeViewer.getTree(), adapterFactory);
        this.treeViewer = treeViewer;
        this.exposingEditing = new ExposingPropertyEditingSupport((ColumnViewer)treeViewer, (IPropertySourceProvider)new AdapterFactoryContentProvider(adapterFactory), propertyID);
    }

    private TreeItem traverse(TreeItem child, TreeItem parent, int direction, Set<TreeItem> alreadyVisited) {
        if (parent == null && child == null) {
            return null;
        }
        TreeItem actParent = parent;
        if (actParent == null) {
            actParent = child.getParentItem();
        }
        if (actParent == null) {
            return null;
        }
        int nextIndex = -1;
        switch (direction) {
            case 128: 
            case 16384: {
                if (child == null) {
                    nextIndex = actParent.getItemCount() - 1;
                } else {
                    nextIndex = alreadyVisited.contains(child) ? actParent.indexOf(child) : actParent.indexOf(child) - 1;
                    if (nextIndex < 0) {
                        alreadyVisited.add(actParent);
                        return this.traverse(actParent, actParent.getParentItem(), direction, alreadyVisited);
                    }
                }
                TreeItem next = actParent.getItem(nextIndex);
                if (!alreadyVisited.contains(next) && next.getItemCount() != 0) {
                    this.treeViewer.getTree().showItem(next.getItem(next.getItemCount() - 1));
                    TreeItem item = this.traverse(null, next, direction, alreadyVisited);
                    if (item != null) {
                        return item;
                    }
                }
                return next;
            }
            case 1024: 
            case 131072: {
                if (child == null) {
                    nextIndex = 0;
                } else {
                    if (!alreadyVisited.contains(child) && child.getItemCount() != 0) {
                        this.treeViewer.getTree().showItem(child.getItem(0));
                        TreeItem item = this.traverse(null, child, direction, alreadyVisited);
                        if (item != null) {
                            return item;
                        }
                    }
                    if ((nextIndex = actParent.indexOf(child) + 1) >= actParent.getItemCount()) {
                        alreadyVisited.add(actParent);
                        return this.traverse(actParent, actParent.getParentItem(), direction, alreadyVisited);
                    }
                }
                return actParent.getItem(nextIndex);
            }
        }
        return null;
    }

    private void nextEdit(TreeItem child, int direction, Set<TreeItem> alreadyVisited) {
        switch (direction) {
            case 131072: {
                TreeItem nextItem = child;
                if (this.lastEditing) {
                    nextItem = this.traverse(child, null, direction, alreadyVisited);
                }
                this.handleEdit(nextItem, direction, alreadyVisited, this.nextTPES);
                break;
            }
            case 16384: {
                TreeItem previousItem = child;
                if (this.firstEditing) {
                    previousItem = this.traverse(child, null, direction, alreadyVisited);
                }
                this.handleEdit(previousItem, direction, alreadyVisited, this.previousTPES);
                break;
            }
            case 128: {
                TreeItem siblingUp = this.traverse(child, null, direction, alreadyVisited);
                this.handleEdit(siblingUp, direction, alreadyVisited, this);
                break;
            }
            case 1024: {
                TreeItem siblingDown = this.traverse(child, null, direction, alreadyVisited);
                this.handleEdit(siblingDown, direction, alreadyVisited, this);
            }
        }
    }

    private void handleEdit(final TreeItem item, int direction, Set<TreeItem> alreadyVisited, final TreePropertyEditingSupport tpes) {
        if (item == null || tpes == null) {
            return;
        }
        if (tpes.canEdit(item.getData())) {
            Display.getCurrent().timerExec(100, new Runnable(){

                @Override
                public void run() {
                    TreePropertyEditingSupport.this.treeViewer.setSelection((ISelection)new StructuredSelection(item.getData()), true);
                    tpes.editItem(item);
                }
            });
        } else {
            tpes.nextEdit(item, direction, alreadyVisited);
        }
    }

    protected void editItem(final TreeItem treeItem) {
        final Object object = treeItem.getData();
        if (!this.canEdit(object)) {
            return;
        }
        String string = this.displayItemText(object);
        this.horizontalAlignment = 16384;
        this.minimumWidth = Math.max(50, treeItem.getBounds().width);
        final Text text = new Text((Composite)this.treeViewer.getControl(), 2048);
        text.setFont(this.tree.getFont());
        text.setForeground(this.tree.getForeground());
        text.setBackground(this.tree.getBackground());
        this.setEditor((Control)text, treeItem);
        text.setFocus();
        if (string != null) {
            text.setText(string);
            text.setSelection(0, string.length());
        }
        text.addKeyListener((KeyListener)new CutCopyPasteKeyListener(){

            @Override
            public void paste() {
                text.paste();
            }

            @Override
            public void cut() {
                text.cut();
            }

            @Override
            public void copy() {
                text.copy();
            }
        });
        text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent event) {
                TreePropertyEditingSupport.this.updateItemText(object, text.getText());
                TreePropertyEditingSupport.this.setEditor(null);
                text.dispose();
            }
        });
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\r' || event.character == '\n') {
                    TreePropertyEditingSupport.this.updateItemText(object, text.getText());
                    TreePropertyEditingSupport.this.setEditor(null);
                    text.dispose();
                    TreePropertyEditingSupport.this.nextEdit(treeItem, 1024, new HashSet());
                } else if (event.character == '\u001b') {
                    TreePropertyEditingSupport.this.setEditor(null);
                    text.dispose();
                }
            }
        });
        text.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent event) {
                if (event.detail == 16) {
                    TreePropertyEditingSupport.this.nextEdit(treeItem, 131072, new HashSet());
                } else if (event.detail == 8) {
                    TreePropertyEditingSupport.this.nextEdit(treeItem, 16384, new HashSet());
                }
            }
        });
    }

    protected boolean isUpdatedNeeded(Object object, String text) {
        String oldText = this.displayItemText(object);
        if (oldText == null) {
            return oldText != text;
        }
        return !oldText.equals(text);
    }

    protected boolean canEdit(Object object) {
        return this.exposingEditing.canEdit(object);
    }

    protected void updateItemText(Object object, String text) {
        if (this.isUpdatedNeeded(object, text)) {
            this.exposingEditing.setValue(object, text);
        }
    }

    protected String displayItemText(Object object) {
        return (String)this.exposingEditing.getValue(object);
    }

    public void setPreviousNext(TreePropertyEditingSupport previousTPES, TreePropertyEditingSupport nextTPES) {
        this.previousTPES = previousTPES;
        this.nextTPES = nextTPES;
    }

    public void setFirstLast(boolean firstEditing, boolean lastEditing) {
        this.firstEditing = firstEditing;
        this.lastEditing = lastEditing;
    }

    public void mouseUp(MouseEvent event) {
        TreeItem treeItem;
        if (event.button == 1 && this.editTreeItem == (treeItem = this.tree.getItem(new Point(event.x, event.y))) && this.editTreeItem != null) {
            int i = 0;
            int width = 0;
            TreeColumn[] columns = this.tree.getColumns();
            while (i < columns.length) {
                if (event.x < (width += columns[i].getWidth())) break;
                ++i;
            }
            if (i == this.getColumn()) {
                this.editTreeItem = null;
                this.editItem(treeItem);
            }
        }
    }

    private static class ExposingPropertyEditingSupport
    extends PropertyEditingSupport {
        public ExposingPropertyEditingSupport(ColumnViewer viewer, IPropertySourceProvider propertySourceProvider, Object propertyID) {
            super(viewer, propertySourceProvider, propertyID);
        }

        public boolean canEdit(Object object) {
            return super.canEdit(object);
        }

        public Object getValue(Object object) {
            return super.getValue(object);
        }

        public void setValue(Object object, Object value) {
            super.setValue(object, value);
        }
    }
}

