/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.common.util.editing.duallistselector;

import com.savvytest.eclipse.common.Savvytest;
import com.savvytest.eclipse.common.util.GridDataCreator;
import com.savvytest.eclipse.common.util.editing.duallistselector.DualListListener;
import com.savvytest.eclipse.common.util.editing.duallistselector.DualListWrapper;
import com.savvytest.eclipse.common.util.editing.duallistselector.ElementInformation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class DualListSelector<T> {
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.common.util.editing.duallistselector.DualListSelector.";
    protected final Comparator<DualListWrapper<T>> wrappedObjectComp = new Comparator<DualListWrapper<T>>(){

        @Override
        public int compare(DualListWrapper<T> o1, DualListWrapper<T> o2) {
            int hash2;
            if (o1 == null || o1.wrappedObject == null) {
                if (o2 == null || o2.wrappedObject == null) {
                    return 0;
                }
                return 1;
            }
            if (o2 == null || o2.wrappedObject == null) {
                return -1;
            }
            int hash1 = o1.wrappedObject.hashCode();
            if (hash1 < (hash2 = o2.wrappedObject.hashCode())) {
                return -1;
            }
            if (hash2 < hash1) {
                return 1;
            }
            return 0;
        }
    };
    protected final Comparator<DualListWrapper<T>> wrappedIndexComp = new Comparator<DualListWrapper<T>>(){

        @Override
        public int compare(DualListWrapper<T> o1, DualListWrapper<T> o2) {
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            return o1.getIndex() - o2.getIndex();
        }
    };
    private Object input;
    private DualListLabelProvider labelProvider;
    private DualListComparator comparator;
    private IStructuredContentProvider contentProvider;
    private CopyOnWriteArraySet<DualListListener<T>> listeners;
    private Composite mainComp;
    private Composite moveButtonComp;
    private ListViewer unselectedList;
    private ListViewer selectedList;
    private boolean preventRecursion;
    private boolean multipleElements;
    private boolean readOnly;
    private ArrayList<Control> fontColorControls = new ArrayList();
    private Button deselectButton;
    private Button moveUpButton;
    private Button selectButton;
    private Button moveDownButton;

    private static String getClassString(String key) {
        return Savvytest.getString(TRANSLATION_PREFIX + key, new Object[0]);
    }

    public DualListSelector(Composite parent, int style) {
        this.createControl(parent, style);
    }

    public void dispose() {
        if (this.contentProvider != null) {
            this.contentProvider.dispose();
        }
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
        }
        if (this.mainComp != null && !this.mainComp.isDisposed()) {
            this.mainComp.dispose();
        }
    }

    private void createControl(Composite parent, int style) {
        this.mainComp = new Composite(parent, style);
        this.mainComp.setLayout((Layout)new FormLayout());
        Composite innerMainComp = new Composite(this.mainComp, 0);
        GridLayout imcLayout = new GridLayout(4, false);
        imcLayout.marginWidth = 0;
        imcLayout.marginHeight = 0;
        innerMainComp.setLayout((Layout)imcLayout);
        Composite unselectedComp = new Composite(innerMainComp, 0);
        unselectedComp.setLayoutData((Object)GridDataCreator.fill());
        unselectedComp.setLayout((Layout)new GridLayout());
        Label unselectedLabel = new Label(unselectedComp, 0);
        unselectedLabel.setLayoutData((Object)GridDataCreator.center());
        unselectedLabel.setText(DualListSelector.getClassString("deselectlabel"));
        this.fontColorControls.add((Control)unselectedLabel);
        this.unselectedList = new ListViewer(unselectedComp);
        this.unselectedList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.unselectedList.getControl().setLayoutData((Object)GridDataCreator.fill());
        this.unselectedList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (DualListSelector.this.preventRecursion) {
                    return;
                }
                DualListSelector.this.preventRecursion = true;
                DualListSelector.this.selectedList.setSelection((ISelection)StructuredSelection.EMPTY);
                if (DualListSelector.this.listeners != null) {
                    IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                    ArrayList elements = new ArrayList(sel.size());
                    for (DualListWrapper wrapped : sel) {
                        elements.add(new ElementInformation(wrapped.getIndex(), wrapped.getIndex(), wrapped.wrappedObject));
                    }
                    Collections.sort(elements, ElementInformation.newPos);
                    for (DualListListener listener : DualListSelector.this.listeners) {
                        listener.selectionEvent(2, elements);
                    }
                }
                DualListSelector.this.preventRecursion = false;
            }
        });
        this.unselectedList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!event.getSelection().isEmpty()) {
                    DualListSelector.this.moveElement(DualListSelector.this.unselectedList, DualListSelector.this.selectedList, ((IStructuredSelection)event.getSelection()).toList());
                }
            }
        });
        this.unselectedList.getList().addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                DualListSelector.this.preventRecursion = true;
                if (e.detail == 64 && e.keyCode == 0x1000004 || e.detail == 4) {
                    e.detail = 0;
                    e.doit = true;
                    IStructuredSelection sel = (IStructuredSelection)DualListSelector.this.unselectedList.getSelection();
                    if (!sel.isEmpty()) {
                        DualListSelector.this.moveElement(DualListSelector.this.unselectedList, DualListSelector.this.selectedList, sel.toList());
                    }
                }
                DualListSelector.this.preventRecursion = false;
            }
        });
        this.fontColorControls.add(this.unselectedList.getControl());
        Composite selectButtonComp = new Composite(innerMainComp, 0);
        selectButtonComp.setLayoutData((Object)GridDataCreator.center());
        RowLayout sbcLayout = new RowLayout(512);
        sbcLayout.pack = false;
        selectButtonComp.setLayout((Layout)sbcLayout);
        Composite selectedComp = new Composite(innerMainComp, 0);
        selectedComp.setLayoutData((Object)GridDataCreator.fill());
        selectedComp.setLayout((Layout)new GridLayout());
        Label selectedLabel = new Label(selectedComp, 0);
        selectedLabel.setLayoutData((Object)GridDataCreator.center());
        selectedLabel.setText(DualListSelector.getClassString("selectlabel"));
        this.fontColorControls.add((Control)selectedLabel);
        this.selectedList = new ListViewer(selectedComp);
        this.selectedList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.selectedList.getControl().setLayoutData((Object)GridDataCreator.fill());
        this.selectedList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (DualListSelector.this.preventRecursion) {
                    return;
                }
                DualListSelector.this.preventRecursion = true;
                DualListSelector.this.unselectedList.setSelection((ISelection)StructuredSelection.EMPTY);
                if (DualListSelector.this.listeners != null) {
                    IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                    ArrayList elements = new ArrayList(sel.size());
                    for (DualListWrapper wrapped : sel) {
                        elements.add(new ElementInformation(wrapped.getIndex(), wrapped.getIndex(), wrapped.wrappedObject));
                    }
                    Collections.sort(elements, ElementInformation.newPos);
                    for (DualListListener listener : DualListSelector.this.listeners) {
                        listener.selectionEvent(1, elements);
                    }
                }
                DualListSelector.this.preventRecursion = false;
            }
        });
        this.selectedList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!event.getSelection().isEmpty()) {
                    DualListSelector.this.moveElement(DualListSelector.this.selectedList, DualListSelector.this.unselectedList, ((IStructuredSelection)event.getSelection()).toList());
                }
            }
        });
        this.selectedList.getList().addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 32 && e.keyCode == 0x1000003 || e.detail == 4) {
                    e.detail = 0;
                    e.doit = true;
                    IStructuredSelection sel = (IStructuredSelection)DualListSelector.this.selectedList.getSelection();
                    if (!sel.isEmpty()) {
                        DualListSelector.this.moveElement(DualListSelector.this.selectedList, DualListSelector.this.unselectedList, sel.toList());
                    }
                }
            }
        });
        this.fontColorControls.add(this.selectedList.getControl());
        this.moveButtonComp = new Composite(innerMainComp, 0);
        this.moveButtonComp.setLayoutData((Object)GridDataCreator.center());
        RowLayout mbcLayout = new RowLayout(512);
        mbcLayout.pack = false;
        this.moveButtonComp.setLayout((Layout)mbcLayout);
        this.deselectButton = new Button(this.moveButtonComp, 8);
        this.deselectButton.setEnabled(!this.isReadOnly());
        this.deselectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)DualListSelector.this.selectedList.getSelection();
                if (!sel.isEmpty()) {
                    DualListSelector.this.moveElement(DualListSelector.this.selectedList, DualListSelector.this.unselectedList, sel.toList());
                }
            }
        });
        this.fontColorControls.add((Control)this.deselectButton);
        this.moveUpButton = new Button(this.moveButtonComp, 8);
        this.moveUpButton.setEnabled(!this.isReadOnly());
        this.moveUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)DualListSelector.this.selectedList.getSelection();
                if (!sel.isEmpty()) {
                    DualListSelector.this.movePosition(DualListSelector.this.selectedList, sel.toList(), 128);
                }
            }
        });
        this.fontColorControls.add((Control)this.moveUpButton);
        this.selectButton = new Button(selectButtonComp, 8);
        this.selectButton.setEnabled(!this.isReadOnly());
        this.selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)DualListSelector.this.unselectedList.getSelection();
                if (!sel.isEmpty()) {
                    DualListSelector.this.moveElement(DualListSelector.this.unselectedList, DualListSelector.this.selectedList, sel.toList());
                }
            }
        });
        this.fontColorControls.add((Control)this.selectButton);
        this.moveDownButton = new Button(this.moveButtonComp, 8);
        this.moveDownButton.setEnabled(!this.isReadOnly());
        this.moveDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)DualListSelector.this.selectedList.getSelection();
                if (!sel.isEmpty()) {
                    DualListSelector.this.movePosition(DualListSelector.this.selectedList, sel.toList(), 1024);
                }
            }
        });
        this.fontColorControls.add((Control)this.moveDownButton);
        this.selectButton.setText(DualListSelector.getClassString("select"));
        this.deselectButton.setText(DualListSelector.getClassString("deselect"));
        this.moveDownButton.setText(DualListSelector.getClassString("down"));
        this.moveUpButton.setText(DualListSelector.getClassString("up"));
        FormData fd = new FormData(-1, selectButtonComp.computeSize((int)-1, (int)-1).y);
        fd.top = new FormAttachment(0, 0);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        innerMainComp.setLayoutData((Object)fd);
    }

    public Control getControl() {
        return this.mainComp;
    }

    public void setInput(Object input) {
        Assert.isNotNull((Object)this.contentProvider, (String)"Content Provider");
        Assert.isNotNull((Object)this.labelProvider, (String)"Label Provider");
        this.input = input;
        Object[] objs = this.contentProvider.getElements(input);
        if (objs != null) {
            List<DualListWrapper<Object>> list = this.wrapArray(objs);
            this.unselectedList.setInput(list);
            this.selectedList.setInput(new ArrayList(list.size()));
        } else {
            ArrayList empty = new ArrayList(0);
            this.unselectedList.setInput(empty);
            this.selectedList.setInput(empty);
        }
    }

    public Object getInput() {
        return this.input;
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        if (this.labelProvider != null) {
            labelProvider.dispose();
        }
        this.labelProvider = labelProvider == null ? null : new DualListLabelProvider(labelProvider);
        this.selectedList.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.unselectedList.setLabelProvider((IBaseLabelProvider)this.labelProvider);
    }

    public ILabelProvider getLabelProvider() {
        if (this.labelProvider == null) {
            return null;
        }
        return this.labelProvider.realLabelProvider;
    }

    public void setComparator(ViewerComparator comparator) {
        this.comparator = comparator == null ? null : new DualListComparator(comparator);
        this.unselectedList.setComparator(comparator);
    }

    public ViewerComparator getComparator() {
        if (this.comparator == null) {
            return null;
        }
        return this.comparator.realComparator;
    }

    public void setContentProvider(IStructuredContentProvider contentProvider) {
        this.contentProvider = contentProvider;
    }

    public IStructuredContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public List<T> getSelected() {
        return this.unwrapList(this.getList(this.selectedList));
    }

    public void setSelected(Collection<T> selected) {
        this.deselectAll();
        this.moveToSelected(selected);
    }

    public List<T> getUnselected() {
        return this.unwrapList(this.getList(this.unselectedList));
    }

    public void setUnselected(Collection<T> unselected) {
        this.selectAll();
        this.moveToUnselected(unselected);
    }

    public boolean isNothingSelected() {
        return this.getList(this.selectedList).isEmpty();
    }

    public boolean isEverythingSelected() {
        if (this.multipleElements) {
            List<T> unselected = this.unwrapList(this.getList(this.unselectedList));
            List<T> selected = this.unwrapList(this.getList(this.selectedList));
            return selected.containsAll(unselected);
        }
        return !this.getList(this.unselectedList).isEmpty();
    }

    private List<DualListWrapper<T>> getList(ListViewer viewer) {
        return (List)viewer.getInput();
    }

    private List<T> unwrapList(Collection<DualListWrapper<T>> wrappedList) {
        ArrayList unwrappedList = new ArrayList(wrappedList.size());
        for (DualListWrapper<T> wrapper : wrappedList) {
            unwrappedList.add(wrapper.wrappedObject);
        }
        return unwrappedList;
    }

    private List<DualListWrapper<T>> wrapList(Collection<T> unwrappedList) {
        ArrayList<DualListWrapper<T>> wrappedList = new ArrayList<DualListWrapper<T>>(unwrappedList.size());
        Iterator<T> iter = unwrappedList.iterator();
        int index = 0;
        while (iter.hasNext()) {
            wrappedList.add(new DualListWrapper<T>(iter.next(), index++));
        }
        return wrappedList;
    }

    private List<DualListWrapper<T>> wrapArray(T[] unwrappedArray) {
        ArrayList<DualListWrapper<T>> wrappedList = new ArrayList<DualListWrapper<T>>(unwrappedArray.length);
        int index = 0;
        while (index < unwrappedArray.length) {
            wrappedList.add(new DualListWrapper<T>(unwrappedArray[index], index));
            ++index;
        }
        return wrappedList;
    }

    private void streamlineIndicies(List<DualListWrapper<T>> list) {
        int index = 0;
        for (DualListWrapper<T> wrapper : list) {
            wrapper.setIndex(index++);
        }
    }

    public void selectAll() {
        if (this.isReadOnly()) {
            return;
        }
        List<DualListWrapper<T>> sel = this.getList(this.selectedList);
        List<DualListWrapper<T>> unsel = this.getList(this.unselectedList);
        ArrayList elements = new ArrayList(unsel.size());
        int index = sel.size();
        for (DualListWrapper<T> dualListWrapper : unsel) {
            elements.add(new ElementInformation(dualListWrapper.getIndex(), index, dualListWrapper.wrappedObject));
            sel.add(new DualListWrapper(dualListWrapper.wrappedObject, index++));
        }
        this.selectedList.refresh(false);
        if (!this.multipleElements) {
            unsel.clear();
            this.unselectedList.refresh(false);
        }
        if (this.listeners != null && !elements.isEmpty()) {
            for (DualListListener dualListListener : this.listeners) {
                dualListListener.movementEvent(1, elements);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void deselectAll() {
        if (this.isReadOnly()) {
            return;
        }
        List<DualListWrapper<T>> sel = this.getList(this.selectedList);
        List<DualListWrapper<T>> unsel = this.getList(this.unselectedList);
        ArrayList elements = new ArrayList(sel.size());
        if (!this.multipleElements) {
            int n = unsel.size();
            for (DualListWrapper<T> wrapper : sel) {
                void var4_5;
                elements.add(new ElementInformation(wrapper.getIndex(), -1, wrapper.wrappedObject));
                unsel.add(new DualListWrapper(wrapper.wrappedObject, (int)(++var4_5)));
            }
            this.unselectedList.refresh(false);
        } else {
            for (DualListWrapper<T> dualListWrapper : sel) {
                elements.add(new ElementInformation(dualListWrapper.getIndex(), -1, dualListWrapper.wrappedObject));
            }
        }
        sel.clear();
        this.selectedList.refresh(false);
        if (this.listeners != null) {
            for (DualListListener dualListListener : this.listeners) {
                dualListListener.movementEvent(2, elements);
            }
        }
    }

    public void moveToSelected(Collection<T> elements) {
        this.moveElement(this.unselectedList, this.selectedList, this.findWrapped(this.getList(this.unselectedList), elements));
    }

    public void moveToUnselected(Collection<T> elements) {
        this.moveElement(this.selectedList, this.unselectedList, this.findWrapped(this.getList(this.selectedList), elements));
    }

    private List<DualListWrapper<T>> findWrapped(Collection<DualListWrapper<T>> searchIn, Collection<T> elements) {
        ArrayList<DualListWrapper<T>> list = new ArrayList<DualListWrapper<T>>(elements.size());
        if (searchIn != null && !searchIn.isEmpty()) {
            ArrayList<DualListWrapper<T>> copy = new ArrayList<DualListWrapper<T>>(searchIn);
            Collections.sort(copy, this.wrappedObjectComp);
            for (T element : elements) {
                int index = Collections.binarySearch(copy, new DualListWrapper<T>(element), this.wrappedObjectComp);
                if (index < 0) continue;
                list.add(copy.get(index));
            }
        }
        return list;
    }

    private Set<DualListWrapper<T>> findUniqueWrapped(Collection<DualListWrapper<T>> searchIn, Collection<T> elements) {
        return new LinkedHashSet<DualListWrapper<T>>(this.findWrapped(searchIn, elements));
    }

    private void moveElement(ListViewer fromViewer, ListViewer toViewer, Collection<DualListWrapper<T>> elements) {
        block13: {
            if (fromViewer == null || toViewer == null || elements == null || elements.size() == 0 || this.isReadOnly()) {
                return;
            }
            List<DualListWrapper<T>> from = this.getList(fromViewer);
            List<DualListWrapper<T>> to = this.getList(toViewer);
            ArrayList listenerList = new ArrayList(elements.size());
            ISelection newSel = fromViewer.getSelection();
            if (this.multipleElements) {
                ArrayList<DualListWrapper<T>> arrayList = new ArrayList<DualListWrapper<T>>(elements.size());
                if (toViewer == this.selectedList) {
                    for (DualListWrapper<T> element : elements) {
                        DualListWrapper wrapper = new DualListWrapper(element.wrappedObject, to.size());
                        listenerList.add(new ElementInformation(element.getIndex(), to.size(), element.wrappedObject));
                        to.add(wrapper);
                        arrayList.add(wrapper);
                    }
                } else if (fromViewer == this.selectedList) {
                    ArrayList selPreserver = new ArrayList(elements.size());
                    for (DualListWrapper<T> element : elements) {
                        from.remove(element);
                        listenerList.add(new ElementInformation(element.getIndex(), -1, element.wrappedObject));
                        selPreserver.add(element.wrappedObject);
                    }
                    this.streamlineIndicies(from);
                    arrayList.addAll(this.findUniqueWrapped(to, selPreserver));
                }
                newSel = new StructuredSelection(arrayList);
            } else {
                for (DualListWrapper<T> dualListWrapper : elements) {
                    if (!from.contains(dualListWrapper)) continue;
                    listenerList.add(new ElementInformation(dualListWrapper.getIndex(), to.size(), dualListWrapper.wrappedObject));
                    dualListWrapper.setIndex(to.size());
                    to.add(dualListWrapper);
                    from.remove(dualListWrapper);
                }
                this.streamlineIndicies(from);
            }
            fromViewer.setSelection((ISelection)StructuredSelection.EMPTY);
            fromViewer.refresh(false);
            toViewer.refresh(false);
            toViewer.setSelection(newSel, true);
            toViewer.getList().setFocus();
            if (this.listeners == null || listenerList.isEmpty()) break block13;
            if (toViewer == this.selectedList) {
                for (DualListListener dualListListener : this.listeners) {
                    dualListListener.movementEvent(1, listenerList);
                }
            } else {
                for (DualListListener dualListListener : this.listeners) {
                    dualListListener.movementEvent(2, listenerList);
                }
            }
        }
    }

    public void addDualListListener(DualListListener<T> listener) {
        if (listener == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new CopyOnWriteArraySet();
        }
        this.listeners.add(listener);
    }

    public void removeDualListListener(DualListListener<T> listener) {
        if (listener == null || this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            this.listeners = null;
        }
    }

    public void moveUp(Collection<T> elements) {
        if (elements == null || elements.isEmpty()) {
            return;
        }
        Set<DualListWrapper<T>> wrapped = this.findUniqueWrapped(this.getList(this.selectedList), elements);
        if (!wrapped.isEmpty()) {
            this.movePosition(this.selectedList, wrapped, 128);
        }
    }

    public void moveDown(Collection<T> elements) {
        if (elements == null || elements.isEmpty()) {
            return;
        }
        Set<DualListWrapper<T>> wrapped = this.findUniqueWrapped(this.getList(this.selectedList), elements);
        if (!wrapped.isEmpty()) {
            this.movePosition(this.selectedList, wrapped, 1024);
        }
    }

    private void movePosition(ListViewer viewer, Collection<DualListWrapper<T>> elements, int direction) {
        block4: {
            ArrayList listenerList;
            block5: {
                if (viewer == null || elements == null || direction != 128 && direction != 1024 || this.isReadOnly()) {
                    return;
                }
                ArrayList<DualListWrapper<T>> copy = new ArrayList<DualListWrapper<T>>(elements);
                Collections.sort(copy, direction == 1024 ? Collections.reverseOrder(this.wrappedIndexComp) : this.wrappedIndexComp);
                int indexOffset = direction == 128 ? -1 : 1;
                listenerList = new ArrayList(elements.size());
                List<DualListWrapper<T>> list = this.getList(viewer);
                for (DualListWrapper<T> dualListWrapper : copy) {
                    int index = dualListWrapper.getIndex();
                    if ((direction != 128 || index <= 0) && (direction != 1024 || index >= list.size() - 1)) continue;
                    int newIndex = index + indexOffset;
                    DualListWrapper<T> swapNewPosition = list.get(newIndex);
                    swapNewPosition.setIndex(index);
                    DualListWrapper<T> swapOldPosition = list.get(index);
                    swapOldPosition.setIndex(newIndex);
                    list.set(newIndex, swapOldPosition);
                    list.set(index, swapNewPosition);
                    listenerList.add(new ElementInformation(index, newIndex, dualListWrapper.wrappedObject));
                }
                viewer.refresh(false);
                if (this.listeners == null || listenerList.isEmpty()) break block4;
                Collections.sort(listenerList, direction == 1024 ? Collections.reverseOrder(ElementInformation.oldPos) : ElementInformation.oldPos);
                if (viewer != this.selectedList) break block5;
                for (DualListListener dualListListener : this.listeners) {
                    dualListListener.positionEvent(1, listenerList);
                }
                break block4;
            }
            if (viewer != this.unselectedList) break block4;
            for (DualListListener dualListListener : this.listeners) {
                dualListListener.positionEvent(2, listenerList);
            }
        }
    }

    public void setMultipleItems(boolean multipleElements) {
        if (this.isReadOnly()) {
            return;
        }
        if (this.multipleElements != multipleElements) {
            this.multipleElements = multipleElements;
            List<DualListWrapper<T>> sel = this.getList(this.selectedList);
            List<DualListWrapper<T>> unsel = this.getList(this.unselectedList);
            if (sel != null && unsel != null) {
                if (multipleElements) {
                    ArrayList<DualListWrapper<T>> sorted = new ArrayList<DualListWrapper<T>>(unsel);
                    Collections.sort(sorted, this.wrappedObjectComp);
                    for (DualListWrapper<T> wrapped : sel) {
                        boolean found;
                        boolean bl = found = Collections.binarySearch(sorted, wrapped, this.wrappedObjectComp) >= 0;
                        if (!found) continue;
                        unsel.add(new DualListWrapper(wrapped.wrappedObject, unsel.size()));
                    }
                    this.unselectedList.refresh(false);
                } else {
                    HashMap unselPositions = new HashMap(unsel.size() * 2);
                    boolean[] removeFromUnsel = new boolean[unsel.size()];
                    for (DualListWrapper<T> wrapped : unsel) {
                        unselPositions.put(wrapped.wrappedObject, wrapped.getIndex());
                        removeFromUnsel[wrapped.getIndex()] = false;
                    }
                    HashSet set = new HashSet(sel.size() * 2);
                    Iterator<DualListWrapper<T>> iter = sel.iterator();
                    DualListWrapper<T> wrapped = iter.next();
                    while (iter.hasNext()) {
                        if (set.add(wrapped.wrappedObject)) {
                            Integer index = (Integer)unselPositions.get(wrapped.wrappedObject);
                            if (index == null) continue;
                            removeFromUnsel[index.intValue()] = true;
                            continue;
                        }
                        iter.remove();
                    }
                    int i = removeFromUnsel.length - 1;
                    while (i >= 0) {
                        if (removeFromUnsel[i]) {
                            unsel.remove(i);
                        }
                        ++i;
                    }
                    this.streamlineIndicies(sel);
                    this.streamlineIndicies(unsel);
                    this.selectedList.refresh(false);
                    this.unselectedList.refresh(false);
                }
            }
        }
    }

    public boolean isMultipleElements() {
        return this.multipleElements;
    }

    public void setFont(Font font) {
        for (Control control : this.fontColorControls) {
            control.setFont(font);
        }
        FormData formData = (FormData)this.moveButtonComp.getParent().getLayoutData();
        formData.height = (int)((double)this.moveButtonComp.computeSize((int)-1, (int)-1, (boolean)true).y * 1.5);
        this.mainComp.layout();
    }

    public void setColor(Color color) {
        for (Control control : this.fontColorControls) {
            control.setForeground(color);
        }
    }

    public void setReadOnly(boolean readOnly) {
        if (this.readOnly == readOnly) {
            return;
        }
        this.readOnly = readOnly;
        if (this.moveButtonComp != null) {
            this.deselectButton.setEnabled(!readOnly);
            this.selectButton.setEnabled(!readOnly);
            this.moveUpButton.setEnabled(!readOnly);
            this.moveDownButton.setEnabled(!readOnly);
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    protected class DualListComparator
    extends ViewerComparator {
        public final ViewerComparator realComparator;

        public DualListComparator(ViewerComparator realComparator) {
            Assert.isNotNull((Object)realComparator, (String)"Comparator");
            this.realComparator = realComparator;
        }

        public int category(Object element) {
            return this.realComparator.category(((DualListWrapper)element).wrappedObject);
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            Object o1 = ((DualListWrapper)e1).wrappedObject;
            Object o2 = ((DualListWrapper)e2).wrappedObject;
            return this.realComparator.compare(viewer, o1, o2);
        }

        public boolean isSorterProperty(Object element, String property) {
            return this.realComparator.isSorterProperty(((DualListWrapper)element).wrappedObject, property);
        }

        public void sort(Viewer viewer, Object[] elements) {
            Object[] unwrapped = null;
            if (elements != null) {
                unwrapped = new Object[elements.length];
                int i = 0;
                while (i < elements.length) {
                    unwrapped[i] = ((DualListWrapper)elements[i]).wrappedObject;
                    ++i;
                }
            }
            this.realComparator.sort(viewer, unwrapped);
        }
    }

    protected class DualListLabelProvider
    implements ILabelProvider {
        public final ILabelProvider realLabelProvider;

        public DualListLabelProvider(ILabelProvider realLabelProvider) {
            Assert.isNotNull((Object)realLabelProvider, (String)"Label Provider");
            this.realLabelProvider = realLabelProvider;
        }

        public void addListener(ILabelProviderListener listener) {
            this.realLabelProvider.addListener(listener);
        }

        public void dispose() {
            this.realLabelProvider.dispose();
        }

        public boolean isLabelProperty(Object element, String property) {
            DualListWrapper wrapper = (DualListWrapper)element;
            return this.realLabelProvider.isLabelProperty(wrapper.wrappedObject, property);
        }

        public void removeListener(ILabelProviderListener listener) {
            this.realLabelProvider.removeListener(listener);
        }

        public Image getImage(Object element) {
            DualListWrapper wrapper = (DualListWrapper)element;
            return this.realLabelProvider.getImage(wrapper.wrappedObject);
        }

        public String getText(Object element) {
            DualListWrapper wrapper = (DualListWrapper)element;
            return this.realLabelProvider.getText(wrapper.wrappedObject);
        }
    }
}

