/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.common.util.editing.duallistselector;

import com.savvytest.eclipse.common.Savvytest;
import com.savvytest.eclipse.common.components.selection.SavvytestFileSelection;
import com.savvytest.eclipse.common.savvytestnature.SavvytestTypeEnum;
import com.savvytest.eclipse.common.util.GridDataCreator;
import com.savvytest.eclipse.common.util.editing.duallistselector.DualListListener;
import com.savvytest.eclipse.common.util.editing.duallistselector.DualListWrapper;
import com.savvytest.eclipse.common.util.editing.duallistselector.ElementInformation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class TreeFileSelector {
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.common.util.editing.duallistselector.TreeListSelector.";
    protected final Comparator<DualListWrapper<IFile>> wrappedObjectComp = new Comparator<DualListWrapper<IFile>>(){

        @Override
        public int compare(DualListWrapper<IFile> o1, DualListWrapper<IFile> o2) {
            int hash2;
            if (o1 == null || o1.wrappedObject == null) {
                if (o2 == null || o2.wrappedObject == null) {
                    return 0;
                }
                return 1;
            }
            if (o2 == null || o2.wrappedObject == null) {
                return -1;
            }
            int hash1 = ((IFile)o1.wrappedObject).hashCode();
            if (hash1 < (hash2 = ((IFile)o2.wrappedObject).hashCode())) {
                return -1;
            }
            if (hash2 < hash1) {
                return 1;
            }
            return 0;
        }
    };
    protected final Comparator<DualListWrapper<IFile>> wrappedIndexComp = new Comparator<DualListWrapper<IFile>>(){

        @Override
        public int compare(DualListWrapper<IFile> o1, DualListWrapper<IFile> o2) {
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            return o1.getIndex() - o2.getIndex();
        }
    };
    private CopyOnWriteArraySet<DualListListener<IFile>> listeners;
    private Composite mainComp;
    private Composite moveButtonComp;
    private SavvytestFileSelection unselectedList;
    private ListViewer selectedList;
    private boolean preventRecursion;
    private boolean readOnly;
    private boolean multiple = true;
    private final ArrayList<Control> fontColorControls = new ArrayList();
    private Button deselectButton;
    private Button moveUpButton;
    private Button selectButton;
    private Button moveDownButton;

    private static String getClassString(String key) {
        return Savvytest.getString(TRANSLATION_PREFIX + key, new Object[0]);
    }

    public TreeFileSelector(Composite parent, int style) {
        this.createControl(parent, style);
    }

    public void dispose() {
        if (this.mainComp != null && !this.mainComp.isDisposed()) {
            this.mainComp.dispose();
        }
    }

    private void createControl(Composite parent, int style) {
        this.mainComp = new Composite(parent, style);
        this.mainComp.setLayout((Layout)new FormLayout());
        Composite innerMainComp = new Composite(this.mainComp, 0);
        GridLayout imcLayout = new GridLayout(2, true);
        imcLayout.marginWidth = 0;
        imcLayout.marginHeight = 0;
        innerMainComp.setLayout((Layout)imcLayout);
        Composite innerMainCompLeft = new Composite(innerMainComp, 0);
        innerMainCompLeft.setLayoutData((Object)GridDataCreator.fill());
        innerMainCompLeft.setLayout((Layout)new GridLayout(2, false));
        Composite innerMainCompRight = new Composite(innerMainComp, 0);
        innerMainCompRight.setLayoutData((Object)GridDataCreator.fill());
        innerMainCompRight.setLayout((Layout)new GridLayout(2, false));
        Composite unselectedComp = new Composite(innerMainCompLeft, 0);
        unselectedComp.setLayoutData((Object)GridDataCreator.fill());
        unselectedComp.setLayout((Layout)new GridLayout());
        Label unselectedLabel = new Label(unselectedComp, 0);
        unselectedLabel.setLayoutData((Object)GridDataCreator.center());
        unselectedLabel.setText(TreeFileSelector.getClassString("deselectlabel"));
        this.fontColorControls.add((Control)unselectedLabel);
        this.unselectedList = new SavvytestFileSelection();
        this.unselectedList.createControl(unselectedComp, 4098);
        this.unselectedList.getControl().setLayoutData((Object)GridDataCreator.fill());
        this.unselectedList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (TreeFileSelector.this.preventRecursion) {
                    return;
                }
                try {
                    TreeFileSelector.this.preventRecursion = true;
                    TreeFileSelector.this.selectedList.setSelection((ISelection)StructuredSelection.EMPTY);
                    if (TreeFileSelector.this.listeners != null) {
                        IFile[] files = TreeFileSelector.this.unselectedList.getSelectedFiles();
                        ArrayList elements = new ArrayList(files.length);
                        IFile[] iFileArray = files;
                        int n = files.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IFile file = iFileArray[n2];
                            elements.add(new ElementInformation<IFile>(-1, -1, file));
                            ++n2;
                        }
                        Collections.sort(elements, ElementInformation.newPos);
                        for (DualListListener listener : TreeFileSelector.this.listeners) {
                            listener.selectionEvent(2, elements);
                        }
                    }
                }
                finally {
                    TreeFileSelector.this.preventRecursion = false;
                }
            }
        });
        this.unselectedList.getTreeViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!TreeFileSelector.this.isReadOnly() && !event.getSelection().isEmpty()) {
                    TreeFileSelector.this.addElements(((IStructuredSelection)event.getSelection()).toList());
                }
            }
        });
        this.unselectedList.getTreeViewer().getTree().addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                TreeFileSelector.this.preventRecursion = true;
                if (e.detail == 64 && e.keyCode == 0x1000004 || e.detail == 4) {
                    IFile[] files = TreeFileSelector.this.unselectedList.getSelectedFiles();
                    if (!TreeFileSelector.this.isReadOnly() && files.length != 0) {
                        TreeFileSelector.this.addElements(Arrays.asList(files));
                        e.detail = 0;
                        e.doit = true;
                    }
                }
                TreeFileSelector.this.preventRecursion = false;
            }
        });
        this.fontColorControls.add(this.unselectedList.getControl());
        Composite selectButtonComp = new Composite(innerMainCompLeft, 0);
        selectButtonComp.setLayoutData((Object)GridDataCreator.center());
        RowLayout sbcLayout = new RowLayout(512);
        sbcLayout.pack = false;
        selectButtonComp.setLayout((Layout)sbcLayout);
        Composite selectedComp = new Composite(innerMainCompRight, 0);
        selectedComp.setLayoutData((Object)GridDataCreator.fill());
        selectedComp.setLayout((Layout)new GridLayout());
        Label selectedLabel = new Label(selectedComp, 0);
        selectedLabel.setLayoutData((Object)GridDataCreator.center());
        selectedLabel.setText(TreeFileSelector.getClassString("selectlabel"));
        this.fontColorControls.add((Control)selectedLabel);
        this.selectedList = new ListViewer(selectedComp);
        this.selectedList.getControl().setLayoutData((Object)GridDataCreator.fill());
        this.selectedList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.selectedList.setLabelProvider((IBaseLabelProvider)new DualListLabelProvider((ILabelProvider)new WorkbenchLabelProvider()));
        this.selectedList.setInput(new ArrayList(0));
        this.selectedList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (TreeFileSelector.this.preventRecursion) {
                    return;
                }
                TreeFileSelector.this.preventRecursion = true;
                TreeFileSelector.this.unselectedList.setSelection((ISelection)StructuredSelection.EMPTY);
                if (TreeFileSelector.this.listeners != null) {
                    IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                    ArrayList elements = new ArrayList(sel.size());
                    for (DualListWrapper wrapped : sel) {
                        elements.add(new ElementInformation<IFile>(wrapped.getIndex(), wrapped.getIndex(), (IFile)wrapped.wrappedObject));
                    }
                    Collections.sort(elements, ElementInformation.newPos);
                    for (DualListListener listener : TreeFileSelector.this.listeners) {
                        listener.selectionEvent(1, elements);
                    }
                }
                TreeFileSelector.this.preventRecursion = false;
            }
        });
        this.selectedList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!TreeFileSelector.this.isReadOnly() && !event.getSelection().isEmpty()) {
                    TreeFileSelector.this.removeElements(((IStructuredSelection)event.getSelection()).toList());
                }
            }
        });
        this.selectedList.getList().addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                TreeFileSelector.this.preventRecursion = true;
                if (e.detail == 32 && e.keyCode == 0x1000003 || e.detail == 4) {
                    IStructuredSelection sel = (IStructuredSelection)TreeFileSelector.this.selectedList.getSelection();
                    if (!TreeFileSelector.this.isReadOnly() && !sel.isEmpty()) {
                        TreeFileSelector.this.removeElements(sel.toList());
                        e.detail = 0;
                        e.doit = true;
                    }
                }
                TreeFileSelector.this.preventRecursion = false;
            }
        });
        this.fontColorControls.add(this.selectedList.getControl());
        this.moveButtonComp = new Composite(innerMainCompRight, 0);
        this.moveButtonComp.setLayoutData((Object)GridDataCreator.center());
        RowLayout mbcLayout = new RowLayout(512);
        mbcLayout.pack = false;
        this.moveButtonComp.setLayout((Layout)mbcLayout);
        this.deselectButton = new Button(this.moveButtonComp, 8);
        this.deselectButton.setEnabled(!this.isReadOnly());
        this.deselectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)TreeFileSelector.this.selectedList.getSelection();
                if (!sel.isEmpty()) {
                    TreeFileSelector.this.removeElements(sel.toList());
                }
            }
        });
        this.fontColorControls.add((Control)this.deselectButton);
        this.moveUpButton = new Button(this.moveButtonComp, 8);
        this.moveUpButton.setEnabled(!this.isReadOnly());
        this.moveUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)TreeFileSelector.this.selectedList.getSelection();
                if (!sel.isEmpty()) {
                    TreeFileSelector.this.movePosition(TreeFileSelector.this.selectedList, sel.toList(), 128);
                }
            }
        });
        this.fontColorControls.add((Control)this.moveUpButton);
        this.selectButton = new Button(selectButtonComp, 8);
        this.selectButton.setEnabled(!this.isReadOnly());
        this.selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IFile[] files = TreeFileSelector.this.unselectedList.getSelectedFiles();
                if (files.length != 0) {
                    TreeFileSelector.this.addElements(Arrays.asList(files));
                }
            }
        });
        this.fontColorControls.add((Control)this.selectButton);
        this.moveDownButton = new Button(this.moveButtonComp, 8);
        this.moveDownButton.setEnabled(!this.isReadOnly());
        this.moveDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)TreeFileSelector.this.selectedList.getSelection();
                if (!sel.isEmpty()) {
                    TreeFileSelector.this.movePosition(TreeFileSelector.this.selectedList, sel.toList(), 1024);
                }
            }
        });
        this.fontColorControls.add((Control)this.moveDownButton);
        this.selectButton.setText(TreeFileSelector.getClassString("select"));
        this.deselectButton.setText(TreeFileSelector.getClassString("deselect"));
        this.moveDownButton.setText(TreeFileSelector.getClassString("down"));
        this.moveUpButton.setText(TreeFileSelector.getClassString("up"));
        FormData fd = new FormData(-1, selectButtonComp.computeSize((int)-1, (int)-1).y);
        fd.top = new FormAttachment(0, 0);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        innerMainComp.setLayoutData((Object)fd);
    }

    public Control getControl() {
        return this.mainComp;
    }

    public List<IFile> getSelected() {
        return this.unwrapList(this.getList(this.selectedList));
    }

    public void setSelected(Collection<IFile> selected) {
        this.deselectAll();
        this.moveToSelected(selected);
    }

    public boolean isNothingSelected() {
        return this.getList(this.selectedList).isEmpty();
    }

    private List<DualListWrapper<IFile>> getList(ListViewer viewer) {
        return (List)viewer.getInput();
    }

    private List<IFile> unwrapList(Collection<DualListWrapper<IFile>> wrappedList) {
        ArrayList<IFile> unwrappedList = new ArrayList<IFile>(wrappedList.size());
        for (DualListWrapper<IFile> wrapper : wrappedList) {
            unwrappedList.add((IFile)wrapper.wrappedObject);
        }
        return unwrappedList;
    }

    private List<DualListWrapper<IFile>> wrapList(Collection<IFile> unwrappedList) {
        ArrayList<DualListWrapper<IFile>> wrappedList = new ArrayList<DualListWrapper<IFile>>(unwrappedList.size());
        Iterator<IFile> iter = unwrappedList.iterator();
        int index = 0;
        while (iter.hasNext()) {
            wrappedList.add(new DualListWrapper<IFile>(iter.next(), index++));
        }
        return wrappedList;
    }

    private void streamlineIndicies(List<DualListWrapper<IFile>> list) {
        int index = 0;
        for (DualListWrapper<IFile> wrapper : list) {
            wrapper.setIndex(index++);
        }
    }

    public void deselectAll() {
        if (this.isReadOnly()) {
            return;
        }
        List<DualListWrapper<IFile>> sel = this.getList(this.selectedList);
        ArrayList elements = new ArrayList(sel.size());
        for (DualListWrapper<IFile> dualListWrapper : sel) {
            elements.add(new ElementInformation<IFile>(dualListWrapper.getIndex(), -1, (IFile)dualListWrapper.wrappedObject));
        }
        sel.clear();
        this.selectedList.refresh(false);
        if (this.listeners != null) {
            for (DualListListener dualListListener : this.listeners) {
                dualListListener.movementEvent(2, elements);
            }
        }
    }

    public void moveToSelected(Collection<IFile> elements) {
        this.addElements(elements);
    }

    public void moveToUnselected(Collection<IFile> elements) {
        this.removeElements(this.findWrapped(this.getList(this.selectedList), elements));
    }

    private List<DualListWrapper<IFile>> findWrapped(Collection<DualListWrapper<IFile>> searchIn, Collection<IFile> elements) {
        ArrayList<DualListWrapper<IFile>> list = new ArrayList<DualListWrapper<IFile>>(elements.size());
        if (searchIn != null && !searchIn.isEmpty()) {
            ArrayList<DualListWrapper<IFile>> copy = new ArrayList<DualListWrapper<IFile>>(searchIn);
            Collections.sort(copy, this.wrappedObjectComp);
            for (IFile element : elements) {
                int index = Collections.binarySearch(copy, new DualListWrapper<IFile>(element), this.wrappedObjectComp);
                if (index < 0) continue;
                list.add(copy.get(index));
            }
        }
        return list;
    }

    private Set<DualListWrapper<IFile>> findUniqueWrapped(Collection<DualListWrapper<IFile>> searchIn, Collection<IFile> elements) {
        return new LinkedHashSet<DualListWrapper<IFile>>(this.findWrapped(searchIn, elements));
    }

    private Map<IFile, DualListWrapper<IFile>> findUniqueWrappedMap(Collection<DualListWrapper<IFile>> searchIn, Collection<IFile> elements) {
        Set<DualListWrapper<IFile>> set = this.findUniqueWrapped(searchIn, elements);
        LinkedHashMap<IFile, DualListWrapper<IFile>> map = new LinkedHashMap<IFile, DualListWrapper<IFile>>();
        for (DualListWrapper<IFile> wrapper : set) {
            map.put((IFile)wrapper.wrappedObject, wrapper);
        }
        return map;
    }

    private void addElements(Collection<IFile> elements) {
        Map<IFile, DualListWrapper<IFile>> duplicateMap;
        List<DualListWrapper<IFile>> to = this.getList(this.selectedList);
        ArrayList listenerList = new ArrayList(elements.size());
        ArrayList<DualListWrapper<IFile>> newSelList = new ArrayList<DualListWrapper<IFile>>(elements.size());
        Set<IFile> duplicateElements = null;
        if (!this.multiple && (duplicateElements = (duplicateMap = this.findUniqueWrappedMap(to, elements)).keySet()).size() == elements.size()) {
            StructuredSelection newSel = new StructuredSelection(new ArrayList<DualListWrapper<IFile>>(duplicateMap.values()));
            this.unselectedList.setSelection((ISelection)StructuredSelection.EMPTY);
            this.selectedList.setSelection((ISelection)newSel, true);
            this.selectedList.getList().setFocus();
            return;
        }
        for (IFile element : elements) {
            if (!element.exists() || duplicateElements != null && duplicateElements.contains(element)) continue;
            DualListWrapper<IFile> wrapper = new DualListWrapper<IFile>(element, to.size());
            listenerList.add(new ElementInformation<IFile>(-1, to.size(), element));
            to.add(wrapper);
            newSelList.add(wrapper);
        }
        StructuredSelection newSel = new StructuredSelection(newSelList);
        this.unselectedList.setSelection((ISelection)StructuredSelection.EMPTY);
        this.selectedList.refresh(false);
        this.selectedList.setSelection((ISelection)newSel, true);
        this.selectedList.getList().setFocus();
        if (this.listeners != null && !listenerList.isEmpty()) {
            for (DualListListener<IFile> listener : this.listeners) {
                listener.movementEvent(1, listenerList);
            }
        }
    }

    private void removeElements(Collection<DualListWrapper<IFile>> elements) {
        List<DualListWrapper<IFile>> list = this.getList(this.selectedList);
        list.removeAll(elements);
        this.streamlineIndicies(list);
        this.unselectedList.setSelection((ISelection)StructuredSelection.EMPTY);
        this.selectedList.setSelection((ISelection)StructuredSelection.EMPTY);
        this.selectedList.refresh(false);
        this.unselectedList.getTreeViewer().getTree().setFocus();
        ArrayList listenerList = new ArrayList(elements.size());
        for (DualListWrapper<IFile> dualListWrapper : elements) {
            listenerList.add(new ElementInformation<IFile>(dualListWrapper.getIndex(), -1, (IFile)dualListWrapper.wrappedObject));
        }
        if (this.listeners != null && !listenerList.isEmpty()) {
            for (DualListListener dualListListener : this.listeners) {
                dualListListener.movementEvent(2, listenerList);
            }
        }
    }

    public void addDualListListener(DualListListener<IFile> listener) {
        if (listener == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new CopyOnWriteArraySet();
        }
        this.listeners.add(listener);
    }

    public void removeDualListListener(DualListListener<IFile> listener) {
        if (listener == null || this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            this.listeners = null;
        }
    }

    public void moveUp(Collection<IFile> elements) {
        if (elements == null || elements.isEmpty()) {
            return;
        }
        Set<DualListWrapper<IFile>> wrapped = this.findUniqueWrapped(this.getList(this.selectedList), elements);
        if (!wrapped.isEmpty()) {
            this.movePosition(this.selectedList, wrapped, 128);
        }
    }

    public void moveDown(Collection<IFile> elements) {
        if (elements == null || elements.isEmpty()) {
            return;
        }
        Set<DualListWrapper<IFile>> wrapped = this.findUniqueWrapped(this.getList(this.selectedList), elements);
        if (!wrapped.isEmpty()) {
            this.movePosition(this.selectedList, wrapped, 1024);
        }
    }

    private void movePosition(ListViewer viewer, Collection<DualListWrapper<IFile>> elements, int direction) {
        if (viewer == null || elements == null || direction != 128 && direction != 1024 || this.isReadOnly()) {
            return;
        }
        ArrayList<DualListWrapper<IFile>> copy = new ArrayList<DualListWrapper<IFile>>(elements);
        Collections.sort(copy, direction == 1024 ? Collections.reverseOrder(this.wrappedIndexComp) : this.wrappedIndexComp);
        int indexOffset = direction == 128 ? -1 : 1;
        ArrayList listenerList = new ArrayList(elements.size());
        List<DualListWrapper<IFile>> list = this.getList(viewer);
        for (DualListWrapper<IFile> dualListWrapper : copy) {
            int index = dualListWrapper.getIndex();
            if ((direction != 128 || index <= 0) && (direction != 1024 || index >= list.size() - 1)) continue;
            int newIndex = index + indexOffset;
            DualListWrapper<IFile> swapNewPosition = list.get(newIndex);
            swapNewPosition.setIndex(index);
            DualListWrapper<IFile> swapOldPosition = list.get(index);
            swapOldPosition.setIndex(newIndex);
            list.set(newIndex, swapOldPosition);
            list.set(index, swapNewPosition);
            listenerList.add(new ElementInformation<IFile>(index, newIndex, (IFile)dualListWrapper.wrappedObject));
        }
        viewer.refresh(false);
        if (this.listeners != null && !listenerList.isEmpty()) {
            Collections.sort(listenerList, direction == 1024 ? Collections.reverseOrder(ElementInformation.oldPos) : ElementInformation.oldPos);
            for (DualListListener dualListListener : this.listeners) {
                dualListListener.positionEvent(1, listenerList);
            }
        }
    }

    public void undoMovement(int side, List<ElementInformation<IFile>> elements) {
        List<DualListWrapper<IFile>> selected = this.getList(this.selectedList);
        if (side == 1) {
            ArrayList<DualListWrapper<IFile>> wrapped = new ArrayList<DualListWrapper<IFile>>(elements.size());
            for (ElementInformation<IFile> element : elements) {
                wrapped.add(selected.get(element.newPosition));
            }
            this.removeElements(wrapped);
        } else {
            ArrayList<DualListWrapper<IFile>> newSelList = new ArrayList<DualListWrapper<IFile>>(elements.size());
            ArrayList listenerList = new ArrayList(elements.size());
            for (ElementInformation<IFile> element : elements) {
                DualListWrapper<IFile> wrapper = new DualListWrapper<IFile>((IFile)element.element, element.oldPosition);
                selected.add(element.oldPosition, wrapper);
                newSelList.add(wrapper);
                listenerList.add(new ElementInformation<IFile>(element.newPosition, element.oldPosition, (IFile)element.element));
            }
            this.streamlineIndicies(selected);
            StructuredSelection newSel = new StructuredSelection(newSelList);
            this.unselectedList.setSelection((ISelection)StructuredSelection.EMPTY);
            this.selectedList.refresh(false);
            this.selectedList.setSelection((ISelection)newSel, true);
            this.selectedList.getList().setFocus();
            if (this.listeners != null && !listenerList.isEmpty()) {
                for (DualListListener<IFile> listener : this.listeners) {
                    listener.movementEvent(1, listenerList);
                }
            }
        }
    }

    public void undoPosition(int side, List<ElementInformation<IFile>> elements) {
        if (side == 1 && !elements.isEmpty()) {
            int moveDirection = elements.get((int)0).newPosition > elements.get((int)0).oldPosition ? 128 : 1024;
            List<DualListWrapper<IFile>> selected = this.getList(this.selectedList);
            ArrayList<DualListWrapper<IFile>> move = new ArrayList<DualListWrapper<IFile>>(elements.size());
            for (ElementInformation<IFile> element : elements) {
                move.add(selected.get(element.newPosition));
            }
            this.movePosition(this.selectedList, move, moveDirection);
        }
    }

    public void refresh() {
        this.unselectedList.refresh();
    }

    public void setFont(Font font) {
        for (Control control : this.fontColorControls) {
            control.setFont(font);
        }
        FormData formData = (FormData)this.moveButtonComp.getParent().getParent().getLayoutData();
        formData.height = (int)((double)this.moveButtonComp.computeSize((int)-1, (int)-1, (boolean)true).y * 2.5);
        this.mainComp.layout();
    }

    public void setColor(Color color) {
        for (Control control : this.fontColorControls) {
            control.setForeground(color);
        }
    }

    public void setReadOnly(boolean readOnly) {
        if (this.readOnly == readOnly) {
            return;
        }
        this.readOnly = readOnly;
        if (this.moveButtonComp != null) {
            this.deselectButton.setEnabled(!readOnly);
            this.selectButton.setEnabled(!readOnly);
            this.moveUpButton.setEnabled(!readOnly);
            this.moveDownButton.setEnabled(!readOnly);
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
        if (!multiple) {
            List<IFile> selectedFiles = this.getSelected();
            this.setSelected(selectedFiles);
        }
    }

    public void setFileTypes(SavvytestTypeEnum ... fileTypes) {
        this.unselectedList.setTypes(fileTypes);
    }

    public SavvytestTypeEnum[] getFileTypes() {
        return this.unselectedList.getTypes();
    }

    public void setProjectRestriction(IProject project) {
        this.unselectedList.setProjectRestriction(project);
    }

    public IProject getProjectRestriction() {
        return this.unselectedList.getProjectRestriction();
    }

    protected class DualListComparator
    extends ViewerComparator {
        public final ViewerComparator realComparator;

        public DualListComparator(ViewerComparator realComparator) {
            Assert.isNotNull((Object)realComparator, (String)"Comparator");
            this.realComparator = realComparator;
        }

        public int category(Object element) {
            return this.realComparator.category(((DualListWrapper)element).wrappedObject);
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            IFile o1 = (IFile)((DualListWrapper)e1).wrappedObject;
            IFile o2 = (IFile)((DualListWrapper)e2).wrappedObject;
            return this.realComparator.compare(viewer, (Object)o1, (Object)o2);
        }

        public boolean isSorterProperty(Object element, String property) {
            return this.realComparator.isSorterProperty(((DualListWrapper)element).wrappedObject, property);
        }

        public void sort(Viewer viewer, Object[] elements) {
            Object[] unwrapped = null;
            if (elements != null) {
                unwrapped = new Object[elements.length];
                int i = 0;
                while (i < elements.length) {
                    unwrapped[i] = ((DualListWrapper)elements[i]).wrappedObject;
                    ++i;
                }
            }
            this.realComparator.sort(viewer, unwrapped);
        }
    }

    protected class DualListLabelProvider
    implements ILabelProvider {
        public final ILabelProvider realLabelProvider;

        public DualListLabelProvider(ILabelProvider realLabelProvider) {
            Assert.isNotNull((Object)realLabelProvider, (String)"Label Provider");
            this.realLabelProvider = realLabelProvider;
        }

        public void addListener(ILabelProviderListener listener) {
            this.realLabelProvider.addListener(listener);
        }

        public void dispose() {
            this.realLabelProvider.dispose();
        }

        public boolean isLabelProperty(Object element, String property) {
            DualListWrapper wrapper = (DualListWrapper)element;
            return this.realLabelProvider.isLabelProperty(wrapper.wrappedObject, property);
        }

        public void removeListener(ILabelProviderListener listener) {
            this.realLabelProvider.removeListener(listener);
        }

        public Image getImage(Object element) {
            DualListWrapper wrapper = (DualListWrapper)element;
            return this.realLabelProvider.getImage(wrapper.wrappedObject);
        }

        public String getText(Object element) {
            DualListWrapper wrapper = (DualListWrapper)element;
            return this.realLabelProvider.getText(wrapper.wrappedObject);
        }
    }
}

