/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.common.wizards;

import com.savvytest.eclipse.common.Activator;
import com.savvytest.eclipse.common.components.selection.SavvytestFileSelection;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.common.util.WizardPageValidator;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SavvytestFileSelectionPage
extends WizardPage
implements ISelectionProvider {
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.common.wizards.SavvytestFileSelectionPage.";
    private final SavvytestFileSelection fileSelection;
    private final int selectStyle;
    private final Color color;
    private final Font font;

    private static String getClassString(String key, Object ... substitutes) {
        String translation = Activator.INSTANCE.getString(TRANSLATION_PREFIX + key);
        if (substitutes.length > 0) {
            translation = MessageFormat.format(translation, substitutes);
        }
        return translation;
    }

    public SavvytestFileSelectionPage(String pageName, int selectStyle) {
        super(pageName);
        this.selectStyle = selectStyle;
        this.fileSelection = new SavvytestFileSelection();
        this.color = SavvytestSettings.INSTANCE.getColor("com.savvytest.eclipse.common.colorForeground");
        this.font = SavvytestSettings.INSTANCE.getFont("com.savvytest.eclipse.common.fontNormal");
    }

    public void createControl(Composite parent) {
        Control control = this.getFileSelectionComponent().createControl(parent, this.selectStyle);
        this.setControl(control);
        Font font = SavvytestSettings.INSTANCE.getFont("com.savvytest.eclipse.common.fontNormal");
        Color color = SavvytestSettings.INSTANCE.getColor("com.savvytest.eclipse.common.colorForeground");
        this.getFileSelectionComponent().setFont(font);
        this.getFileSelectionComponent().setColor(color);
    }

    protected String checkFileOverwrite(IFile file) {
        if (this.selectStyle == 8192 && file != null && file.exists()) {
            return SavvytestFileSelectionPage.getClassString("warnings.overwrite", file.getFullPath());
        }
        return null;
    }

    protected String checkFileExistence(IFile file) {
        if (file == null) {
            return SavvytestFileSelectionPage.getClassString("errors.null", new Object[0]);
        }
        if (this.selectStyle == 4096 && !file.exists()) {
            return SavvytestFileSelectionPage.getClassString("errors.exists", file.getFullPath());
        }
        return null;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.getFileSelectionComponent().addSelectionChangedListener(listener);
    }

    public ISelection getSelection() {
        return this.getFileSelectionComponent().getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.getFileSelectionComponent().removeSelectionChangedListener(listener);
    }

    public void setSelection(ISelection selection) {
        Object obj;
        IResource resource = null;
        if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof IResource) {
            resource = (IResource)obj;
        }
        if (this.getFileSelectionComponent().getControl() == null) {
            if (resource != null) {
                this.getFileSelectionComponent().setInitialSelection(resource);
            } else {
                this.getFileSelectionComponent().setInitialSelection(null);
            }
        } else if (resource != null) {
            this.getFileSelectionComponent().setSelection((ISelection)new StructuredSelection((Object)resource));
        } else {
            this.getFileSelectionComponent().setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    public SavvytestFileSelection getFileSelectionComponent() {
        return this.fileSelection;
    }

    protected final Color getSavvytestColor() {
        return this.color;
    }

    protected final Font getSavvytestFont() {
        return this.font;
    }

    protected class FileSelectionValidator
    extends WizardPageValidator {
        public FileSelectionValidator() {
            super(SavvytestFileSelectionPage.this);
        }

        @Override
        protected String internalValidate() {
            return SavvytestFileSelectionPage.this.checkFileExistence(SavvytestFileSelectionPage.this.getFileSelectionComponent().getSelectedFile());
        }

        @Override
        public void validate() {
            SavvytestFileSelectionPage.this.setMessage(SavvytestFileSelectionPage.this.checkFileOverwrite(SavvytestFileSelectionPage.this.getFileSelectionComponent().getSelectedFile()), 2);
            super.validate();
        }
    }
}

