/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.common.wizards;

import com.savvytest.eclipse.common.Activator;
import com.savvytest.eclipse.common.components.selection.SavvytestFileSelection;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.common.savvytestnature.SavvytestTypeEnum;
import com.savvytest.eclipse.common.util.GridDataCreator;
import com.savvytest.eclipse.common.util.WizardPageValidator;
import com.savvytest.eclipse.common.util.editing.EditingUtility;
import com.savvytest.eclipse.core.model.xml.listructure.Listructure;
import com.savvytest.eclipse.core.model.xml.listructure.ListructureFactory;
import com.savvytest.eclipse.core.model.xml.listructure.StringType;
import com.savvytest.eclipse.core.model.xml.listructure.StructType;
import com.savvytest.eclipse.core.model.xml.properties.PropertiesFactory;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class TargetPlaceholderPage
extends WizardPage {
    private static final String STRUCT_NAME = "Replacement";
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.common.wizards.TargetPlaceholderPage.";
    private final List<String> createElements = new ArrayList<String>();
    private boolean use;
    private boolean create;
    private SavvytestFileSelection fileSelection;
    private Button useButton;
    private Button createButton;
    private TableViewer createViewer;
    private Button addButton;
    private Button removeButton;
    private WizardPageValidator validator;

    protected static String getClassString(String key, Object ... substitutes) {
        String translation = Activator.INSTANCE.getString(TRANSLATION_PREFIX + key);
        if (substitutes.length > 0) {
            translation = MessageFormat.format(translation, substitutes);
        }
        return translation;
    }

    public TargetPlaceholderPage(String pageName) {
        this(pageName, null, null);
    }

    public TargetPlaceholderPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        Font font = SavvytestSettings.INSTANCE.getFont("com.savvytest.eclipse.common.fontNormal");
        Color color = SavvytestSettings.INSTANCE.getColor("com.savvytest.eclipse.common.colorForeground");
        Composite body = new Composite(parent, 0);
        body.setLayout((Layout)new GridLayout());
        this.setControl((Control)body);
        Group useGroup = new Group(body, 0);
        useGroup.setLayoutData((Object)GridDataCreator.fill());
        useGroup.setLayout((Layout)new GridLayout());
        useGroup.setText(TargetPlaceholderPage.getClassString("use.group", new Object[0]));
        useGroup.setFont(font);
        useGroup.setForeground(color);
        this.useButton = new Button((Composite)useGroup, 32);
        this.useButton.setLayoutData((Object)GridDataCreator.normal());
        this.useButton.setText(TargetPlaceholderPage.getClassString("use.button", new Object[0]));
        this.useButton.setFont(font);
        this.useButton.setForeground(color);
        this.useButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetPlaceholderPage.this.use = TargetPlaceholderPage.this.useButton.getSelection();
                TargetPlaceholderPage.this.handleEnablement();
                TargetPlaceholderPage.this.validator.validate();
            }
        });
        this.getFileSelectionComponent().setTypes(SavvytestTypeEnum.LISTRUCTURE);
        this.getFileSelectionComponent().createControl((Composite)useGroup, 8192);
        this.getFileSelectionComponent().getControl().setLayoutData((Object)GridDataCreator.heightHint(GridDataCreator.fill(), 250));
        this.getFileSelectionComponent().setFont(font);
        this.getFileSelectionComponent().setColor(color);
        this.getFileSelectionComponent().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TargetPlaceholderPage.this.validator.validate();
            }
        });
        Group createGroup = new Group((Composite)useGroup, 0);
        createGroup.setLayoutData((Object)GridDataCreator.fill());
        createGroup.setText(TargetPlaceholderPage.getClassString("create.group", new Object[0]));
        createGroup.setLayout((Layout)new GridLayout(2, false));
        createGroup.setFont(font);
        createGroup.setForeground(color);
        this.createButton = new Button((Composite)createGroup, 32);
        this.createButton.setLayoutData((Object)GridDataCreator.normal());
        this.createButton.setText(TargetPlaceholderPage.getClassString("create.button", new Object[0]));
        this.createButton.setFont(font);
        this.createButton.setForeground(color);
        this.createButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetPlaceholderPage.this.create = TargetPlaceholderPage.this.createButton.getSelection();
                TargetPlaceholderPage.this.handleEnablement();
                TargetPlaceholderPage.this.validator.validate();
            }
        });
        Label createLabel = new Label((Composite)createGroup, 64);
        createLabel.setLayoutData((Object)GridDataCreator.horizontalSpan(GridDataCreator.horizontalFill(), 2));
        createLabel.setText(TargetPlaceholderPage.getClassString("create.label", new Object[0]));
        createLabel.setFont(font);
        createLabel.setForeground(color);
        this.createViewer = new TableViewer((Composite)createGroup, 68098);
        this.createViewer.getControl().setLayoutData((Object)GridDataCreator.heightHint(GridDataCreator.fill(), 150));
        this.createViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.createViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.createViewer.setInput(this.createElements);
        Composite createComposite = new Composite((Composite)createGroup, 0);
        createComposite.setLayoutData((Object)GridDataCreator.center());
        createComposite.setLayout((Layout)new GridLayout());
        this.addButton = new Button(createComposite, 0x1000008);
        this.addButton.setLayoutData((Object)GridDataCreator.horizontalFill());
        this.addButton.setText(TargetPlaceholderPage.getClassString("create.add", new Object[0]));
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog dialog = new InputDialog(TargetPlaceholderPage.this.addButton.getShell(), TargetPlaceholderPage.getClassString("create.addDialogTitel", new Object[0]), TargetPlaceholderPage.getClassString("create.addDialogDescription", new Object[0]), null, new IInputValidator(){
                    private final Pattern VALIDATE_PATTER = Pattern.compile("\\W");

                    public String isValid(String newText) {
                        if (this.VALIDATE_PATTER.matcher(newText).find()) {
                            return TargetPlaceholderPage.getClassString("validation.addDialog", new Object[0]);
                        }
                        return null;
                    }
                });
                if (dialog.open() == 0) {
                    TargetPlaceholderPage.this.createElements.add(dialog.getValue());
                    TargetPlaceholderPage.this.createViewer.refresh();
                    TargetPlaceholderPage.this.validator.validate();
                }
            }
        });
        this.removeButton = new Button(createComposite, 0x1000008);
        this.removeButton.setLayoutData((Object)GridDataCreator.center());
        this.removeButton.setText(TargetPlaceholderPage.getClassString("create.remove", new Object[0]));
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)TargetPlaceholderPage.this.createViewer.getSelection();
                Iterator iter = selection.iterator();
                while (iter.hasNext()) {
                    TargetPlaceholderPage.this.createElements.remove(iter.next());
                }
                TargetPlaceholderPage.this.createViewer.refresh(false);
                TargetPlaceholderPage.this.validator.validate();
            }
        });
        this.useButton.setSelection(this.use);
        this.createButton.setSelection(this.create);
        this.handleEnablement();
        this.validator = new WizardPageValidator(this){

            @Override
            protected String internalValidate() {
                IFile listructureFile = TargetPlaceholderPage.this.getFileSelectionComponent().getSelectedFile();
                if (TargetPlaceholderPage.this.use && listructureFile == null) {
                    return TargetPlaceholderPage.getClassString("validation.selectListructure", new Object[0]);
                }
                if (TargetPlaceholderPage.this.use && !TargetPlaceholderPage.this.create && !listructureFile.exists()) {
                    return TargetPlaceholderPage.getClassString("validation.existsListructure", new Object[0]);
                }
                if (TargetPlaceholderPage.this.use && TargetPlaceholderPage.this.create && TargetPlaceholderPage.this.createElements.isEmpty()) {
                    return TargetPlaceholderPage.getClassString("validation.defineElements", new Object[0]);
                }
                return null;
            }
        };
        this.validator.validate();
        this.validator.setDisplayError(true);
    }

    private void handleEnablement() {
        this.getFileSelectionComponent().getControl().setEnabled(this.use);
        this.createButton.setEnabled(this.use);
        this.createViewer.getControl().setEnabled(this.use && this.create);
        this.addButton.setEnabled(this.use && this.create);
        this.removeButton.setEnabled(this.use && this.create);
    }

    public void createFile() throws IOException {
        IFile file;
        if (this.use && this.create && !this.createElements.isEmpty() && (file = this.getFileSelectionComponent().getSelectedFile()) != null) {
            Listructure listructure = ListructureFactory.eINSTANCE.createListructure();
            listructure.setProperties(PropertiesFactory.eINSTANCE.createProperties());
            listructure.setId(URI.encodeOpaquePart((String)file.getProjectRelativePath().toString(), (boolean)true));
            StructType struct = ListructureFactory.eINSTANCE.createStructType();
            struct.setName(STRUCT_NAME);
            struct.setProperties(PropertiesFactory.eINSTANCE.createProperties());
            listructure.getStruct().add((Object)struct);
            for (String element : this.createElements) {
                StringType string = ListructureFactory.eINSTANCE.createStringType();
                string.setName(element);
                string.setProperties(PropertiesFactory.eINSTANCE.createProperties());
                struct.getString().add((Object)string);
            }
            struct.updateId("");
            EditingUtility.createListructure(file, listructure, null);
        }
    }

    public void refresh() {
        if (this.createViewer != null) {
            this.createViewer.refresh();
            this.fileSelection.refresh();
            this.validator.validate();
        }
    }

    public SavvytestFileSelection getFileSelectionComponent() {
        if (this.fileSelection == null) {
            this.fileSelection = new SavvytestFileSelection();
        }
        return this.fileSelection;
    }

    public List<String> getCreateElements() {
        return this.createElements;
    }

    public boolean isUse() {
        return this.use;
    }

    public void setUse(boolean use) {
        if (this.use != use) {
            this.use = use;
            if (this.useButton != null) {
                this.useButton.setSelection(use);
                this.handleEnablement();
            }
        }
    }

    public boolean isCreate() {
        return this.create;
    }

    public void setCreate(boolean create) {
        if (this.create != create) {
            this.create = create;
            if (this.createButton != null) {
                this.createButton.setSelection(create);
                this.handleEnablement();
            }
        }
    }

    public void setProjectRestriction(IProject project) {
        this.getFileSelectionComponent().setProjectRestriction(project);
    }

    public IProject getProjectRestriction() {
        return this.getFileSelectionComponent().getProjectRestriction();
    }
}

