/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.editor.iface.actions;

import com.savvytest.eclipse.core.model.xml.iface.Argument;
import com.savvytest.eclipse.core.model.xml.iface.DocumentRoot;
import com.savvytest.eclipse.core.model.xml.iface.Interface;
import com.savvytest.eclipse.core.model.xml.iface.InterfaceFactory;
import com.savvytest.eclipse.core.model.xml.iface.ui.InterfaceUi;
import com.savvytest.eclipse.core.model.xml.iface.util.InterfaceUtils;
import com.savvytest.eclipse.core.model.xml.listructure.BaseType;
import com.savvytest.eclipse.core.model.xml.listructure.Listructure;
import com.savvytest.eclipse.core.model.xml.listructure.util.ListructureUtils;
import com.savvytest.eclipse.editor.iface.gui.InterfaceEditorPlugin;
import com.savvytest.eclipse.editor.iface.gui.SavvytestInterfaceEditor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.edit.command.AbstractOverrideableCommand;

public class SetResultCommand
extends AbstractOverrideableCommand {
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.editor.iface.actions.SetResultCommand.";
    private static final String LABEL = SetResultCommand.getClassString("label");
    private static final String DESCRIPTION = SetResultCommand.getClassString("description");
    private final Listructure listructure;
    private Interface iface;
    private InterfaceUi ifaceUi;
    private Listructure liStructureCopy;
    private Argument oldArg;
    private Listructure oldListructure;

    private static String getClassString(String key) {
        return InterfaceEditorPlugin.INSTANCE.getString(TRANSLATION_PREFIX + key);
    }

    public SetResultCommand(SavvytestInterfaceEditor editor, Listructure listructure) {
        super(editor.getEditingDomain(), LABEL, DESCRIPTION);
        this.listructure = listructure;
    }

    protected boolean prepare() {
        Resource resource = (Resource)this.getDomain().getResourceSet().getResources().get(0);
        DocumentRoot doc = (DocumentRoot)resource.getContents().get(0);
        this.iface = doc.getInterface();
        this.ifaceUi = (InterfaceUi)resource.getContents().get(1);
        return this.iface != null && this.ifaceUi != null;
    }

    private Argument createArgument(Listructure li) {
        Argument arg = InterfaceFactory.eINSTANCE.createArgument();
        arg.setListructure(li);
        ArrayList baseTypeExtensions = new ArrayList();
        for (FeatureMap.Entry entry : li.getElements()) {
            BaseType baseType = (BaseType)entry.getValue();
            InterfaceUtils.createBaseTypeExtension((BaseType)baseType, baseTypeExtensions);
        }
        arg.getBaseTypeExtensions().addAll(baseTypeExtensions);
        return arg;
    }

    private Listructure copyListructure(Argument arg) {
        Map baseTypeExtensionMap = InterfaceUtils.createBaseTypeExtensionMap((Collection)arg.getBaseTypeExtensions());
        this.liStructureCopy = (Listructure)EcoreUtil.copy((EObject)arg.getListructure());
        ListructureUtils.clearInitialValue((Listructure)this.liStructureCopy);
        InterfaceUtils.updateListrucure((Listructure)this.liStructureCopy, (Map)baseTypeExtensionMap, (boolean)true, (boolean)true);
        return this.liStructureCopy;
    }

    public void doExecute() {
        this.oldArg = this.iface.getResult();
        Argument arg = null;
        if (this.listructure != null) {
            arg = this.createArgument(this.listructure);
        }
        this.iface.setResult(arg);
        this.oldListructure = this.ifaceUi.getResultUi();
        this.liStructureCopy = null;
        if (this.listructure != null) {
            this.liStructureCopy = this.copyListructure(arg);
        }
        this.ifaceUi.setResultUi(this.liStructureCopy);
    }

    public void doUndo() {
        this.iface.setResult(this.oldArg);
        this.ifaceUi.setResultUi(this.oldListructure);
    }

    public void doRedo() {
        this.doExecute();
    }

    public Collection<?> doGetAffectedObjects() {
        return this.doGetResult();
    }

    public Collection<?> doGetResult() {
        ArrayList<Object> objList = new ArrayList<Object>(2);
        objList.add(this.iface);
        objList.add(this.ifaceUi);
        return objList;
    }
}

