/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.remote.rest;

import com.savvytest.eclipse.common.savvytestnature.SavvytestTypeEnum;
import com.savvytest.eclipse.common.util.editing.EditingUtility;
import com.savvytest.eclipse.core.model.xml.listructure.Listructure;
import com.savvytest.eclipse.core.model.xml.listructure.ListructureFactory;
import com.savvytest.eclipse.core.model.xml.listructure.ListructurePackage;
import com.savvytest.eclipse.core.model.xml.listructure.NumberType;
import com.savvytest.eclipse.core.model.xml.listructure.StringType;
import com.savvytest.eclipse.core.model.xml.properties.PropertiesFactory;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;

public class SavvytestRestProjectNature
extends PlatformObject
implements IProjectNature {
    private IProject project;

    public void configure() throws CoreException {
        IFile htmlResponseFile = this.project.getFolder(SavvytestTypeEnum.LISTRUCTURE.foldername).getFile("htmlResponse." + SavvytestTypeEnum.LISTRUCTURE.fileextension);
        try {
            this.createHtmlResponse(htmlResponseFile);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "com.savvytest.eclipse.common", "Could not create HTML response listructure '" + htmlResponseFile.getName() + ". Error message: " + e.getMessage(), (Throwable)e));
        }
        ResourceAttributes attributes = new ResourceAttributes();
        attributes.setReadOnly(true);
        htmlResponseFile.setResourceAttributes(attributes);
    }

    private void createHtmlResponse(IFile file) throws IOException {
        Listructure listructure = ListructureFactory.eINSTANCE.createListructure();
        listructure.setId(URI.encodeOpaquePart((String)file.getProjectRelativePath().toString(), (boolean)true));
        listructure.setProperties(PropertiesFactory.eINSTANCE.createProperties());
        NumberType responseCode = ListructureFactory.eINSTANCE.createNumberType();
        responseCode.setName("responseCode");
        responseCode.setProperties(PropertiesFactory.eINSTANCE.createProperties());
        listructure.getElements().add((EStructuralFeature)ListructurePackage.eINSTANCE.getListructure_Number(), (Object)responseCode);
        StringType responseMessage = ListructureFactory.eINSTANCE.createStringType();
        responseMessage.setName("responseMessage");
        responseMessage.setProperties(PropertiesFactory.eINSTANCE.createProperties());
        listructure.getElements().add((EStructuralFeature)ListructurePackage.eINSTANCE.getListructure_String(), (Object)responseMessage);
        listructure.updateIdsOfAllElements();
        AdapterFactoryEditingDomain domain = EditingUtility.createDefaultEditingDomain();
        EditingUtility.createListructure((IFile)file, (Listructure)listructure, (EditingDomain)domain);
    }

    public void deconfigure() throws CoreException {
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }
}

