/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.wadl.wizard;

import com.savvytest.eclipse.common.Savvytest;
import com.savvytest.eclipse.common.logging.LogLevel;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.common.util.editing.EditingUtility;
import com.savvytest.eclipse.core.model.xml.iface.Interface;
import com.savvytest.eclipse.core.model.xml.listructure.Listructure;
import com.savvytest.eclipse.core.model.xml.listructure.util.ListructureUtils;
import com.savvytest.eclipse.wadl.WadlPlugin;
import com.savvytest.eclipse.wadl.wizard.ImportInfo;
import com.savvytest.eclipse.wadl.wizard.page.AbstractImportInfoPage;
import com.savvytest.eclipse.wadl.wizard.page.ImportWadlWizardPage;
import com.savvytest.eclipse.wadl.wizard.page.InputParametersPage;
import com.savvytest.eclipse.wadl.wizard.page.InterfacePage;
import com.savvytest.eclipse.wadl.wizard.page.OutputParametersPage;
import com.savvytest.eclipse.wadl.wizard.page.ResponseParametersPage;
import com.savvytest.eclipse.wadl.wizard.page.TargetParametersPage;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardContainer2;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;

public class ImportWadlWizard
extends Wizard
implements IImportWizard {
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.wadl.wizard.ImportWadlWizard.";
    private IStructuredSelection selection;
    private IWorkbench workbench;
    private ImportWadlWizardPage mainPage;
    private Composite pageContainer;

    private static String getClassString(String key, Object ... substitutes) {
        String translation = WadlPlugin.INSTANCE.getString(TRANSLATION_PREFIX + key);
        if (substitutes.length > 0) {
            translation = MessageFormat.format(translation, substitutes);
        }
        return translation;
    }

    private void performFinishInfo(ImportInfo.DefaultInfo info, List<IFile> createdFiles, EditingDomain editingDomain) throws IOException {
        if (info.needed && info.create) {
            SavvytestSettings.INSTANCE.getLogger().log("Creating listructure at: " + info.parametersFile, LogLevel.DEBUG, (Object)this);
            ListructureUtils.clearUsage((Listructure)info.listructure);
            EditingUtility.createListructure((IFile)info.parametersFile, (Listructure)info.listructure, (EditingDomain)editingDomain);
            createdFiles.add(info.parametersFile);
        }
    }

    public boolean performFinish() {
        AdapterFactoryEditingDomain editingDomain = EditingUtility.createDefaultEditingDomain();
        List<ImportInfo> infos = this.mainPage.getInfos();
        ArrayList<IFile> createdFiles = new ArrayList<IFile>(4 * infos.size());
        int i = 0;
        while (i < infos.size()) {
            ImportInfo info = infos.get(i);
            try {
                Interface iface = info.createInterface();
                this.performFinishInfo(info.targetInfo, createdFiles, (EditingDomain)editingDomain);
                this.performFinishInfo(info.inputInfo, createdFiles, (EditingDomain)editingDomain);
                this.performFinishInfo(info.responseInfo, createdFiles, (EditingDomain)editingDomain);
                this.performFinishInfo(info.outputInfo, createdFiles, (EditingDomain)editingDomain);
                SavvytestSettings.INSTANCE.getLogger().log("Creating interface at: " + info.interfaceFile, LogLevel.DEBUG, (Object)this);
                EditingUtility.createInterface((IFile)info.interfaceFile, (Interface)iface, (EditingDomain)editingDomain);
                createdFiles.add(info.interfaceFile);
            }
            catch (IOException e) {
                SavvytestSettings.INSTANCE.getLogger().log((Exception)e, (Object)this);
                MessageBox box = new MessageBox(this.getShell(), 3585);
                box.setText(Savvytest.getGlobalString((String)"error", (Object[])new Object[0]));
                box.setMessage(e.getMessage());
                switch (box.open()) {
                    case 512: {
                        return false;
                    }
                    case 1024: {
                        --i;
                        break;
                    }
                }
            }
            ++i;
        }
        IWorkbenchWindow workbenchWindow = this.workbench.getActiveWorkbenchWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        final IWorkbenchPart activePart = page.getActivePart();
        if (activePart instanceof ISetSelectionTarget) {
            StructuredSelection targetSelection = new StructuredSelection(createdFiles);
            this.getShell().getDisplay().asyncExec(new Runnable((ISelection)targetSelection){
                private final /* synthetic */ ISelection val$targetSelection;
                {
                    this.val$targetSelection = iSelection;
                }

                @Override
                public void run() {
                    ((ISetSelectionTarget)activePart).selectReveal(this.val$targetSelection);
                }
            });
        }
        if (infos.size() == 1) {
            try {
                IFile interfaceFile = infos.get((int)0).interfaceFile;
                page.openEditor((IEditorInput)new FileEditorInput(interfaceFile), this.workbench.getEditorRegistry().getDefaultEditor(interfaceFile.getFullPath().toString()).getId());
            }
            catch (PartInitException e) {
                SavvytestSettings.INSTANCE.getLogger().log((Exception)((Object)e), (Object)this);
                MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)Savvytest.getGlobalString((String)"error", (Object[])new Object[0]), (String)e.getMessage());
                return false;
            }
        }
        return true;
    }

    public void init(IWorkbench theWorkbench, IStructuredSelection theSelection) {
        this.selection = theSelection;
        this.workbench = theWorkbench;
        this.setNeedsProgressMonitor(true);
        this.setForcePreviousAndNextButtons(true);
        this.setWindowTitle(ImportWadlWizard.getClassString("wizardTitle", new Object[0]));
        this.setDefaultPageImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(WadlPlugin.INSTANCE.getImage("ImportWadlStructure")));
    }

    public void addPages() {
        this.mainPage = new ImportWadlWizardPage("mainPage", ImportWadlWizard.getClassString("pages.main.title", new Object[0]), null);
        this.mainPage.setDescription(ImportWadlWizard.getClassString("pages.main.description", new Object[0]));
        this.mainPage.setSelection((ISelection)this.selection);
        this.addPage((IWizardPage)this.mainPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page instanceof ImportWadlWizardPage) {
            IWizardPage[] iWizardPageArray = this.getPages();
            int n = iWizardPageArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWizardPage wizardPage = iWizardPageArray[n2];
                if (wizardPage instanceof AbstractImportInfoPage) {
                    ((AbstractImportInfoPage)wizardPage).setInactive(true);
                }
                ++n2;
            }
            for (ImportInfo info : this.mainPage.getInfos()) {
                this.createPages(info);
            }
            this.pageContainer.layout(false);
            ((IWizardContainer2)this.getContainer()).updateSize();
        }
        IStructuredSelection selection = this.selection;
        if (page instanceof AbstractImportInfoPage) {
            selection = ((AbstractImportInfoPage)page).getSelection();
        }
        IWizardPage nextPage = super.getNextPage(page);
        while (nextPage instanceof AbstractImportInfoPage && ((AbstractImportInfoPage)nextPage).isInactive()) {
            nextPage = super.getNextPage(nextPage);
        }
        if (nextPage instanceof AbstractImportInfoPage) {
            ((AbstractImportInfoPage)nextPage).setSelection((ISelection)selection);
        }
        return nextPage;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        IWizardPage previousPage = super.getPreviousPage(page);
        while (previousPage instanceof AbstractImportInfoPage && ((AbstractImportInfoPage)previousPage).isInactive()) {
            previousPage = super.getPreviousPage(previousPage);
        }
        return previousPage;
    }

    public boolean canFinish() {
        if (this.getContainer().getCurrentPage() instanceof ImportWadlWizardPage) {
            return false;
        }
        return super.canFinish();
    }

    private void createPages(ImportInfo info) {
        this.createInterfacePage(info);
        if (info.targetInfo.needed) {
            this.createTargetPage(info);
        }
        if (info.inputInfo.needed) {
            this.createInputPage(info);
        }
        if (info.responseInfo.needed) {
            this.createResponsePage(info);
        }
        if (info.outputInfo.needed) {
            this.createOutputPage(info);
        }
    }

    private void createInterfacePage(ImportInfo info) {
        InterfacePage ip = new InterfacePage(info, "InterfacePage");
        this.addPage((IWizardPage)ip);
        ip.createControl(this.pageContainer);
        ip.setVisible(false);
        ip.setTitle(ImportWadlWizard.getClassString("pages.interface.title", new Object[0]));
        ip.setDescription(ImportWadlWizard.getClassString("pages.interface.description", info.getMethodDescription()));
    }

    private void createTargetPage(ImportInfo info) {
        TargetParametersPage tpp = new TargetParametersPage(info, "TargetParametersPage");
        this.addPage((IWizardPage)tpp);
        tpp.createControl(this.pageContainer);
        tpp.setVisible(false);
        tpp.setTitle(ImportWadlWizard.getClassString("pages.target.title", new Object[0]));
        tpp.setDescription(ImportWadlWizard.getClassString("pages.target.description", info.getMethodDescription()));
    }

    private void createInputPage(ImportInfo info) {
        InputParametersPage ipp = new InputParametersPage(info, "InputParametersPage");
        this.addPage((IWizardPage)ipp);
        ipp.createControl(this.pageContainer);
        ipp.setVisible(false);
        ipp.setTitle(ImportWadlWizard.getClassString("pages.input.title", new Object[0]));
        ipp.setDescription(ImportWadlWizard.getClassString("pages.input.description", info.getMethodDescription()));
    }

    private void createResponsePage(ImportInfo info) {
        ResponseParametersPage rpp = new ResponseParametersPage(info, "ResponseParametersPage");
        this.addPage((IWizardPage)rpp);
        rpp.createControl(this.pageContainer);
        rpp.setVisible(false);
        rpp.setTitle(ImportWadlWizard.getClassString("pages.response.title", new Object[0]));
        rpp.setDescription(ImportWadlWizard.getClassString("pages.response.description", info.getMethodDescription()));
    }

    private void createOutputPage(ImportInfo info) {
        OutputParametersPage ipp = new OutputParametersPage(info, "OutputParametersPage");
        this.addPage((IWizardPage)ipp);
        ipp.createControl(this.pageContainer);
        ipp.setVisible(false);
        ipp.setTitle(ImportWadlWizard.getClassString("pages.output.title", new Object[0]));
        ipp.setDescription(ImportWadlWizard.getClassString("pages.output.description", info.getMethodDescription()));
    }

    public void createPageControls(Composite pageContainer) {
        this.pageContainer = pageContainer;
        super.createPageControls(pageContainer);
        Savvytest.setDynamicHelp((String)"com.savvytest.eclipse.help.DefaultContextHelp", (Control[])new Control[]{this.getShell()});
    }
}

