/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.common.security.access;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import net.savignano.snotify.atlassian.common.connector.LdapConnector;
import net.savignano.snotify.atlassian.common.enums.EKeySource;
import net.savignano.snotify.atlassian.common.enums.EKeyValidity;
import net.savignano.snotify.atlassian.common.info.InfoData;
import net.savignano.snotify.atlassian.common.security.access.AKeyLoader;
import net.savignano.snotify.atlassian.common.security.key.ISnotifyKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ALdapLoader<T extends ISnotifyKey<?>>
extends AKeyLoader<T> {
    private static final Logger log = LoggerFactory.getLogger(ALdapLoader.class);
    public static final int INFO_NO_USER_FILTER = 200;
    public static final int INFO_LDAP_CONNECTED = 201;
    public static final int INFO_LDAP_DISCONNECTED = 202;
    public static final int INFO_LDAP_CONNECTION_ERROR = 203;
    public static final int INFO_USER_FOUND = 204;
    public static final int INFO_USER_NOT_FOUND = 205;
    private final LdapConnector connector;
    private EKeySource keySource = EKeySource.EXTERNAL_LDAP;
    private String userFilter;
    private String email;

    public ALdapLoader(LdapConnector connector) {
        this(connector, null);
    }

    public ALdapLoader(LdapConnector connector, String userFilter) {
        this.connector = connector;
        this.userFilter = userFilter;
        if (connector == null) {
            throw new IllegalArgumentException("LDAP connector must not be null.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected T loadInternalKey() throws Exception {
        if (this.getUserFilter() == null) {
            log.warn("No user filter given to look up key for in LDAP.");
            this.getInfoDataManager().send(new InfoData(200, new Object[0]));
            return this.getValidityKey(EKeyValidity.ERROR);
        }
        log.info("Looking up key for {} in LDAP.", (Object)this.getUserFilter());
        ISnotifyKey key = null;
        LdapConnector connector = this.getConnector();
        try {
            try {
                log.debug("Connecting to LDAP server: {}", (Object)connector.getUri());
                connector.connect(this.createEnvironment());
            }
            catch (Exception e) {
                log.error("Could not connect to ldap at " + connector.getHost() + " because of exception. Error message: " + e.getMessage(), (Throwable)e);
                this.getInfoDataManager().send(new InfoData(203, connector.getHost(), e));
                Object t = this.getValidityKey(EKeyValidity.ERROR);
                log.debug("Disconnecting from LDAP server.");
                this.getInfoDataManager().send(new InfoData(202, connector.getHost()));
                connector.disconnect();
                return t;
            }
        }
        catch (Throwable throwable) {
            log.debug("Disconnecting from LDAP server.");
            this.getInfoDataManager().send(new InfoData(202, connector.getHost()));
            connector.disconnect();
            throw throwable;
        }
        this.getInfoDataManager().send(new InfoData(201, connector.getHost()));
        try {
            key = (ISnotifyKey)this.loadLdapKey();
        }
        catch (Exception e) {
            throw new Exception("Error retrieving key for " + this.getUserFilter() + " in LDAP. Error message: " + e.getMessage(), e);
        }
        log.debug("Disconnecting from LDAP server.");
        this.getInfoDataManager().send(new InfoData(202, connector.getHost()));
        connector.disconnect();
        if (key == null) {
            key = (ISnotifyKey)this.getValidityKey(EKeyValidity.NOT_FOUND);
        }
        log.info("S/MIME certificate for {} in LDAP is: {}", (Object)this.getUserFilter(), (Object)key.getKeyValidity());
        return (T)key;
    }

    protected abstract T loadLdapKey() throws Exception;

    protected List<Attributes> getAttributes(DirContext context, String dn, String filter, String[] attrNames) throws NamingException {
        log.debug("Looking up information at dn '{}'. Used filter: {}", (Object)dn, (Object)filter);
        SearchControls searchControl = new SearchControls(2, 0L, 10000, attrNames, false, false);
        ArrayList<Attributes> attributes = new ArrayList<Attributes>();
        NamingEnumeration<SearchResult> results = context.search(dn != null ? dn : "", filter, searchControl);
        while (results.hasMore()) {
            SearchResult result = results.next();
            log.debug("Found user information at DN: {}", (Object)result.getNameInNamespace());
            attributes.add(result.getAttributes());
        }
        if (attributes.isEmpty()) {
            log.info("Could not find user {} in LDAP. Search query: {} {}", new Object[]{this.getUserFilter(), dn, filter});
            this.getInfoDataManager().send(new InfoData(205, this.getUserFilter()));
        } else {
            this.getInfoDataManager().send(new InfoData(204, this.getUserFilter()));
        }
        return attributes;
    }

    protected Map<String, String> createEnvironment() {
        return new HashMap<String, String>();
    }

    @Override
    public EKeySource getKeySource() {
        return this.keySource;
    }

    public void setKeySource(EKeySource keySource) {
        this.keySource = keySource != null ? keySource : EKeySource.EXTERNAL_LDAP;
    }

    public LdapConnector getConnector() {
        return this.connector;
    }

    public String getUserFilter() {
        return this.userFilter;
    }

    public void setUserFilter(String userFilter) {
        this.userFilter = userFilter;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [connector=" + this.getConnector() + ", userName=" + this.getUserFilter() + ", email=" + this.getEmail() + "]";
    }
}

