/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.common.security.key.publicly;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import net.savignano.snotify.atlassian.common.enums.ECryptographyType;
import net.savignano.snotify.atlassian.common.enums.EKeyPurpose;
import net.savignano.snotify.atlassian.common.enums.EKeySource;
import net.savignano.snotify.atlassian.common.enums.EKeyValidity;
import net.savignano.snotify.atlassian.common.security.key.ASnotifyKey;
import net.savignano.snotify.atlassian.common.security.key.publicly.ISnotifyPublicKey;
import net.savignano.snotify.atlassian.common.util.PgpUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRing;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSignature;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnotifyPgpPublicKey
extends ASnotifyKey<PGPPublicKey>
implements ISnotifyPublicKey<PGPPublicKey> {
    private static final Logger log = LoggerFactory.getLogger(SnotifyPgpPublicKey.class);
    private final PGPPublicKeyRing ring;
    private final PGPPublicKey masterKey;
    private final PGPPublicKey encryptionKey;
    private int symKeyAlg = -1;

    private static PGPPublicKey findEncryptionKey(PGPPublicKeyRing ring) {
        ArrayList<PGPPublicKey> keys = new ArrayList<PGPPublicKey>();
        for (PGPPublicKey key : ring) {
            if (!SnotifyPgpPublicKey.isValidEncryptionKey(key)) continue;
            keys.add(key);
        }
        PGPPublicKey newestKey = null;
        for (PGPPublicKey key : keys) {
            if (newestKey != null && !newestKey.getCreationTime().before(key.getCreationTime())) continue;
            newestKey = key;
        }
        if (log.isDebugEnabled()) {
            if (newestKey == null) {
                log.debug("No key found that can be used for encryption. Master key ID: {}", (Object)PgpUtil.getPrettyId(ring.getPublicKey()));
            } else {
                log.debug("Using key with ID {}. Creation time: {}", (Object)Long.toHexString(newestKey.getKeyID()).toUpperCase(), (Object)newestKey.getCreationTime());
            }
        }
        return newestKey;
    }

    private static boolean isValidEncryptionKey(PGPPublicKey key) {
        boolean valid;
        String prettyKeyId = PgpUtil.getPrettyId(key);
        if (!key.isEncryptionKey()) {
            log.debug("Algorithm for key with ID {} can not be used for encryption.", (Object)prettyKeyId);
            return false;
        }
        boolean keyFlagsUsed = false;
        boolean encryptionFlag = false;
        Iterator signatures = key.getSignatures();
        while (signatures.hasNext()) {
            PGPSignature signature = (PGPSignature)signatures.next();
            PGPSignatureSubpacketVector packets = signature.getHashedSubPackets();
            if (packets == null) continue;
            int keyFlags = packets.getKeyFlags();
            boolean bl = keyFlagsUsed = keyFlagsUsed || keyFlags != 0;
            if ((keyFlags & 4) == 0) continue;
            encryptionFlag = true;
            break;
        }
        if (!encryptionFlag && keyFlagsUsed) {
            log.debug("Key with ID {} has not the necessary flags for an encryption key.", (Object)prettyKeyId);
            return false;
        }
        if (key.hasRevocation()) {
            log.warn("Key with ID {} has been revoked.", (Object)prettyKeyId);
            return false;
        }
        long validSeconds = key.getValidSeconds();
        boolean bl = valid = validSeconds == 0L || validSeconds * 1000L + key.getCreationTime().getTime() >= System.currentTimeMillis();
        if (!valid) {
            log.warn("Key with ID {} is no loger valid. Expired: {}", (Object)prettyKeyId, (Object)new Date(validSeconds * 1000L + key.getCreationTime().getTime()));
            return false;
        }
        log.debug("Key with ID {} can be used for encryption.", (Object)prettyKeyId);
        return true;
    }

    public SnotifyPgpPublicKey(PGPPublicKeyRing ring) {
        this(ring, null);
    }

    public SnotifyPgpPublicKey(PGPPublicKeyRing ring, String email) {
        super(EKeyPurpose.ENCRYPTION, ECryptographyType.PGP);
        this.ring = ring;
        if (ring == null) {
            log.warn("Key ring was <null>.");
            this.masterKey = null;
            this.encryptionKey = null;
            this.setKeyValidity(EKeyValidity.INVALID);
            return;
        }
        this.masterKey = ring.getPublicKey();
        this.encryptionKey = SnotifyPgpPublicKey.findEncryptionKey(ring);
        if (this.masterKey == null || !this.masterKey.isMasterKey()) {
            log.warn("Passed key ring has no master key. Maybe key ring is corrupt.");
            this.setKeyValidity(EKeyValidity.INVALID);
        } else if (this.encryptionKey == null) {
            log.warn("No valid encryption key was found to encrypt emails. Corresponding master key ID: {}", (Object)PgpUtil.getPrettyId(this.masterKey));
            this.setKeyValidity(EKeyValidity.INVALID);
        } else if (email != null && !PgpUtil.isKeyForEmail(this.masterKey, email)) {
            log.warn("Key ring is no match for email address: <{}>", (Object)email);
            this.setKeyValidity(EKeyValidity.INVALID);
        }
    }

    public SnotifyPgpPublicKey(EKeyValidity validity) {
        this(validity, EKeySource.UNKNOWN);
    }

    public SnotifyPgpPublicKey(EKeyValidity validity, EKeySource keySource) {
        super(EKeyPurpose.ENCRYPTION, ECryptographyType.PGP);
        this.ring = null;
        this.masterKey = null;
        this.encryptionKey = null;
        this.setKeyValidity(validity);
        this.setKeySource(keySource);
    }

    @Override
    public byte[] getEncoded() throws IOException {
        if (this.ring == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        this.ring.encode(baos, true);
        return baos.toByteArray();
    }

    public PGPPublicKeyRing getKeyRing() {
        return this.ring;
    }

    public PGPPublicKey getMasterKey() {
        return this.masterKey;
    }

    @Override
    public PGPPublicKey getKey() {
        return this.encryptionKey;
    }

    public PGPPublicKey getKey(long keyId) {
        if (this.ring == null) {
            return null;
        }
        return this.ring.getPublicKey(keyId);
    }

    public int getSymmetricKeyAlgorithm() {
        if (this.symKeyAlg == -1) {
            this.symKeyAlg = this.loadSymmetricKeyAlgorithm();
        }
        return this.symKeyAlg;
    }

    private int loadSymmetricKeyAlgorithm() {
        if (this.getMasterKey() == null) {
            return 0;
        }
        int[] algorithms = PgpUtil.getPreferredSymmetricKeyAlgorithms(this.getMasterKey());
        if (algorithms.length != 0) {
            for (int algorithm : algorithms) {
                if (PgpUtil.isSupportedSymmetricKeyAlgorithm(algorithm)) {
                    return algorithm;
                }
                log.warn("Symmetric key algorithm {} for key {} is not supported.", (Object)PgpUtil.getSymmetricCipherName(algorithm), (Object)PgpUtil.getPrettyId(this.getKey()));
            }
            log.warn("No compatible symmetric key algorithm found for key {}. Using default algorithm.", (Object)PgpUtil.getPrettyId(this.getKey()));
        } else {
            log.warn("Preferred symmetric key algorithm information for key {} was missing. Using default algorithm.", (Object)PgpUtil.getPrettyId(this.getKey()));
        }
        return 7;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(200);
        builder.append("PGP Public Key. ");
        builder.append("Key Validity: ");
        builder.append((Object)this.getKeyValidity());
        builder.append("; Key Purpose: ");
        builder.append((Object)this.getKeyPurpose());
        builder.append("; Key Source: ");
        builder.append((Object)this.getKeySource());
        builder.append("; Encryption Key ID: ");
        builder.append(PgpUtil.getPrettyId(this.getKey()));
        builder.append("; Master Key ID: ");
        builder.append(PgpUtil.getPrettyId(this.getMasterKey()));
        builder.append("; Symmetric Key Algorithm: ");
        builder.append(PgpUtil.getSymmetricCipherName(this.getSymmetricKeyAlgorithm()));
        builder.append(" (");
        builder.append(this.getSymmetricKeyAlgorithm());
        builder.append(")");
        return builder.toString();
    }
}

